/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.PlayListSorter;
import com.limegroup.gnutella.mp3.MP3Info;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Random;
import com.sun.java.util.collections.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

public class PlayList {
    private File _file;
    private Vector _songs;
    private Vector _newSongs;
    private int _currPlaying = -1;
    private boolean _songDeleted = false;
    private boolean _backwardsMode = false;
    private int _lastIndexPlayed = 0;
    private boolean _shuffleSongs = false;
    Random rand = new Random();
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";
    private boolean _sortAscending = false;
    private final boolean debugOn = false;

    public int getCurrSongIndex() {
        this.debug("PlayList.getCurrSongIndex(): current index = " + this._currPlaying);
        return this._currPlaying;
    }

    public int setCurrSongIndex(int index) {
        this._currPlaying = index;
        return this._currPlaying;
    }

    public void setBackwardsMode() {
        this._backwardsMode = true;
    }

    public boolean isShuffled() {
        return this._shuffleSongs;
    }

    public void toggleShuffle() {
        this._shuffleSongs = !this._shuffleSongs;
        this.debug("PlayList.toggleShuffle(): shuffle? " + this._shuffleSongs);
    }

    public PlayList(String filename) throws Exception {
        this.debug("PlayList(): entered.");
        this._file = new File(filename);
        if (this._file.isDirectory()) {
            throw new Exception();
        }
        this._songs = new Vector();
        if (this._file.exists()) {
            this.loadM3UFile();
        }
        this._newSongs = new Vector();
        this.debug("PlayList(): songs = " + this._songs);
        this.debug("PlayList(): returning.  size is now " + this.getNumSongs());
    }

    private void loadM3UFile() throws Exception {
        try {
            BufferedReader m3uFile = new BufferedReader(new FileReader(this._file));
            String currLine = null;
            currLine = m3uFile.readLine();
            if (!currLine.startsWith(M3U_HEADER)) {
                throw new Exception();
            }
            currLine = m3uFile.readLine();
            while (currLine != null) {
                File toAdd;
                if (currLine.startsWith(SONG_DELIM) && (toAdd = new File(currLine = m3uFile.readLine())).exists() && !toAdd.isDirectory()) {
                    this._songs.add(toAdd);
                }
                currLine = m3uFile.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public synchronized void save() throws Exception {
        try {
            if (this._songs.size() == 0 && this._file.exists()) {
                this._file.delete();
            }
            boolean fileExists = this._file.exists();
            FileWriter fw = new FileWriter(this._file.getCanonicalPath(), true);
            PrintWriter m3uFile = new PrintWriter(fw);
            if (!fileExists) {
                m3uFile.write(M3U_HEADER);
                m3uFile.println();
            }
            int i = 0;
            while (i < this._newSongs.size()) {
                File currFile = (File)this._newSongs.get(i);
                m3uFile.write(SONG_DELIM);
                m3uFile.write(SEC_DELIM);
                try {
                    MP3Info currMP3 = new MP3Info(currFile.getCanonicalPath());
                    m3uFile.write("" + currMP3.getLengthInSeconds() + ",");
                }
                catch (Exception ignored) {
                    m3uFile.write("-1,");
                }
                m3uFile.write(currFile.getName());
                m3uFile.println();
                m3uFile.write(currFile.getCanonicalPath());
                m3uFile.println();
                this._songs.add(currFile);
                ++i;
            }
            m3uFile.flush();
            m3uFile.close();
            this._songDeleted = false;
            this._newSongs.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception();
        }
    }

    public int getNumSongs() {
        return this._songs.size() + this._newSongs.size();
    }

    public int addSong(String filename) {
        return this.addSong(new File(filename));
    }

    public synchronized void deleteSong(int index) {
        if (!this._songDeleted) {
            Vector temp = this._newSongs;
            this._newSongs = new Vector();
            int i = 0;
            while (i < this._songs.size()) {
                this._newSongs.add(this._songs.get(i));
                ++i;
            }
            int i2 = 0;
            while (i2 < temp.size()) {
                this._newSongs.add(temp.get(i2));
                ++i2;
            }
            this._songs.clear();
            temp = null;
            this._songDeleted = true;
        }
        if (index >= 0 && index < this._newSongs.size()) {
            this._newSongs.remove(index);
        }
        if (this._currPlaying == index) {
            this._currPlaying = -1;
        } else if (this._currPlaying > index) {
            --this._currPlaying;
        }
        if (this._lastIndexPlayed == index) {
            this._lastIndexPlayed = 0;
        }
    }

    public int addSong(File newEntry) {
        int retInt = -1;
        if (newEntry.exists() && !newEntry.isDirectory()) {
            retInt = this.getNumSongs();
            this._newSongs.add(newEntry);
        }
        return retInt;
    }

    private int getNextSongIndex() {
        this.debug("PlayList.getNextSongIndex(): BEFORE _currPlaying = " + this._currPlaying);
        int numSongs = this.getNumSongs();
        if (this.isShuffled()) {
            if (this._backwardsMode) {
                this._currPlaying = this._lastIndexPlayed;
                this._backwardsMode = false;
            } else {
                int tempInt = this._currPlaying;
                if (this._currPlaying > -1) {
                    this._lastIndexPlayed = this._currPlaying;
                }
                do {
                    this._currPlaying = this.rand.nextInt(numSongs);
                } while (tempInt == this._currPlaying && numSongs > 1);
            }
        } else if (this._backwardsMode) {
            --this._currPlaying;
            if (this._currPlaying < 0) {
                this._currPlaying = numSongs - 1;
            }
            this._backwardsMode = false;
        } else if (++this._currPlaying >= numSongs) {
            this._currPlaying = 0;
        }
        this.debug("PlayList.getNextSongIndex(): AFTER _currPlaying = " + this._currPlaying);
        return this._currPlaying;
    }

    public synchronized File getNextSong() {
        File retFile = null;
        Vector vector = this._songs;
        synchronized (vector) {
            Vector vector2 = this._newSongs;
            synchronized (vector2) {
                if (this.getNumSongs() > 0) {
                    int nextIndex = this.getNextSongIndex();
                    retFile = nextIndex < this._songs.size() ? (File)this._songs.get(nextIndex) : (File)this._newSongs.get(nextIndex - this._songs.size());
                }
            }
        }
        return retFile;
    }

    public File getSong(int index) {
        File retFile = null;
        if (index < this.getNumSongs()) {
            retFile = index < this._songs.size() ? (File)this._songs.get(index) : (File)this._newSongs.get(index - this._songs.size());
        }
        return retFile;
    }

    public int getIndexOfSong(File in) {
        int retInt = -1;
        if (this._songs.contains(in)) {
            retInt = this._songs.indexOf(in);
        } else if (this._newSongs.contains(in)) {
            retInt = this._songs.size() + this._newSongs.indexOf(in);
        }
        return retInt;
    }

    public synchronized void sortByName() {
        this.deleteSong(-1);
        this._currPlaying = -1;
        this._sortAscending = !this._sortAscending;
        Collections.sort(this._newSongs, PlayListSorter.getInstance(this._sortAscending));
    }

    private void debug(String out) {
    }

    public static void main(String[] argv) throws Exception {
        PlayList pl = new PlayList(argv[0]);
        System.out.println("Number of songs: " + pl.getNumSongs());
        System.out.println("----------------------------");
        int i = 0;
        while (i < pl.getNumSongs()) {
            System.out.println("" + pl.getSong(i));
            ++i;
        }
        System.out.println("----------------------------");
        pl.toggleShuffle();
        int i2 = 0;
        while (i2 < pl.getNumSongs()) {
            System.out.println("" + pl.getNextSong());
            ++i2;
        }
        System.out.println("----------------------------");
        if (pl.getNumSongs() > 0) {
            pl.addSong(pl.getSong(0));
        } else {
            pl.addSong(new File("./limewire.props"));
            pl.addSong(new File("./gnutella.net"));
        }
        System.out.println("" + pl.getSong(pl.getNumSongs() - 1));
        pl.save();
    }
}

