/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.IOException;

abstract class AbstractAudioPlayer
implements AudioPlayer {
    private List _listeners;

    AbstractAudioPlayer() {
    }

    public abstract int getStatus();

    public abstract void unpause();

    public abstract void pause();

    public abstract void stop();

    public abstract void play(File var1) throws IOException;

    public abstract int getFrameSeek();

    public abstract void refresh();

    public void addAudioPlayerListener(AudioPlayerListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    protected void fireAudioPositionUpdated(int pos) {
        int i = 0;
        while (i < this._listeners.size()) {
            ((AudioPlayerListener)this._listeners.get(i)).updateAudioPosition(pos);
            ++i;
        }
    }

    protected void fireSeekSetupRequired(int numberOfFrames) {
        int i = 0;
        while (i < this._listeners.size()) {
            ((AudioPlayerListener)this._listeners.get(i)).setUpSeek(numberOfFrames);
            ++i;
        }
    }

    protected void firePlayComplete() {
        int i = 0;
        while (i < this._listeners.size()) {
            ((AudioPlayerListener)this._listeners.get(i)).playComplete();
            ++i;
        }
    }
}

