/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTreeCellEditor;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.ArrayList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

final class LibraryTree {
    private final String INCOMPLETE_FILE_NAME = "Incomplete";
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final JTree TREE = new JTree();
    private final LibraryTreeNode ROOT_NODE = new LibraryTreeNode();
    private final DefaultTreeModel TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
    private final JPopupMenu DIRECTORY_POPUP = new JPopupMenu();

    LibraryTree() {
        this.TREE.setModel(this.TREE_MODEL);
        this.TREE.setRootVisible(false);
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.setEditable(true);
        this.TREE.setInvokesStopCellEditing(true);
        this.TREE.setShowsRootHandles(true);
        this.TREE.putClientProperty("JTree.lineStyle", "None");
        this.makePopupMenu();
        this.TREE.addTreeSelectionListener(new LibraryTreeSelectionListener());
        this.TREE.setCellEditor(new DefaultTreeCellEditor(this.TREE, (DefaultTreeCellRenderer)this.TREE.getCellRenderer(), new LibraryTreeCellEditor(this)));
        this.addIncompleteDirectory();
        this.updateTheme();
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.TREE.setBackground(tableColor);
        DefaultTreeCellRenderer rnd = new DefaultTreeCellRenderer();
        rnd.setOpaque(false);
        this.TREE.setCellRenderer(rnd);
        this.TREE.setCellEditor(new DefaultTreeCellEditor(this.TREE, (DefaultTreeCellRenderer)this.TREE.getCellRenderer(), new LibraryTreeCellEditor(this)));
    }

    void cancelEditing() {
        if (this.TREE.isEditing()) {
            this.TREE.getCellEditor().cancelCellEditing();
        }
    }

    void addSharedDirectory(File dir, File parent) {
        LibraryTreeNode curNode = null;
        LibraryTreeNode nodeToLoad = null;
        InternalNodeFileHolder holder = null;
        if (parent == null) {
            if (!this.ROOT_NODE.isChild(dir)) {
                holder = new InternalNodeFileHolder(dir);
                curNode = new LibraryTreeNode(holder);
                this.TREE_MODEL.insertNodeInto(curNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 1);
                nodeToLoad = this.ROOT_NODE;
            }
        } else {
            AbstractFileHolder curHolder = null;
            Enumeration<TreeNode> enumeration = this.ROOT_NODE.breadthFirstEnumeration();
            if (enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    curNode = (LibraryTreeNode)enumeration.nextElement();
                    curHolder = curNode.getFileHolder();
                    if (!curHolder.matchesFile(parent)) continue;
                    if (!curNode.isChild(dir)) {
                        holder = new InternalNodeFileHolder(dir);
                        LibraryTreeNode newNode = new LibraryTreeNode(holder);
                        this.TREE_MODEL.insertNodeInto(newNode, curNode, curNode.getChildCount());
                        nodeToLoad = curNode;
                    }
                    break;
                }
            } else {
                InternalNodeFileHolder newHolder = new InternalNodeFileHolder(dir);
                curNode = new LibraryTreeNode(newHolder);
                this.TREE_MODEL.insertNodeInto(curNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 1);
                nodeToLoad = this.ROOT_NODE;
            }
        }
        this.cancelEditing();
        int[] selected = this.TREE.getSelectionRows();
        this.TREE_MODEL.reload(nodeToLoad);
        if (selected == null || selected.length == 0) {
            this.setSelectionRow(0);
        } else {
            this.setSelectionRow(selected[0]);
        }
    }

    void addNewLibraryFolder() {
        LibraryTreeNode selectedNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage("add a new folder to");
            return;
        }
        File curFile = selectedNode.getFileHolder().getFile();
        File file = new File(curFile, "New Folder");
        int number = 2;
        boolean dirMade = false;
        while (!dirMade) {
            dirMade = file.mkdir();
            if (dirMade) {
                LibraryTreeNode node = new LibraryTreeNode(new InternalNodeFileHolder(file));
                this.TREE_MODEL.insertNodeInto(node, selectedNode, selectedNode.getChildCount());
                this.TREE.expandRow(this.TREE.getLeadSelectionRow());
                this.TREE.setSelectionRow(this.TREE.getLeadSelectionRow() + selectedNode.getChildCount());
                this.LIBRARY_MEDIATOR.refresh();
            } else {
                file = new File(curFile, "New Folder (" + String.valueOf(number) + ")");
            }
            ++number;
        }
    }

    void renameLibraryFolder() {
        LibraryTreeNode selectedNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        if (!this.incompleteDirectoryIsSelected()) {
            this.TREE.startEditingAtPath(this.TREE.getLeadSelectionPath());
        } else {
            this.showIncompleteFolderMessage("rename");
        }
    }

    void addPlayListEntries() {
        LibraryTreeNode selectedNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            return;
        }
        final File currFile = selectedNode.getFileHolder().getFile();
        new ManagedThread("PlayListEntryAdder"){

            public void managedRun() {
                PlayListGUI plInstance;
                String[] filter = new String[]{"mp3"};
                File[] filesToAdd = FileManager.getFilesRecursive(currFile, filter);
                PlayListGUI playListGUI = plInstance = PlayListGUI.instance();
                synchronized (playListGUI) {
                    int i = 0;
                    while (filesToAdd != null && i < filesToAdd.length) {
                        plInstance.addFileToPlayList(filesToAdd[i]);
                        ++i;
                    }
                }
            }
        }.start();
    }

    File getFileForPoint(Point mousePoint) {
        TreePath path = this.TREE.getPathForLocation(mousePoint.x, mousePoint.y);
        if (path == null) {
            return null;
        }
        LibraryTreeNode node = (LibraryTreeNode)path.getLastPathComponent();
        AbstractFileHolder fh = node.getFileHolder();
        File file = fh.getFile();
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point mousePoint) {
        TreePath path = this.TREE.getPathForLocation(mousePoint.x, mousePoint.y);
        if (path == null) {
            return false;
        }
        LibraryTreeNode node = (LibraryTreeNode)path.getLastPathComponent();
        if (node == null) {
            return false;
        }
        return this.isIncompleteDirectory(node.getFileHolder());
    }

    File getSelectedDirectory() {
        LibraryTreeNode selectedNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return null;
        }
        return selectedNode.getFileHolder().getFile();
    }

    File[] getSharedDirectories() {
        int length = this.ROOT_NODE.getChildCount();
        ArrayList newFiles = new ArrayList();
        int i = 0;
        while (i < length) {
            File f;
            LibraryTreeNode curNode = (LibraryTreeNode)this.ROOT_NODE.getChildAt(i);
            AbstractFileHolder fh = curNode.getFileHolder();
            if (!this.isIncompleteDirectory(fh) && (f = fh.getFile()).isDirectory()) {
                newFiles.add(f);
            }
            ++i;
        }
        File[] files = new File[newFiles.size()];
        int r = 0;
        while (r < newFiles.size()) {
            files[r] = (File)newFiles.get(r);
            ++r;
        }
        return files;
    }

    void setSelectionRow(int row) {
        this.TREE.setSelectionRow(row);
    }

    boolean parentIsSelected(File parent) {
        LibraryTreeNode node = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return node.getFileHolder().matchesFile(parent);
    }

    void clear() {
        this.ROOT_NODE.removeAllChildren();
        this.addIncompleteDirectory();
    }

    AbstractFileHolder handleNameChange(String newName) {
        LibraryTreeNode selectedNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return null;
        }
        if (newName.equals(selectedNode.getFileHolder().toString())) {
            return selectedNode.getFileHolder();
        }
        File f = selectedNode.getFileHolder().getFile();
        String parent = f.getParent();
        if (parent == null) {
            return null;
        }
        File newFile = new File(parent, newName);
        boolean b = f.renameTo(newFile);
        if (!b) {
            this.showFolderRenameError(f.getPath());
            return null;
        }
        InternalNodeFileHolder fh = new InternalNodeFileHolder(newFile);
        selectedNode.setUserObject(fh);
        this.TREE_MODEL.nodeChanged(selectedNode);
        if (!selectedNode.isLeaf()) {
            selectedNode.removeAllChildren();
        }
        this.handleDirectoryChange(selectedNode);
        return selectedNode.getFileHolder();
    }

    void unshareLibraryFolder() {
        LibraryTreeNode node = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage("delete");
        } else if (!node.getLibraryTreeNodeParent().isRoot()) {
            GUIMediator.showMessage("MESSAGE_CANNOT_UNSHARE_SUBDIRS");
        } else {
            String msgKey = "MESSAGE_CONFIRM_UNSHARE_DIRECTORY";
            int response = GUIMediator.showYesNoMessage(msgKey, QuestionsHandler.UNSHARE_DIRECTORY);
            if (response != 101) {
                return;
            }
            this.TREE_MODEL.removeNodeFromParent(node);
            this.LIBRARY_MEDIATOR.handleRootSharedDirectoryChange();
        }
    }

    boolean incompleteDirectoryIsSelected() {
        LibraryTreeNode node = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return this.isIncompleteDirectory(node.getFileHolder());
    }

    void setCursor(Cursor cursor) {
        this.TREE.setCursor(cursor);
    }

    Point getTreeLocation() {
        return this.TREE.getLocationOnScreen();
    }

    Dimension getTreeSize() {
        return this.TREE.getSize();
    }

    JTree getTree() {
        return this.TREE;
    }

    private boolean isIncompleteDirectory(AbstractFileHolder holder) {
        return holder.toString().equals("Incomplete");
    }

    private void addIncompleteDirectory() {
        try {
            File incFile = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
            if (incFile == null) {
                throw new FileNotFoundException();
            }
            InternalNodeFileHolder fh = new InternalNodeFileHolder(incFile);
            LibraryTreeNode node = new LibraryTreeNode(fh);
            this.TREE_MODEL.insertNodeInto(node, this.ROOT_NODE, 0);
            this.TREE_MODEL.reload(this.ROOT_NODE);
        }
        catch (FileNotFoundException e) {
            GUIMediator.showInternalError(e);
        }
    }

    private void showIncompleteFolderMessage(String action) {
        String key1 = "MESSAGE_INCOMPLETE_DIRECTORY_START";
        String key2 = "MESSAGE_INCOMPLETE_DIRECTORY_END";
        GUIMediator.showError(key1, (Object)action, key2);
    }

    private void showFolderDeletionError(String folderName) {
        String key1 = "MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START";
        String key2 = "MESSAGE_UNABLE_TO_CHANGE_DIRECTORY_END";
        String msg = "'" + folderName + "'.";
        GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START", (Object)msg, "MESSAGE_UNABLE_TO_CHANGE_DIRECTORY_END");
    }

    private void showFolderRenameError(String folderName) {
        String key1 = "MESSAGE_UNABLE_TO_RENAME_DIRECTORY_START";
        String key2 = "MESSAGE_UNABLE_TO_CHANGE_DIRECTORY_END";
        String msg = "'" + folderName + "'.";
        GUIMediator.showError("MESSAGE_UNABLE_TO_RENAME_DIRECTORY_START", (Object)msg, "MESSAGE_UNABLE_TO_CHANGE_DIRECTORY_END");
    }

    private void handleDirectoryChange(LibraryTreeNode node) {
        if (node.getLibraryTreeNodeParent().isRoot()) {
            this.LIBRARY_MEDIATOR.handleRootSharedDirectoryChange();
        } else {
            this.LIBRARY_MEDIATOR.refresh();
        }
    }

    private void makePopupMenu() {
        JMenuItem newItem = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_NEW_FOLDER_LABEL"));
        JMenuItem unshareItem = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_UNSHARE_FOLDER_LABEL"));
        JMenuItem renameItem = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_RENAME_FOLDER_LABEL"));
        JMenuItem addPlayListItem = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_TO_PLAYLIST_FOLDER_LABEL"));
        newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    LibraryTree.this.addNewLibraryFolder();
                }
                catch (Throwable t) {
                    GUIMediator.showInternalError(t);
                }
            }
        });
        unshareItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    LibraryTree.this.unshareLibraryFolder();
                }
                catch (Throwable t) {
                    GUIMediator.showInternalError(t);
                }
            }
        });
        renameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    LibraryTree.this.renameLibraryFolder();
                }
                catch (Throwable t) {
                    GUIMediator.showInternalError(t);
                }
            }
        });
        addPlayListItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    LibraryTree.this.addPlayListEntries();
                }
                catch (Throwable t) {
                    GUIMediator.showInternalError(t);
                }
            }
        });
        this.DIRECTORY_POPUP.add(newItem);
        this.DIRECTORY_POPUP.add(unshareItem);
        this.DIRECTORY_POPUP.add(renameItem);
        if (!CommonUtils.isMacClassic()) {
            this.DIRECTORY_POPUP.add(addPlayListItem);
        }
        MouseAdapter ml = new MouseAdapter(){

            public void checkPopUp(MouseEvent e) {
                try {
                    int row = LibraryTree.this.TREE.getRowForLocation(e.getX(), e.getY());
                    if (row == -1) {
                        return;
                    }
                    LibraryTree.this.TREE.setSelectionRow(row);
                    if ((e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) && !LibraryTree.this.incompleteDirectoryIsSelected()) {
                        LibraryTree.this.DIRECTORY_POPUP.show(LibraryTree.this.TREE, e.getX(), e.getY());
                    }
                }
                catch (Throwable t) {
                    GUIMediator.showInternalError(t);
                }
            }

            public void mouseClicked(MouseEvent e) {
                this.checkPopUp(e);
            }

            public void mousePressed(MouseEvent e) {
                this.checkPopUp(e);
            }
        };
        this.TREE.addMouseListener(ml);
    }

    private class RootNodeFileHolder
    extends AbstractFileHolder {
        private RootNodeFileHolder() {
        }

        protected File getFile() {
            return null;
        }

        protected boolean matchesFile(File file) {
            return false;
        }

        public String toString() {
            return "";
        }
    }

    private class InternalNodeFileHolder
    extends AbstractFileHolder {
        private final File FILE;

        InternalNodeFileHolder(File file) {
            this.FILE = file;
        }

        protected File getFile() {
            return this.FILE;
        }

        protected boolean matchesFile(File file) {
            return this.FILE.equals(file);
        }

        public String toString() {
            return this.FILE.getName();
        }
    }

    private abstract class AbstractFileHolder {
        private AbstractFileHolder() {
        }

        protected abstract File getFile();

        protected abstract boolean matchesFile(File var1);
    }

    private final class LibraryTreeNode
    extends DefaultMutableTreeNode {
        private AbstractFileHolder _holder;

        private LibraryTreeNode() {
            this._holder = new RootNodeFileHolder();
        }

        private LibraryTreeNode(AbstractFileHolder holder) {
            super(holder);
            this._holder = holder;
            if (this._holder == null) {
                throw new NullPointerException("null holder in LibraryTreeNode");
            }
        }

        private AbstractFileHolder getFileHolder() {
            return this._holder;
        }

        private boolean isChild(File file) {
            int count = this.getChildCount();
            int i = 0;
            while (i < count) {
                LibraryTreeNode curNode = (LibraryTreeNode)this.getChildAt(i);
                File curFile = curNode.getFileHolder().getFile();
                if (curFile.equals(file)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void setUserObject(Object holder) {
            if (holder == null) {
                return;
            }
            if (!(holder instanceof AbstractFileHolder)) {
                throw new IllegalArgumentException("unexpected object: " + holder);
            }
            super.setUserObject(holder);
            this._holder = (AbstractFileHolder)holder;
        }

        private LibraryTreeNode getLibraryTreeNodeParent() {
            TreeNode parentNode = super.getParent();
            if (parentNode == null) {
                return null;
            }
            return (LibraryTreeNode)parentNode;
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            try {
                LibraryTreeNode node = (LibraryTreeNode)LibraryTree.this.TREE.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (!LibraryTree.this.incompleteDirectoryIsSelected()) {
                    LibraryTree.this.LIBRARY_MEDIATOR.updateTableFiles(node.getFileHolder().getFile());
                } else {
                    LibraryTree.this.LIBRARY_MEDIATOR.showIncompleteFiles();
                }
            }
            catch (Throwable t) {
                GUIMediator.showInternalError(t);
            }
        }
    }
}

