/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableButtons;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.library.LibraryTablePopupMenu;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.gui.MetaEditorFrame;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class LibraryTableMediator
extends AbstractTableMediator {
    private static final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    public static ActionListener LAUNCH_LISTENER;
    public static ActionListener ADD_PLAY_LIST_LISTENER;
    public static ActionListener ANNOTATE_LISTENER;
    public static ActionListener BITZI_LOOKUP_LISTENER;
    public static ActionListener MAGNET_LOOKUP_LISTENER;
    public static ActionListener RESUME_LISTENER;
    private boolean _shiftPressed;
    private boolean _multiSelection;
    private int _indexCandidate;
    private boolean _allowAnnotate;
    private boolean _allowResume;
    private static LibraryTableMediator _instance;

    public static LibraryTableMediator instance() {
        return _instance;
    }

    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_LISTENER = new LaunchListener();
        ADD_PLAY_LIST_LISTENER = new AddPLFileListener();
        ANNOTATE_LISTENER = new AnnotateListener();
        BITZI_LOOKUP_LISTENER = new BitziLookupListener();
        MAGNET_LOOKUP_LISTENER = new MagnetLookupListener();
        RESUME_LISTENER = new ResumeListener();
    }

    protected void setupConstants() {
        this.MAIN_PANEL = null;
        this.DATA_MODEL = new LibraryTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryTableModel)this.DATA_MODEL).setTable(this.TABLE);
        this.BUTTON_ROW = new LibraryTableButtons(this).getComponent();
    }

    protected JPopupMenu createPopupMenu() {
        boolean selection;
        JPopupMenu menu = new LibraryTablePopupMenu(this).getComponent();
        boolean bl = selection = !this.TABLE.getSelectionModel().isSelectionEmpty();
        if (selection) {
            if (GUIMediator.isPlaylistVisible()) {
                menu.getComponent(4).setEnabled(true);
            }
            if (this._allowAnnotate) {
                menu.getComponent(2).setEnabled(true);
            }
            if (this._allowResume) {
                menu.getComponent(3).setEnabled(true);
            }
            menu.getComponent(0).setEnabled(true);
            menu.getComponent(1).setEnabled(true);
            menu.getComponent(5).setEnabled(true);
            menu.getComponent(6).setEnabled(true);
        } else {
            if (GUIMediator.isPlaylistVisible()) {
                menu.getComponent(4).setEnabled(false);
            }
            menu.getComponent(2).setEnabled(false);
            menu.getComponent(3).setEnabled(false);
            menu.getComponent(0).setEnabled(false);
            menu.getComponent(1).setEnabled(false);
            menu.getComponent(5).setEnabled(false);
            menu.getComponent(6).setEnabled(false);
        }
        return menu;
    }

    protected void setDefaultEditors() {
        TableColumnModel model = this.TABLE.getColumnModel();
        TableColumn tc = model.getColumn(1);
        tc.setCellEditor(new LibraryTableCellEditor(this));
    }

    protected void setupTable() {
        super.setupTable();
        this.TABLE.addKeyListener(new LibraryKeyListener());
        LibraryListSelectionModel selectionModel = new LibraryListSelectionModel();
        selectionModel.setSelectionMode(1);
        this.TABLE.setSelectionModel(selectionModel);
    }

    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    protected void updateSplashScreen() {
    }

    private LibraryTableMediator() {
        super("LIBRARY_TABLE");
        GUIMediator.addThemeObserver(this);
    }

    public JComponent getComponent() {
        return null;
    }

    void cancelEditing() {
    }

    void addMouseInputListener(MouseInputListener listener) {
        this.TABLE.addMouseListener(listener);
        this.TABLE.addMouseMotionListener(listener);
    }

    public void setAnnotateEnabled(boolean enabled) {
        this._allowAnnotate = enabled;
        LibraryTableDataLine.setXMLEnabled(enabled);
        if (!enabled) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, true);
        }
    }

    void setResumeEnabled(boolean enabled) {
        this._allowResume = enabled;
        if (!enabled) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, true);
        }
    }

    File getFile(int row) {
        return ((LibraryTableModel)this.DATA_MODEL).getFile(row);
    }

    void setMultiSelection(boolean multiSelection) {
        this._multiSelection = multiSelection;
    }

    boolean getMultiSelection() {
        return this._multiSelection;
    }

    int getIndexCandidate() {
        return this._indexCandidate;
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    void editMeta() {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        int index = rows[k - 1];
        FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(index);
        if (fd == null) {
            return;
        }
        String fullName = "";
        try {
            fullName = fd.getFile().getCanonicalPath();
        }
        catch (IOException ee) {
            return;
        }
        JFrame mainF = GUIMediator.getAppFrame();
        MetaEditorFrame metaEditor = new MetaEditorFrame(fd, fullName, mainF);
        metaEditor.show();
    }

    void doBitziLookup() {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        int index = rows[k - 1];
        FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(index);
        if (fd == null) {
            return;
        }
        URN urn = fd.getSHA1Urn();
        if (urn == null) {
            return;
        }
        String urnStr = urn.toString();
        int hashstart = 1 + urnStr.indexOf(":", 4);
        String lookupUrl = "http://bitzi.com/lookup/" + urnStr.substring(hashstart) + "?ref=limewire";
        try {
            Launcher.openURL(lookupUrl);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    void doMagnetLookup() {
        this.doMagnetCommand("/magcmd/detail?");
    }

    void doMagnetCommand(String cmd) {
        int[] rows = this.TABLE.getSelectedRows();
        int k = rows.length;
        if (k == 0) {
            return;
        }
        boolean haveValidMagnet = false;
        int count = 0;
        int port = RouterService.getHTTPAcceptor().getPort();
        int eport = RouterService.getAcceptor().getPort(true);
        byte[] eaddr = RouterService.getAcceptor().getAddress(true);
        String lookupUrl = "http://localhost:" + port + cmd + "addr=" + NetworkUtils.ip2string(eaddr) + ":" + eport;
        int i = 0;
        while (i < k) {
            FileDesc fd = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(rows[i]);
            if (fd != null) {
                URN urn = fd.getSHA1Urn();
                String urnStr = urn.toString();
                int hashstart = 1 + urnStr.indexOf(":", 4);
                if (urn != null) {
                    String sha1 = urnStr.substring(hashstart);
                    lookupUrl = lookupUrl + "&n" + count + "=" + URLEncoder.encode(fd.getName()) + "&u" + count + "=" + sha1;
                    ++count;
                    haveValidMagnet = true;
                }
            }
            ++i;
        }
        if (haveValidMagnet) {
            try {
                Launcher.openURL(lookupUrl);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void removeSelection() {
        String msgKey = "MESSAGE_CONFIRM_FILE_DELETE";
        int response = GUIMediator.showYesNoMessage(msgKey);
        if (response != 101) {
            return;
        }
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length <= 0) {
            return;
        }
        Arrays.sort(rows);
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        ArrayList errors = new ArrayList();
        int i = rows.length - 1;
        while (i >= 0) {
            File file = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            if (file.delete()) {
                this.DATA_MODEL.remove(rows[i]);
                RouterService.getFileManager().removeFileIfShared(file);
            } else {
                errors.add(file.getName());
            }
            --i;
        }
        this.clearSelection();
        int i2 = 0;
        while (i2 < errors.size()) {
            String name = (String)errors.get(i2);
            String key1 = "MESSAGE_UNABLE_TO_DELETE_FILE_START";
            String key2 = "MESSAGE_UNABLE_TO_DELETE_FILE_END";
            String msg = "'" + name + "'.";
            GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", (Object)msg, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
            ++i2;
        }
    }

    public void handleMouseDoubleClick(MouseEvent e) {
        this.launch();
    }

    void resumeIncomplete() {
        int[] rows = this.TABLE.getSelectedRows();
        boolean startedDownload = false;
        ArrayList errors = new ArrayList();
        int i = 0;
        while (i < rows.length) {
            File incomplete = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
            try {
                RouterService.download(incomplete);
                startedDownload = true;
            }
            catch (AlreadyDownloadingException e) {
                errors.add(e);
            }
            catch (CantResumeException e) {
                errors.add(e);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < errors.size()) {
            Exception e = (Exception)errors.get(i2);
            if (e instanceof AlreadyDownloadingException) {
                GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", (Object)("\"" + ((AlreadyDownloadingException)e).getFilename() + "\"."), QuestionsHandler.ALREADY_DOWNLOADING);
            } else if (e instanceof CantResumeException) {
                GUIMediator.showError("ERROR_CANT_RESUME_START", "\"" + ((CantResumeException)e).getFilename() + "\"", "ERROR_CANT_RESUME_END", QuestionsHandler.CANT_RESUME);
            }
            ++i2;
        }
        if (startedDownload) {
            GUIMediator.instance().setWindow(0);
        }
    }

    void launch() {
        int[] rows = this.TABLE.getSelectedRows();
        boolean mp3Launched = false;
        int i = 0;
        int l = rows.length;
        while (i < l) {
            try {
                File currFile = ((LibraryTableModel)this.DATA_MODEL).getFile(rows[i]);
                if (GUIMediator.isPlaylistVisible() && (CommonUtils.canLaunchFileWithQuickTime(currFile) || LimeXMLUtils.isMP3File(currFile))) {
                    if (!mp3Launched) {
                        LIBRARY_MEDIATOR.launchAudio(currFile);
                        mp3Launched = true;
                    }
                } else {
                    GUIMediator.launchFile(currFile);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ++i;
        }
    }

    String handleNameChange(String newName) {
        int row = this.TABLE.getEditingRow();
        File oldFile = ((LibraryTableModel)this.DATA_MODEL).getFile(row);
        String parent = oldFile.getParent();
        String nameToReturn = newName;
        newName = newName + "." + ((LibraryTableModel)this.DATA_MODEL).getType(row);
        File newFile = new File(parent, newName);
        if (!((LibraryTableModel)this.DATA_MODEL).getName(row).equals(newName)) {
            boolean b = oldFile.renameTo(newFile);
            if (b) {
                ((LibraryTableModel)this.DATA_MODEL).handleFileChangeInternal(row, newFile);
                RouterService.getFileManager().renameFileIfShared(oldFile, newFile);
                return nameToReturn;
            }
            String key1 = "MESSAGE_UNABLE_TO_RENAME_FILE_START";
            String key2 = "MESSAGE_UNABLE_TO_RENAME_FILE_END";
            String msg = "'" + ((LibraryTableModel)this.DATA_MODEL).getName(row) + "'.";
            GUIMediator.showError("MESSAGE_UNABLE_TO_RENAME_FILE_START", (Object)msg, "MESSAGE_UNABLE_TO_RENAME_FILE_END");
            return ((LibraryTableModel)this.DATA_MODEL).getName(row);
        }
        return nameToReturn;
    }

    boolean canDragAndDrop() {
        int[] rows = this.TABLE.getSelectedRows();
        return rows.length > 0 && !this.TABLE.isEditing();
    }

    void setCursor(Cursor cursor) {
        this.TABLE.setCursor(cursor);
    }

    Point getTableLocation() {
        return this.TABLE.getLocationOnScreen();
    }

    Dimension getTableSize() {
        return this.TABLE.getSize();
    }

    int[] getSelectedRows() {
        return this.TABLE.getSelectedRows();
    }

    public void handleSelection(int row) {
        this.setButtonEnabled(LibraryTableButtons.LAUNCH_BUTTON, true);
        this.setButtonEnabled(LibraryTableButtons.DELETE_BUTTON, true);
        if (GUIMediator.isPlaylistVisible()) {
            this.setButtonEnabled(LibraryTableButtons.PLAYLIST_BUTTON, true);
        }
        if (this._allowAnnotate) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, true);
        }
        if (this._allowResume) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, true);
        }
    }

    public void handleNoSelection() {
        this.setButtonEnabled(LibraryTableButtons.LAUNCH_BUTTON, false);
        this.setButtonEnabled(LibraryTableButtons.DELETE_BUTTON, false);
        if (GUIMediator.isPlaylistVisible()) {
            this.setButtonEnabled(LibraryTableButtons.PLAYLIST_BUTTON, false);
        }
        this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, false);
        this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, false);
    }

    static {
        _instance = new LibraryTableMediator();
    }

    private final class LibraryListSelectionModel
    extends DefaultListSelectionModel {
        private LibraryListSelectionModel() {
        }

        public void setSelectionInterval(int index0, int index1) {
            LibraryTableMediator.this._indexCandidate = -1;
            if (LibraryTableMediator.this._multiSelection) {
                LibraryTableMediator.this._indexCandidate = index0;
            }
            if (!LibraryTableMediator.this._multiSelection) {
                super.setSelectionInterval(index0, index1);
            } else if (this.getMinSelectionIndex() > index0 || this.getMaxSelectionIndex() < index1) {
                super.setSelectionInterval(index0, index1);
            } else {
                LibraryTableMediator.this._indexCandidate = index0;
            }
        }

        public void setLeadSelectionIndex(int index) {
            if (LibraryTableMediator.this._shiftPressed) {
                super.setLeadSelectionIndex(index);
            }
        }
    }

    private final class AddPLFileListener
    implements ActionListener {
        private AddPLFileListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                int[] rows = LibraryTableMediator.this.TABLE.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    int index = rows[i];
                    File file = ((LibraryTableModel)LibraryTableMediator.this.DATA_MODEL).getFile(index);
                    LIBRARY_MEDIATOR.addFileToPlayList(file);
                    ++i;
                }
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "AddPLFileListener");
            }
        }
    }

    private final class LaunchListener
    implements ActionListener {
        private LaunchListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                LibraryTableMediator.this.launch();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "Library.LaunchListener");
            }
        }
    }

    private final class MagnetLookupListener
    implements ActionListener {
        private MagnetLookupListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                LibraryTableMediator.this.doMagnetLookup();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private final class BitziLookupListener
    implements ActionListener {
        private BitziLookupListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                LibraryTableMediator.this.doBitziLookup();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private final class ResumeListener
    implements ActionListener {
        private ResumeListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                LibraryTableMediator.this.resumeIncomplete();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "ResumeListener");
            }
        }
    }

    private final class AnnotateListener
    implements ActionListener {
        private AnnotateListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                LibraryTableMediator.this.editMeta();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "AnnotateListener");
            }
        }
    }

    private final class LibraryKeyListener
    implements KeyListener {
        private LibraryKeyListener() {
        }

        public void keyTyped(KeyEvent ke) {
            try {
                if (ke.getKeyChar() != '\b') {
                    return;
                }
                LibraryTableMediator.this.removeSelection();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "LibraryKeyListener");
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                LibraryTableMediator.this._shiftPressed = true;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                LibraryTableMediator.this._shiftPressed = false;
            }
        }
    }
}

