/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.library.LibraryMediator;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class DragSourceListener
implements MouseInputListener {
    private final LibraryMediator MEDIATOR = LibraryMediator.instance();
    private int _lowerRow;
    private int _upperRow;
    private boolean _potentialDrop;
    private boolean _dragging;
    private boolean _outsideSelection = false;

    DragSourceListener() {
    }

    public void mousePressed(MouseEvent e) {
        ListSelectionModel selectionModel = this.MEDIATOR.getTableSelectionModel();
        this._outsideSelection = selectionModel.getMinSelectionIndex() < this._lowerRow || selectionModel.getMaxSelectionIndex() > this._upperRow;
        this._lowerRow = selectionModel.getMinSelectionIndex();
        this._upperRow = selectionModel.getMaxSelectionIndex();
        if (this._lowerRow != this._upperRow) {
            this.MEDIATOR.setMultiSelection(true);
        } else {
            this.MEDIATOR.setMultiSelection(false);
        }
    }

    public void mouseReleased(MouseEvent e) {
        int ic;
        ListSelectionModel selectionModel = this.MEDIATOR.getTableSelectionModel();
        if (this.MEDIATOR.getTableMultiSelection() && !this._dragging && !this._outsideSelection && !SwingUtilities.isRightMouseButton(e) && (ic = this.MEDIATOR.getTableIndexCandidate()) != -1) {
            this.MEDIATOR.setMultiSelection(false);
            selectionModel.setSelectionInterval(ic, ic);
        }
        if (this._dragging) {
            this._dragging = false;
            this.MEDIATOR.setCursors(Cursor.getPredefinedCursor(0));
            if (this._potentialDrop) {
                try {
                    Point tableLocation = this.MEDIATOR.getTableLocation();
                    Point treeLocation = this.MEDIATOR.getTreeLocation();
                    Dimension treeDim = this.MEDIATOR.getTreeSize();
                    Point mousePoint = e.getPoint();
                    Point screenMousePoint = new Point(tableLocation.x + mousePoint.x, tableLocation.y + mousePoint.y);
                    int treeMaxX = treeLocation.x + treeDim.width;
                    int treeMaxY = treeLocation.y + treeDim.height;
                    if (screenMousePoint.x > treeLocation.x && screenMousePoint.x < treeMaxX && screenMousePoint.y > treeLocation.y && screenMousePoint.y < treeMaxY) {
                        Point mouseTreePoint = new Point(screenMousePoint.x - treeLocation.x, screenMousePoint.y - treeLocation.y);
                        this.MEDIATOR.handleDropToTreePoint(mouseTreePoint);
                    }
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
        }
        this._potentialDrop = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this._potentialDrop = false;
    }

    public void mouseExited(MouseEvent e) {
        this._potentialDrop = true;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.MEDIATOR.canDragAndDrop()) {
            this.MEDIATOR.setCursors(Cursor.getPredefinedCursor(13));
            this._dragging = true;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

