/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import de.kapsi.util.OSAException;
import de.kapsi.util.OSAScript;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class iTunesMediator {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$iTunesMediator == null ? (class$com$limegroup$gnutella$gui$iTunesMediator = iTunesMediator.class$("com.limegroup.gnutella.gui.iTunesMediator")) : class$com$limegroup$gnutella$gui$iTunesMediator);
    private static final iTunesMediator INSTANCE = new iTunesMediator();
    private static final int AE_TIMEOUT_ERROR = -1712;
    private static final int AE_REPLY_NOT_ARRIVED_ERROR = -1718;
    private byte[] theScript = null;
    private volatile int iTunesErrors = 0;
    private final ProcessingQueue QUEUE = new ProcessingQueue("iTunesAdderThread");
    private Thread iTunesThread;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$iTunesMediator;

    public static iTunesMediator instance() {
        return INSTANCE;
    }

    private iTunesMediator() {
        if (CommonUtils.isMacOSX()) {
            this.theScript = this.loadScript();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadScript() {
        if (!iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue()) {
            return null;
        }
        in = null;
        try {
            try {
                file = new File(iTunesMediator.getRoot(), "iTunes.scpt");
                if (file.exists() == false) throw new IOException("iTunes.scpt does not exist");
                if (!file.isFile()) {
                    throw new IOException("iTunes.scpt does not exist");
                }
                in = new BufferedInputStream(new FileInputStream(file));
                data = new byte[(int)file.length()];
                if (in.read(data, 0, data.length) != data.length) {
                    throw new IOException("Couldn't read whole script");
                }
                var4_6 = data;
                var6_7 = null;
                if (in == null) return var4_6;
            }
            catch (IOException err) {
                GUIMediator.showError("ERROR_ITUNES_SCRIPT");
                iTunesSettings.ITUNES_SUPPORT_ENABLED.setValue(false);
                var3_5 = null;
                var6_8 = null;
                if (in == null) return var3_5;
                try {
                    in.close();
                    return var3_5;
                }
                catch (IOException err) {
                    // empty catch block
                }
                return var3_5;
            }
        }
        catch (Throwable var5_13) {
            var6_9 = null;
            if (in == null) throw var5_13;
            try {}
            catch (IOException err) {
                throw var5_13;
            }
            in.close();
            in = null;
            throw var5_13;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 140->149)] { 
lbl44:
        // 1 sources

        in.close();
        return var4_6;
lbl46:
        // 1 sources

        catch (IOException err) {
            // empty catch block
        }
        return var4_6;
    }

    private static String getRoot() {
        File test = new File("gpl.txt");
        if (test.exists() && test.isFile()) {
            return "../lib/native";
        }
        return ".";
    }

    public void handleCompleteDownload(Downloader mgr) {
        File saveDir;
        File file;
        if (!CommonUtils.isMacOSX() || !iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue()) {
            return;
        }
        if (this.theScript == null) {
            this.theScript = this.loadScript();
            if (this.theScript == null) {
                return;
            }
        }
        if (!(file = new File(saveDir = SharingSettings.DIRECTORY_FOR_SAVING_FILES.getValue(), mgr.getFileName())).exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: '" + file + "' does not exist");
            }
            return;
        }
        if (!file.isFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: '" + file + "' is a directory");
            }
            return;
        }
        String name = file.getName().toLowerCase(Locale.US);
        if (iTunesMediator.isSupported(name)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Will add '" + file + "' to Playlist");
            }
            this.QUEUE.add(new iTunesAdder(file));
        }
    }

    private static boolean isSupported(String name) {
        String[] types = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue();
        int i = 0;
        while (i < types.length) {
            if (name.endsWith(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class iTunesAdder
    implements Runnable {
        private final File file;

        public iTunesAdder(File f) {
            try {
                f = FileUtils.getCanonicalFile(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file = f;
        }

        public void run() {
            block19: {
                if (!iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue()) {
                    return;
                }
                OSAScript script = null;
                try {
                    try {
                        script = new OSAScript(iTunesMediator.this.theScript);
                        String[] params = new String[]{this.file.getAbsolutePath()};
                        script.execute("add_to_itunes_library", params);
                    }
                    catch (OSAException err) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("An error occured while adding '" + this.file + "' to Playlist", err);
                        }
                        switch (err.getErrorNum()) {
                            case -1718: 
                            case -1712: {
                                break;
                            }
                            default: {
                                if (iTunesMediator.this.iTunesErrors++ <= 5) break;
                                if (iTunesMediator.this.iTunesErrors == 6) {
                                    ErrorService.error(err);
                                    break;
                                }
                                GUIMediator.showError("ERROR_ITUNES_INTEGRATION");
                                iTunesSettings.ITUNES_SUPPORT_ENABLED.setValue(false);
                            }
                        }
                        Object var7_5 = null;
                        if (script != null) {
                            script.close();
                            script = null;
                        }
                        break block19;
                    }
                    catch (UnsatisfiedLinkError err) {
                        GUIMediator.showError("ERROR_ITUNES_LINK");
                        iTunesSettings.ITUNES_SUPPORT_ENABLED.setValue(false);
                        Object var7_6 = null;
                        if (script != null) {
                            script.close();
                            script = null;
                        }
                        break block19;
                    }
                    catch (NoClassDefFoundError err) {
                        GUIMediator.showError("ERROR_ITUNES_LINK");
                        iTunesSettings.ITUNES_SUPPORT_ENABLED.setValue(false);
                        Object var7_7 = null;
                        if (script != null) {
                            script.close();
                            script = null;
                        }
                        break block19;
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                        Object var7_8 = null;
                        if (script != null) {
                            script.close();
                            script = null;
                        }
                    }
                    Object var7_4 = null;
                    if (script != null) {
                        script.close();
                        script = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (script != null) {
                        script.close();
                        script = null;
                    }
                    throw throwable;
                }
            }
        }
    }
}

