/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.download.BrowseListener;
import com.limegroup.gnutella.gui.download.ChatListener;
import com.limegroup.gnutella.gui.download.ClearListener;
import com.limegroup.gnutella.gui.download.DownloadButtons;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadModel;
import com.limegroup.gnutella.gui.download.DownloadPopupMenu;
import com.limegroup.gnutella.gui.download.LaunchListener;
import com.limegroup.gnutella.gui.download.ResumeListener;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JPopupMenu;

public final class DownloadMediator
extends AbstractTableMediator {
    private static int _totalDownloads = 0;
    private static boolean _audioLaunched = false;
    private static DownloadMediator _instance = new DownloadMediator();
    private static boolean _chatEnabled;
    private static boolean _browseEnabled;
    private static final ProcessingQueue QUEUE;
    public ActionListener CHAT_LISTENER;
    public ActionListener CLEAR_LISTENER;
    public ActionListener BROWSE_LISTENER;
    public ActionListener LAUNCH_LISTENER;
    public ActionListener RESUME_LISTENER;
    private DownloadButtons _downloadButtons;

    public static DownloadMediator instance() {
        return _instance;
    }

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    protected void buildListeners() {
        super.buildListeners();
        this.CHAT_LISTENER = new ChatListener(this);
        this.CLEAR_LISTENER = new ClearListener(this);
        this.BROWSE_LISTENER = new BrowseListener(this);
        this.LAUNCH_LISTENER = new LaunchListener(this);
        this.RESUME_LISTENER = new ResumeListener(this);
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("DOWNLOAD_TITLE"));
        this.DATA_MODEL = new DownloadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this._downloadButtons = new DownloadButtons(this);
        this.BUTTON_ROW = this._downloadButtons.getComponent();
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_DOWNLOAD_WINDOW"));
    }

    private DownloadMediator() {
        super("DOWNLOAD_TABLE");
        GUIMediator.addRefreshListener(this);
        GUIMediator.addThemeObserver(this);
    }

    public void doRefresh() {
        boolean inactivePresent = (Boolean)this.DATA_MODEL.refresh();
        this.setButtonEnabled(3, inactivePresent);
        int[] selRows = this.TABLE.getSelectedRows();
        if (selRows.length > 0) {
            DownloadDataLine dataLine = (DownloadDataLine)this.DATA_MODEL.get(selRows[0]);
            if (dataLine.getState() == 13) {
                this._downloadButtons.transformResumeButton();
            } else {
                this._downloadButtons.transformSourcesButton();
            }
        }
    }

    public int getTotalDownloads() {
        return _totalDownloads;
    }

    public int getCurrentDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getCurrentDownloads();
    }

    public int getActiveDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getRowCount();
    }

    public void add(Object downloader) {
        if (!this.DATA_MODEL.contains(downloader)) {
            ++_totalDownloads;
            super.add(downloader);
        }
    }

    public void remove(Object downloader) {
        Downloader dloader = (Downloader)downloader;
        int state = dloader.getState();
        if (state == 4 && this.isThemeFile(dloader.getFileName())) {
            File themeFile = dloader.getDownloadFragment();
            themeFile = this.copyToThemeDir(themeFile);
            int response = GUIMediator.showYesNoMessage("DOWNLOAD_APPLY_NEW_THEME_START", ThemeSettings.formatName(dloader.getFileName()), "DOWNLOAD_APPLY_NEW_THEME_END", QuestionsHandler.THEME_DOWNLOADED);
            if (response == 101) {
                this.applyNewTheme(themeFile);
            }
        }
        if (SharingSettings.CLEAR_DOWNLOAD.getValue() && (state == 4 || state == 5)) {
            super.remove(downloader);
        } else {
            DownloadDataLine ddl = (DownloadDataLine)this.DATA_MODEL.get(downloader);
            if (ddl != null) {
                ddl.setEndTime(System.currentTimeMillis());
            }
        }
    }

    private File copyToThemeDir(File themeFile) {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        File realLoc = new File(themeDir, themeFile.getName());
        if (realLoc.equals(themeFile)) {
            return themeFile;
        }
        realLoc.delete();
        CommonUtils.copy(themeFile, realLoc);
        return realLoc;
    }

    private boolean isThemeFile(String name) {
        return name.toLowerCase().endsWith("lwtp");
    }

    private void applyNewTheme(File themeFile) {
        ThemeSettings.THEME_FILE.setValue(themeFile);
        ThemeFileHandler.reload();
        GUIMediator.instance().setCurrentTheme();
    }

    void launchSelectedDownloads() {
        int[] rows = this.TABLE.getSelectedRows();
        DataLine[] lines = new DataLine[rows.length];
        int i = 0;
        while (i < rows.length) {
            lines[i] = this.DATA_MODEL.get(rows[i]);
            ++i;
        }
        _audioLaunched = false;
        int i2 = 0;
        while (i2 < lines.length) {
            final Downloader dl = (Downloader)lines[i2].getInitializeObject();
            QUEUE.add(new Runnable(){

                public void run() {
                    File toLaunch = dl.getDownloadFragment();
                    if (toLaunch == null) {
                        GUIMediator.showMessage("NO_PREVIEW_BEGIN", dl.getFileName(), "NO_PREVIEW_END", QuestionsHandler.NO_PREVIEW_REPORT);
                        return;
                    }
                    if (GUIMediator.isPlaylistVisible() && !_audioLaunched && (CommonUtils.canLaunchFileWithQuickTime(toLaunch) || LimeXMLUtils.isMP3File(toLaunch))) {
                        GUIMediator.instance().launchAudio(toLaunch);
                        _audioLaunched = true;
                    } else {
                        try {
                            GUIMediator.launchFile(toLaunch);
                        }
                        catch (IOException ignored) {
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                }
            });
            ++i2;
        }
    }

    void resumeSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        int i = 0;
        while (i < sel.length) {
            DataLine dd = this.DATA_MODEL.get(sel[i]);
            Downloader downloader = (Downloader)dd.getInitializeObject();
            try {
                downloader.resume();
            }
            catch (AlreadyDownloadingException e) {
                GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", (Object)("\"" + e.getFilename() + "\"."), QuestionsHandler.ALREADY_DOWNLOADING);
            }
            ++i;
        }
    }

    void chatWithSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        int i = 0;
        while (i < sel.length) {
            DataLine dl = this.DATA_MODEL.get(sel[i]);
            Downloader downloader = (Downloader)dl.getInitializeObject();
            Endpoint end = downloader.getChatEnabledHost();
            if (end != null) {
                RouterService.createChat(end.getAddress(), end.getPort());
            }
            ++i;
        }
    }

    void browseSelectedDownloads() {
        int[] sel = this.TABLE.getSelectedRows();
        int i = 0;
        while (i < sel.length) {
            DataLine dl = this.DATA_MODEL.get(sel[i]);
            Downloader downloader = (Downloader)dl.getInitializeObject();
            RemoteFileDesc end = downloader.getBrowseEnabledHost();
            if (end != null) {
                SearchMediator.doBrowseHost(end);
            }
            ++i;
        }
    }

    public void handleMouseDoubleClick(MouseEvent e) {
        this.launchSelectedDownloads();
    }

    void clearCompletedDownloads() {
        ((DownloadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.setButtonEnabled(3, false);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new DownloadPopupMenu(this).getComponent();
        boolean selection = !this.TABLE.getSelectionModel().isSelectionEmpty();
        menu.getComponent(0).setEnabled(selection);
        menu.getComponent(1).setEnabled(selection);
        menu.getComponent(2).setEnabled(selection);
        menu.getComponent(3).setEnabled(_chatEnabled);
        menu.getComponent(4).setEnabled(_browseEnabled);
        return menu;
    }

    public void handleSelection(int row) {
        DownloadDataLine dataLine = (DownloadDataLine)this.DATA_MODEL.get(row);
        _chatEnabled = dataLine.getChatEnabled();
        _browseEnabled = dataLine.getBrowseEnabled();
        if (dataLine.getState() == 13) {
            this._downloadButtons.transformResumeButton();
        } else {
            this._downloadButtons.transformSourcesButton();
        }
        this.setButtonEnabled(0, true);
        this.setButtonEnabled(1, true);
        this.setButtonEnabled(2, true);
    }

    public void handleNoSelection() {
        _chatEnabled = false;
        _browseEnabled = false;
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
    }

    static {
        QUEUE = new ProcessingQueue("DownloadLauncher");
    }
}

