/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.awt.Component;

public final class ChatUIManager {
    private static final ChatUIManager INSTANCE = new ChatUIManager();
    private Map _chats = Collections.synchronizedMap(new HashMap());

    private ChatUIManager() {
    }

    public static ChatUIManager instance() {
        return INSTANCE;
    }

    public void acceptChat(Chatter chatter) {
        ChatFrame cframe = new ChatFrame(chatter);
        ((Component)cframe).setVisible(true);
        this._chats.put(chatter, cframe);
    }

    public void removeChat(Chatter chatter) {
        ChatFrame cframe = (ChatFrame)this._chats.remove(chatter);
        if (cframe != null) {
            cframe.dispose();
            ((Component)cframe).setVisible(false);
        }
    }

    public void recieveMessage(Chatter chatter) {
        ChatFrame cframe = (ChatFrame)this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.addResponse(chatter.getMessage());
    }

    public void chatUnavailable(Chatter chatter) {
        ChatFrame cframe = (ChatFrame)this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.chatUnavailable();
    }

    public void chatErrorMessage(Chatter chatter, String str) {
        ChatFrame cframe = (ChatFrame)this._chats.get(chatter);
        if (cframe == null) {
            return;
        }
        cframe.displayErrorMessage(str);
    }
}

