/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.RefreshListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalLabelUI;

final class UpdatePanel
extends JPanel
implements RefreshListener {
    private String URL = "http://www.limewire.com/update";
    private String labelString = GUIMediator.getStringResource("UPDATE_MESSAGE_SMALL");
    private JLabel LABEL = new JLabel(this.labelString, 0);
    private boolean visible;
    private boolean blink;

    UpdatePanel() {
        this.LABEL.setUI(new LinkLabelUI());
        FontMetrics fm = ((Component)this.LABEL).getFontMetrics(this.LABEL.getFont());
        int width = fm.stringWidth(this.labelString);
        Dimension dim = new Dimension(width, fm.getHeight());
        this.LABEL.setForeground(Color.red);
        this.LABEL.setPreferredSize(dim);
        this.LABEL.setMaximumSize(dim);
        this.LABEL.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                UpdatePanel.this.handleClick();
            }

            public void mouseEntered(MouseEvent e) {
                if (UpdatePanel.this.visible) {
                    e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            public void mouseExited(MouseEvent e) {
                if (UpdatePanel.this.visible) {
                    e.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.add(this.LABEL);
        GUIMediator.addRefreshListener(this);
        this.setVisible(false);
        this.visible = false;
        this.blink = false;
    }

    public void makeVisible(boolean blink) {
        this.visible = true;
        this.blink = blink;
        super.setVisible(true);
    }

    private void handleClick() {
        if (!this.visible) {
            return;
        }
        try {
            GUIMediator.openURL(this.URL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void refresh() {
        if (!this.visible || !this.blink) {
            return;
        }
        Color currCol = this.LABEL.getForeground();
        if (currCol.equals(Color.red)) {
            this.LABEL.setForeground(Color.black);
        }
        if (currCol.equals(Color.black)) {
            this.LABEL.setForeground(Color.red);
        }
    }

    private class LinkLabelUI
    extends MetalLabelUI {
        private LinkLabelUI() {
        }

        protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
            super.paintEnabledText(l, g, s, textX, textY);
            if (UpdatePanel.this.LABEL.getText() == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            g.fillRect(textX, fm.getAscent() + 2, fm.stringWidth(UpdatePanel.this.LABEL.getText()) - ((UpdatePanel)UpdatePanel.this).LABEL.getInsets().right, 1);
        }
    }
}

