/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.StatusLinkHandler;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.UpdatePanel;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class StatusLine
implements ThemeObserver {
    private JPanel connectionQuality;
    private JPanel[] qualityPanels = new JPanel[7];
    private CardLayout switcher;
    private JLabel sharingLabel;
    private JPanel connectionQualityText;
    private JLabel connectionStatus;
    private MediaPlayerComponent _mediaPlayer;
    private UpdatePanel _updatePanel;
    private final JPanel PANEL = new BoxPanel(0);
    private final JPanel CENTER = new BoxPanel(0);
    private final JLabel STATUS_LABEL = new JLabel();
    private static final String STATS_AVAILABLE_STRING = GUIMediator.getStringResource("STATISTICS_AVAILABLE");
    private static final String STATS_FILE_STRING = GUIMediator.getStringResource("STATISTICS_FILES");
    private static final String STATS_DISCONNECTED_STRING = GUIMediator.getStringResource("STATISTICS_DISCONNECTED");
    private static final String STATS_SHARING_STRING = GUIMediator.getStringResource("STATISTICS_SHARING");
    private static final String TIP_CONNECTION_DISCONNECTED = GUIMediator.getStringResource("STATISTICS_CONNECTION_DISCONNECTED_TIP");
    private static final String STATISTICS_CONNECTION_DISCONNECTED = GUIMediator.getStringResource("STATISTICS_CONNECTION_DISCONNECTED");
    private static final String TIP_CONNECTION_CONNECTING = GUIMediator.getStringResource("STATISTICS_CONNECTION_CONNECTING_TIP");
    private static final String STATISTICS_CONNECTION_CONNECTING = GUIMediator.getStringResource("STATISTICS_CONNECTION_CONNECTING");
    private static final String TIP_CONNECTION_POOR = GUIMediator.getStringResource("STATISTICS_CONNECTION_POOR_TIP");
    private static final String STATISTICS_CONNECTION_POOR = GUIMediator.getStringResource("STATISTICS_CONNECTION_POOR");
    private static final String TIP_CONNECTION_FAIR = GUIMediator.getStringResource("STATISTICS_CONNECTION_FAIR_TIP");
    private static final String STATISTICS_CONNECTION_FAIR = GUIMediator.getStringResource("STATISTICS_CONNECTION_FAIR");
    private static final String TIP_CONNECTION_GOOD = GUIMediator.getStringResource("STATISTICS_CONNECTION_GOOD_TIP");
    private static final String STATISTICS_CONNECTION_GOOD = GUIMediator.getStringResource("STATISTICS_CONNECTION_GOOD");
    private static final String TIP_CONNECTION_EXCELLENT = GUIMediator.getStringResource("STATISTICS_CONNECTION_EXCELLENT_TIP");
    private static final String STATISTICS_CONNECTION_EXCELLENT = GUIMediator.getStringResource("STATISTICS_CONNECTION_EXCELLENT");
    private static final String TIP_CONNECTION_TURBO_CHARGED = GUIMediator.getStringResource("STATISTICS_CONNECTION_TURBO_CHARGED_TIP_" + (CommonUtils.isPro() ? "PRO" : "FREE"));
    private static final String STATISTICS_CONNECTION_TURBO_CHARGED = GUIMediator.getStringResource("STATISTICS_CONNECTION_TURBO_CHARGED");

    public StatusLine() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_STATUS_WINDOW"));
        this.createConnectPanel();
        this.sharingLabel = new JLabel("           ");
        this.sharingLabel.setHorizontalAlignment(2);
        String toolTip = GUIMediator.getStringResource("STATISTICS_SHARING_TOOLTIP");
        this.sharingLabel.setToolTipText(toolTip);
        this.connectionQualityText = new BoxPanel(0);
        JLabel connectionText = new JLabel(GUIMediator.getStringResource("STATISTICS_CONNECTION_QUALITY") + " ");
        connectionText.setAlignmentX(0.0f);
        this.connectionStatus = new JLabel();
        this.connectionStatus.setAlignmentX(0.0f);
        this.connectionQualityText.add(connectionText);
        this.connectionQualityText.add(this.connectionStatus);
        Dimension minimum = new Dimension(20, 3);
        this.sharingLabel.setMinimumSize(minimum);
        this.connectionStatus.setMinimumSize(minimum);
        this.connectionQualityText.setMinimumSize(minimum);
        this.connectionQualityText.setAlignmentX(0.0f);
        this.sharingLabel.setAlignmentX(0.0f);
        this.setConnectionQuality(0);
        this.PANEL.setBorder(BorderFactory.createLoweredBevelBorder());
        BoxPanel textInfo = new BoxPanel(1);
        textInfo.add(this.connectionQualityText);
        textInfo.add(this.sharingLabel);
        BoxPanel leftPanel = new BoxPanel(0);
        leftPanel.add(this.connectionQuality);
        leftPanel.add(textInfo);
        this.PANEL.add(leftPanel);
        BoxPanel centerPanel = new BoxPanel(1);
        BoxPanel topCenter = new BoxPanel(0);
        this._updatePanel = new UpdatePanel();
        topCenter.add(this._updatePanel);
        this.CENTER.add(this.STATUS_LABEL);
        centerPanel.add(topCenter);
        centerPanel.add(this.CENTER);
        this.PANEL.add(Box.createHorizontalGlue());
        this.PANEL.add(centerPanel);
        this.PANEL.add(Box.createHorizontalGlue());
        Dimension prefer = new Dimension(this.PANEL.getWidth(), 45);
        this.PANEL.setMinimumSize(prefer);
        if (GUIMediator.isPlaylistVisible()) {
            this._mediaPlayer = new MediaPlayerComponent();
            JPanel mediaPanel = this._mediaPlayer.getMediaPanel();
            this.PANEL.add(mediaPanel);
        }
        GUIMediator.addThemeObserver(this);
    }

    void setStatusText(String text) {
        FontMetrics fm = ((Component)this.STATUS_LABEL).getFontMetrics(this.STATUS_LABEL.getFont());
        this.STATUS_LABEL.setPreferredSize(new Dimension(fm.stringWidth(text), fm.getHeight()));
        this.STATUS_LABEL.setText(text);
    }

    void loadFinished() {
        this.CENTER.removeAll();
        if (!GUIMediator.hasDonated()) {
            this.CENTER.add(new StatusLinkHandler().getComponent());
        }
        this.PANEL.invalidate();
        this.PANEL.revalidate();
        this.PANEL.repaint();
    }

    private void createConnectPanel() {
        this.updateTheme();
        this.connectionQuality = new JPanel();
        this.switcher = new CardLayout();
        this.connectionQuality.setLayout(this.switcher);
        int i = 0;
        while (i < this.qualityPanels.length) {
            this.connectionQuality.add((Component)this.qualityPanels[i], Integer.toString(i));
            ++i;
        }
        this.connectionQuality.setMaximumSize(new Dimension(90, 30));
    }

    public void updateTheme() {
        int i = 0;
        while (i < this.qualityPanels.length) {
            ImageIcon image = GUIMediator.getThemeImage("connect_" + i + ".gif");
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(0));
            JLabel label = new JLabel();
            label.setIcon(image);
            panel.add(label);
            this.qualityPanels[i] = panel;
            ++i;
        }
        if (this._mediaPlayer != null) {
            this._mediaPlayer.updateTheme();
        }
    }

    public void setConnectionQuality(int quality) {
        if (quality >= this.qualityPanels.length) {
            quality = this.qualityPanels.length - 1;
        }
        this.switcher.show(this.connectionQuality, Integer.toString(quality));
        String status = null;
        String tip = null;
        switch (quality) {
            case 0: {
                status = STATISTICS_CONNECTION_DISCONNECTED;
                tip = TIP_CONNECTION_DISCONNECTED;
                break;
            }
            case 1: {
                status = STATISTICS_CONNECTION_CONNECTING;
                tip = TIP_CONNECTION_CONNECTING;
                break;
            }
            case 2: {
                status = STATISTICS_CONNECTION_POOR;
                tip = TIP_CONNECTION_POOR;
                break;
            }
            case 3: {
                status = STATISTICS_CONNECTION_FAIR;
                tip = TIP_CONNECTION_FAIR;
                break;
            }
            case 4: {
                status = STATISTICS_CONNECTION_GOOD;
                tip = TIP_CONNECTION_GOOD;
                break;
            }
            case 5: {
                status = STATISTICS_CONNECTION_EXCELLENT;
                tip = TIP_CONNECTION_EXCELLENT;
                break;
            }
            case 6: {
                status = STATISTICS_CONNECTION_TURBO_CHARGED;
                tip = TIP_CONNECTION_TURBO_CHARGED;
            }
        }
        this.connectionStatus.setText(status);
        this.connectionQuality.setToolTipText(tip);
        this.connectionQualityText.setToolTipText(tip);
        if (quality == 0) {
            this.connectionStatus.setForeground(ThemeFileHandler.SEARCH_PRIVATE_IP_COLOR.getValue());
        } else if (quality >= 1 && quality <= 3) {
            this.connectionStatus.setForeground(ThemeFileHandler.WINDOW8_COLOR.getValue());
        } else {
            this.connectionStatus.setForeground(ThemeFileHandler.SEARCH_RESULT_SPEED_COLOR.getValue());
        }
    }

    public String setStatistics(long hosts, long files, long kbytes, int share, int pending) {
        String txt = hosts == 0L ? STATS_DISCONNECTED_STRING : GUIUtils.toUnitnumber(files, false) + " " + STATS_FILE_STRING + " / " + GUIUtils.toUnitbytes(kbytes * 1024L) + " " + STATS_AVAILABLE_STRING;
        if (pending == 0) {
            this.sharingLabel.setText(STATS_SHARING_STRING + " " + String.valueOf(share) + " " + STATS_FILE_STRING);
        } else {
            this.sharingLabel.setText(STATS_SHARING_STRING + " " + String.valueOf(share) + " / " + String.valueOf(pending + share) + " " + STATS_FILE_STRING);
        }
        if (share == 0) {
            Color notSharingColor = ThemeFileHandler.NOT_SHARING_LABEL_COLOR.getValue();
            this.sharingLabel.setForeground(notSharingColor);
        } else {
            this.sharingLabel.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.sharingLabel.setPreferredSize(new Dimension(GUIUtils.width(this.sharingLabel), 20));
        return txt;
    }

    public void audioFileDoubleClicked() {
        MediaPlayerComponent.audioFileDoubleClicked();
    }

    public void launchAudio(File toPlay) {
        MediaPlayerComponent.launchAudio(toPlay);
    }

    public UpdatePanel getUpdatePanel() {
        return this._updatePanel;
    }

    public JComponent getComponent() {
        return this.PANEL;
    }
}

