/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

final class SplashWindow
extends JWindow {
    private static final SplashGlassPane GLASS_PANE = new SplashGlassPane();

    SplashWindow() {
        ImageIcon splashIcon = ResourceManager.getThemeImage("splash.gif");
        Image image = splashIcon.getImage();
        Dimension size = new Dimension(image.getWidth(null) + 2, image.getHeight(null) + 2);
        ((Component)this).setSize(size);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
        JLabel splashLabel = new JLabel(splashIcon);
        splashLabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.getContentPane().add((Component)splashLabel, "Center");
        this.setGlassPane(GLASS_PANE);
        this.pack();
        ((Component)this).setVisible(true);
        GLASS_PANE.setVisible(true);
    }

    static void setStatusText(String text) {
        SplashGlassPane.setText(text);
    }

    private static final class SplashGlassPane
    extends JPanel {
        private static JPanel TEXT_PANEL = new JPanel();
        private static JLabel TEXT_LABEL = new JLabel();

        private SplashGlassPane() {
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalGlue());
            TEXT_PANEL.setOpaque(false);
            TEXT_PANEL.setLayout(new BoxLayout(TEXT_PANEL, 0));
            TEXT_PANEL.add(Box.createHorizontalGlue());
            TEXT_LABEL.setMinimumSize(new Dimension(40, 3));
            TEXT_LABEL.setForeground(ThemeFileHandler.WINDOW4_COLOR.getValue());
            TEXT_LABEL.setOpaque(false);
            TEXT_PANEL.add(TEXT_LABEL);
            TEXT_PANEL.add(GUIMediator.getHorizontalSeparator());
            this.add(TEXT_PANEL);
            this.add(GUIMediator.getVerticalSeparator());
        }

        private static void setText(String text) {
            FontMetrics fm = ((Component)TEXT_LABEL).getFontMetrics(TEXT_LABEL.getFont());
            TEXT_LABEL.setPreferredSize(new Dimension(fm.stringWidth(text), fm.getHeight()));
            TEXT_LABEL.setText(text);
        }
    }
}

