/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LimeLookAndFeel;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Expand;
import java.awt.Font;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;

final class ResourceManager {
    private static ResourceManager _instance;
    private static final String WINDOWS_LIBRARY_NAME = "LimeWire20";
    private static final String BROWSER_LIBRARY_NAME = "BrowserPage";
    private static final String GUI_PATH = "com/limegroup/gnutella/gui/";
    private static final String RESOURCES_PATH = "com/limegroup/gnutella/gui/resources/";
    private static final String IMAGES_PATH = "com/limegroup/gnutella/gui/images/";
    private static boolean _localeOptionsSet;
    private static Locale _locale;
    private static ResourceBundle _resourceBundle;
    private static boolean _useBold;
    private static boolean _useLeftToRight;
    private static boolean _browserPageLoaded;
    private static boolean _installerShared;
    private static boolean _fontReduced;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ResourceManager;

    static void resetLocaleOptions() {
        _localeOptionsSet = false;
        ResourceManager.setLocaleOptions();
    }

    static void setLocaleOptions() {
        if (!_localeOptionsSet) {
            if (ApplicationSettings.LANGUAGE.getValue().equals("")) {
                ApplicationSettings.LANGUAGE.setValue("en");
            }
            _locale = new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue());
            _resourceBundle = ResourceBundle.getBundle("MessagesBundle", _locale);
            _useBold = Boolean.valueOf(ResourceManager.getStringResource("DISABLE_BOLD_CHARACTERS")) == false;
            _useLeftToRight = Boolean.valueOf(ResourceManager.getStringResource("LAYOUT_RIGHT_TO_LEFT")) == false;
            _localeOptionsSet = true;
        }
    }

    static Locale getLocale() {
        return _locale;
    }

    static boolean hasLocalizedTipsOfTheDay() {
        return Boolean.valueOf(ResourceManager.getStringResource("HAS_TIPS_OF_THE_DAY"));
    }

    static ResourceBundle getTOTDResourceBundle() {
        return ResourceBundle.getBundle("totd/TOTD", _locale);
    }

    static ResourceBundle getXMLResourceBundle(String name) {
        return ResourceBundle.getBundle("xml.display." + name, _locale);
    }

    static final boolean useBold() {
        ResourceManager.setLocaleOptions();
        return _useBold;
    }

    static final boolean isLeftToRight() {
        ResourceManager.setLocaleOptions();
        return _useLeftToRight;
    }

    static boolean isBrowserPageLoaded() {
        return _browserPageLoaded;
    }

    static LookAndFeel getInitialLookAndFeel() {
        return new LimeLookAndFeel();
    }

    static final String getStringResource(String resourceKey) {
        return _resourceBundle.getString(resourceKey);
    }

    static final ImageIcon getThemeImage(String name) {
        File image = new File(ThemeSettings.THEME_DIR.getValue(), name);
        if (image.exists()) {
            return new ImageIcon(ResourceManager.toURL(image));
        }
        URL img = ResourceManager.getURLImage(name);
        if (img == null) {
            throw new MissingResourceException("image: " + name + " doesn't exist.", null, null);
        }
        return new ImageIcon(img);
    }

    static final ImageIcon getImageFromPath(String loc) {
        return new ImageIcon(loc);
    }

    static URL getURLImage(String FILE_NAME) {
        return ResourceManager.getURL(IMAGES_PATH + FILE_NAME);
    }

    static URL getURLResource(String FILE_NAME) {
        return ResourceManager.getURL(RESOURCES_PATH + FILE_NAME);
    }

    private static URL getURL(String PATH) {
        ClassLoader cl = (class$com$limegroup$gnutella$gui$ResourceManager == null ? (class$com$limegroup$gnutella$gui$ResourceManager = ResourceManager.class$("com.limegroup.gnutella.gui.ResourceManager")) : class$com$limegroup$gnutella$gui$ResourceManager).getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        URL url = cl.getResource(PATH);
        if (url == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        return url;
    }

    static final ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private ResourceManager() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_RESOURCE_MANAGER"));
        if (!ThemeFileHandler.isCurrent()) {
            ThemeSettings.THEME_FILE.revertToDefault();
            ThemeSettings.THEME_DIR.revertToDefault();
            ThemeFileHandler.reload();
        }
        try {
            this.themeChanged();
        }
        catch (Exception e) {
            GUIMediator.showInternalError(e);
            GUIMediator.shutdown();
        }
        if (CommonUtils.isWindows()) {
            this.loadLibrary(WINDOWS_LIBRARY_NAME);
        }
        if (!GUIMediator.hasDonated() && CommonUtils.isWindows()) {
            this.loadLibrary(BROWSER_LIBRARY_NAME);
        }
        try {
            ResourceManager.unpackWarFiles();
        }
        catch (IOException e) {
            GUIMediator.showInternalError(e);
        }
        this.unpackVersionFile();
        this.shareInstaller();
    }

    private void shareInstaller() {
        if (CommonUtils.isPro()) {
            return;
        }
        if (_installerShared) {
            return;
        }
        String installerName = "";
        if (CommonUtils.isWindows()) {
            installerName = "LimeWireWin.exe";
        } else if (CommonUtils.isMacOSX()) {
            installerName = "LimeWireOSX.zip";
        } else if (CommonUtils.isMacClassic()) {
            installerName = "LimeWireMac.bin";
        } else if (CommonUtils.isLinux()) {
            installerName = "LimeWireLinux.bin";
        } else if (CommonUtils.isSolaris()) {
            installerName = "LimeWireSolaris.bin";
        } else {
            _installerShared = true;
            return;
        }
        File javaHome = new File(System.getProperty("java.home"));
        File installer = new File(javaHome, installerName);
        if (!installer.isFile()) {
            return;
        }
        File[] sharedDirs = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
        if (sharedDirs.length == 0) {
            return;
        }
        File sharedDir = sharedDirs[0];
        File newFile = new File(sharedDir, installerName);
        if (newFile.isFile() && installer.lastModified() <= newFile.lastModified()) {
            _installerShared = true;
            return;
        }
        installer.renameTo(new File(sharedDir, installerName));
        _installerShared = true;
    }

    public void themeChanged() {
        try {
            if (ThemeSettings.isNativeTheme()) {
                String lafName = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lafName);
                if (CommonUtils.isMacOSX() && !_fontReduced) {
                    _fontReduced = true;
                    ResourceManager.reduceFont("Label.font");
                    ResourceManager.reduceFont("Table.font");
                }
            } else {
                UIManager.setLookAndFeel(new LimeLookAndFeel());
            }
            UIManager.put("Tree.leafIcon", UIManager.getIcon("Tree.closedIcon"));
            UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder());
            Font normal = UIManager.getFont("Table.font");
            FontUIResource bold = new FontUIResource(normal.getName(), 1, normal.getSize());
            UIManager.put("Table.font.bold", bold);
        }
        catch (UnsupportedLookAndFeelException e) {
            GUIMediator.showInternalError(e);
        }
        catch (ClassNotFoundException e) {
            GUIMediator.showInternalError(e);
        }
        catch (InstantiationException e) {
            GUIMediator.showInternalError(e);
        }
        catch (IllegalAccessException e) {
            GUIMediator.showInternalError(e);
        }
    }

    static ComponentUI getNativeUI(JComponent c) {
        ComponentUI ret = null;
        String name = UIManager.getSystemLookAndFeelClassName();
        if (name != null) {
            try {
                Class<?> clazz = Class.forName(name);
                LookAndFeel lf = (LookAndFeel)clazz.newInstance();
                lf.initialize();
                UIDefaults def = lf.getDefaults();
                ret = def.getUI(c);
            }
            catch (ExceptionInInitializerError e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException e) {
            }
            catch (SecurityException e) {
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = UIManager.getUI(c);
        }
        return ret;
    }

    private static void reduceFont(String name) {
        Font oldFont = UIManager.getFont(name);
        FontUIResource newFont = new FontUIResource(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - 2);
        UIManager.put(name, newFont);
    }

    private void loadLibrary(String libraryName) {
        try {
            System.loadLibrary(libraryName);
        }
        catch (UnsatisfiedLinkError e) {
            if (libraryName.equals(BROWSER_LIBRARY_NAME)) {
                _browserPageLoaded = false;
                return;
            }
            GUIMediator.showInternalError(e);
        }
    }

    private static void unpackWarFiles() throws IOException {
        File currDir = CommonUtils.getCurrentDirectory();
        String[] warFiles = currDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".war");
            }
        });
        if (warFiles == null) {
            return;
        }
        File destDir = CommonUtils.getUserSettingsDir();
        if (!destDir.isDirectory()) {
            throw new IOException("settings dir not a directory: " + destDir);
        }
        if (!destDir.canWrite()) {
            throw new IOException("cannot write to the settings dir: " + destDir);
        }
        int i = 0;
        while (i < warFiles.length) {
            Expand.expandFile(new File(warFiles[i]), destDir);
            ++i;
        }
    }

    private void unpackVersionFile() {
        String latestVersion;
        File userHome = CommonUtils.getUserSettingsDir();
        File updateFile = new File(userHome, "update.xml");
        File verFile = new File("update.ver");
        if (!updateFile.exists()) {
            try {
                Expand.expandFile(verFile, userHome);
            }
            catch (IOException iox) {
                return;
            }
        }
        String myVersion = CommonUtils.getLimeWireVersion();
        if (UpdateManager.isGreaterVersion(myVersion, latestVersion = ResourceManager.parseVersion(updateFile)) || latestVersion.equals("@version@") && !myVersion.equals("@version@")) {
            try {
                Expand.expandFile(verFile, userHome);
            }
            catch (IOException iox) {
                return;
            }
        }
    }

    private static String parseVersion(File file) {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)raf.length()];
            raf.read(bytes);
            raf.close();
            String tempString = new String(bytes, "UTF8");
            int a = tempString.indexOf("<version>");
            int b = tempString.indexOf("</version>");
            if (a < 0 || b < 0 || b <= a) {
                file.delete();
                return null;
            }
            String tempVersion = tempString.substring(a + 9, b);
            return tempVersion;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static URL toURL(File f) {
        try {
            return new URL("file", "", ResourceManager.slashify(f.getAbsolutePath(), f));
        }
        catch (MalformedURLException e) {
            ErrorService.error(e);
            return null;
        }
    }

    private static String slashify(String path, File f) {
        String p = path;
        if (File.separatorChar != '/') {
            p = p.replace(File.separatorChar, '/');
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        if (!p.endsWith("/") && f.isDirectory()) {
            p = p + "/";
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _browserPageLoaded = true;
        _installerShared = false;
        _fontReduced = false;
        ResourceManager.resetLocaleOptions();
    }
}

