/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.IntSetting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class MessageService {
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    public static final int REMEMBER_ANSWER = 1;
    public static final int FORGET_ANSWER = 0;
    private static final MessageService INSTANCE = new MessageService();

    public static MessageService instance() {
        return INSTANCE;
    }

    MessageService() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_MESSAGE_SERVICE"));
    }

    final void showError(String message) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_ERROR_CAPTION"), 0);
    }

    final void showError(String message, BooleanSetting ignore) {
        if (!ignore.getValue()) {
            JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), GUIMediator.getStringResource("MESSAGE_ERROR_CAPTION"), 0);
        }
    }

    public final void showMessage(Component toDisplay) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), toDisplay, GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final void showMessage(String message) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final void showMessage(String message, BooleanSetting ignore) {
        if (!ignore.getValue()) {
            JOptionPane.showMessageDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
        }
    }

    final void showConfirmMessage(String message) {
        JOptionPane.showConfirmDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final void showConfirmMessage(String message, BooleanSetting ignore) {
        if (!ignore.getValue()) {
            JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.doNotDisplayAgainLabel(message, ignore), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
        }
    }

    final int showYesNoMessage(String message) {
        int option;
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), new MultiLineLabel(message), GUIMediator.getStringResource("MESSAGE_CAPTION"), 0);
        }
        catch (InternalError ie) {
            option = 1;
        }
        if (option == 0) {
            return 101;
        }
        return 102;
    }

    final int showYesNoMessage(String message, IntSetting defValue) {
        int option;
        if (defValue.getValue() == 101 || defValue.getValue() == 102) {
            return defValue.getValue();
        }
        try {
            option = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(message, defValue), GUIMediator.getStringResource("MESSAGE_CAPTION"), 0);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            option = 1;
        }
        catch (InternalError ie) {
            option = 1;
        }
        int ret = option == 0 ? 101 : 102;
        if (defValue.getValue() == 1) {
            defValue.setValue(ret);
        } else {
            defValue.setValue(0);
        }
        return ret;
    }

    public static Component getParentComponent() {
        if (GUIMediator.isOptionsVisible()) {
            return GUIMediator.getMainOptionsComponent();
        }
        return GUIMediator.getAppFrame();
    }

    private final JComponent doNotDisplayAgainLabel(String message, final BooleanSetting setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(GUIMediator.getStringResource("OPTIONS_DO_NOT_ASK_AGAIN"));
        MultiLineLabel lbl = new MultiLineLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                setting.setValue(e.getStateChange() == 1);
            }
        });
        return thePanel;
    }

    private final JComponent alwaysUseThisAnswerLabel(String message, final IntSetting setting) {
        JPanel thePanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox option = new JCheckBox(GUIMediator.getStringResource("OPTIONS_ALWAYS_USE_ANSWER"));
        MultiLineLabel lbl = new MultiLineLabel(message);
        thePanel.add((Component)lbl, "North");
        thePanel.add((Component)option, "West");
        option.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    setting.setValue(1);
                } else {
                    setting.setValue(0);
                }
            }
        });
        return thePanel;
    }
}

