/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.settings.ThemeSettings;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JButton;

public final class MediaButton
extends JButton
implements ThemeObserver {
    private final String TIP_TEXT;
    private final String UP_NAME;
    private final String DOWN_NAME;

    public MediaButton(String tipKey, String upName, String downName) {
        this.TIP_TEXT = GUIMediator.getStringResource(tipKey);
        this.UP_NAME = upName;
        this.DOWN_NAME = downName;
        this.updateTheme();
    }

    public void updateTheme() {
        this.setContentAreaFilled(false);
        this.setBorderPainted(ThemeSettings.isNativeOSXTheme());
        this.setIcon(GUIMediator.getThemeImage(this.UP_NAME));
        this.setHorizontalAlignment(0);
        this.setPressedIcon(GUIMediator.getThemeImage(this.DOWN_NAME));
        this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setToolTipText(this.TIP_TEXT);
    }
}

