/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Main {
    public static void main(String[] args) {
        try {
            Main.sanityCheck();
            Initializer.initialize(args);
        }
        catch (Throwable err) {
            Main.showCorruptionError(err);
            System.exit(1);
        }
    }

    private static final void showCorruptionError(Throwable err) {
        ExceptionInInitializerError t;
        err.printStackTrace();
        Properties PROPS = System.getProperties();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("LimeWire version " + CommonUtils.getLimeWireVersion());
        pw.print("Java version ");
        pw.print(Main.prop("java.version"));
        pw.print(" from ");
        pw.println(Main.prop("java.vendor"));
        pw.print(Main.prop("os.name"));
        pw.print(" v. ");
        pw.print(Main.prop("os.version"));
        pw.print(" on ");
        pw.println(Main.prop("os.arch"));
        Runtime runtime = Runtime.getRuntime();
        pw.println("Free/total memory: " + runtime.freeMemory() + "/" + runtime.totalMemory());
        pw.println();
        err.printStackTrace(pw);
        pw.println();
        if (err instanceof ExceptionInInitializerError && (t = (ExceptionInInitializerError)err).getException() != null) {
            pw.println("Underlying error: ");
            t.getException().printStackTrace(pw);
            pw.println();
        }
        pw.println("STARTUP ERROR!");
        pw.println();
        File propsFile = new File(CommonUtils.getUserSettingsDir(), "limewire.props");
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            fis.close();
            props.list(pw);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        pw.println("");
        pw.println("");
        pw.println("");
        pw.println("FILES IN CURRENT DIRECTORY:");
        File curDir = new File(PROPS.getProperty("user.dir"));
        String[] files = curDir.list();
        int i = 0;
        while (i < files.length) {
            File curFile = new File(curDir, files[i]);
            pw.println(curFile.toString());
            pw.println("LAST MODIFIED: " + curFile.lastModified());
            pw.println("SIZE: " + curFile.length());
            pw.println();
            ++i;
        }
        pw.flush();
        Main.displayError(sw.toString());
    }

    private static final String prop(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return "?";
        }
        return value;
    }

    private static final void displayError(String error) {
        final JDialog DIALOG = new JDialog();
        DIALOG.setModal(true);
        Dimension DIALOG_DIMENSION = new Dimension(350, 200);
        Dimension INNER_SIZE = new Dimension(300, 150);
        ((Component)DIALOG).setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        String instr0 = "One or more necessary files appear to be invalid.";
        String instr1 = "This is generally caused by a corrupted installation.";
        String instr2 = "Please try downloading and installing LimeWire again.";
        String instr3 = "If the problem persists, please copy and paste the";
        String instr4 = "message below and send it to: bugs@limewire.com";
        String instr5 = "Thank you.";
        JLabel label0 = new JLabel(instr0);
        JLabel label1 = new JLabel(instr1);
        JLabel label2 = new JLabel(instr2);
        JLabel label3 = new JLabel(instr3);
        JLabel label4 = new JLabel(instr4);
        JLabel label5 = new JLabel(instr5);
        JPanel labelPanel = new JPanel();
        JPanel innerLabelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        innerLabelPanel.setLayout(new BoxLayout(innerLabelPanel, 1));
        innerLabelPanel.add(label0);
        innerLabelPanel.add(label1);
        innerLabelPanel.add(label2);
        innerLabelPanel.add(label3);
        innerLabelPanel.add(label4);
        innerLabelPanel.add(label5);
        innerLabelPanel.add(Box.createVerticalStrut(6));
        labelPanel.add(innerLabelPanel);
        labelPanel.add(Box.createHorizontalGlue());
        final JTextArea textArea = new JTextArea(error);
        textArea.selectAll();
        textArea.copy();
        textArea.setColumns(50);
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        scroller.setPreferredSize(INNER_SIZE);
        JPanel buttonPanel = new JPanel();
        JButton copyButton = new JButton("Copy Report");
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textArea.selectAll();
                textArea.copy();
            }
        });
        JButton quitButton = new JButton("Ok");
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
            }
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(quitButton);
        mainPanel.add(labelPanel);
        mainPanel.add(scroller);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = DIALOG.getSize();
        ((Component)DIALOG).setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        DIALOG.show();
    }

    private static void sanityCheck() throws MissingResourceException {
        File test = new File("gpl.txt");
        boolean isCVS = false;
        isCVS = test.exists() && test.isFile();
        String root = isCVS ? "../lib/jars" : ".";
        File collectionsJar = new File(root, "collections.jar");
        File logicryptoJar = new File(root, "logicrypto.jar");
        File themesJar = new File(root, "themes.jar");
        File xercesJar = new File(root, "xerces.jar");
        File updateVer = new File("update.ver");
        File xmlWar = new File("xml.war");
        File messagesBundlesJar = new File("MessagesBundles.jar");
        File id3v2Jar = new File(root, "id3v2.jar");
        if (!collectionsJar.exists() || !collectionsJar.isFile() || collectionsJar.length() != 259265L) {
            throw new MissingResourceException("invalid collections.jar", null, null);
        }
        if (!logicryptoJar.exists() || !logicryptoJar.isFile() || logicryptoJar.length() != 130255L) {
            throw new MissingResourceException("invalid logicrypto.jar", null, null);
        }
        if (!themesJar.exists() || !themesJar.isFile()) {
            throw new MissingResourceException("invalid themes.jar", null, null);
        }
        if (!updateVer.exists() || !updateVer.isFile()) {
            throw new MissingResourceException("invalid update.ver", null, null);
        }
        if (!xercesJar.exists() || !xercesJar.isFile() || xercesJar.length() != 1812019L) {
            throw new MissingResourceException("invalid xerces.jar", null, null);
        }
        if (!xmlWar.exists() || !xmlWar.isFile()) {
            throw new MissingResourceException("invalid xml.war", null, null);
        }
        if (!(isCVS || messagesBundlesJar.exists() && messagesBundlesJar.isFile())) {
            throw new MissingResourceException("invalid MessagesBundles.jar", null, null);
        }
        if (!id3v2Jar.exists() || !id3v2Jar.isFile() || id3v2Jar.length() != 45958L) {
            throw new MissingResourceException("invalid id3v2.jar", null, null);
        }
        try {
            Main.verifyHashes(root);
        }
        catch (IOException e) {
            throw new MissingResourceException(e.getMessage(), null, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void verifyHashes(String root) throws IOException {
        String storedHash;
        String name;
        String realHash;
        Properties props;
        block7: {
            props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(root, "hashes"));
                props.load(fis);
                Object var4_3 = null;
                if (fis == null) break block7;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    fis = null;
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            fis.close();
            fis = null;
        }
        Enumeration<?> names = props.propertyNames();
        do {
            if (!names.hasMoreElements()) {
                return;
            }
            name = (String)names.nextElement();
            storedHash = props.getProperty(name);
        } while ((realHash = Main.hash(new File(root, name))).equals(storedHash));
        throw new MissingResourceException("file [" + name + "] has hash of [" + realHash + "] instead of expected [" + storedHash + "]", null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String hash(File f) throws IOException {
        String string;
        FileInputStream fis = null;
        try {
            int read;
            fis = new FileInputStream(f);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Unknown algorithm: MD5");
            }
            byte[] buffer = new byte[16384];
            while ((read = fis.read(buffer)) != -1) {
                void var4_5;
                md.update(buffer, 0, (int)var4_5);
            }
            string = Main.toHexString(md.digest());
            Object var7_7 = null;
            if (fis == null) return string;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException ignored) {}
            throw throwable;
        }
        try {
            fis.close();
            return string;
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return string;
    }

    private static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer(32);
        int i = 0;
        while (i < data.length) {
            int asInt = data[i] & 0xFF;
            String x = Integer.toHexString(asInt);
            if (x.length() == 1) {
                sb.append("0");
            }
            sb.append(x);
            ++i;
        }
        return sb.toString().toUpperCase();
    }
}

