/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeTheme;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class LimeLookAndFeel
extends MetalLookAndFeel {
    LimeLookAndFeel() {
        MetalLookAndFeel.setCurrentTheme(new LimeTheme());
    }

    public String getDescription() {
        return "Lime Look and Feel";
    }

    public String getID() {
        return "GoLime";
    }

    public String getName() {
        return "Lime Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String limePackageName = "com.limegroup.gnutella.gui.";
        table.put("ButtonUI", limePackageName + "LimeButtonUI");
        if (!CommonUtils.isMacClassic()) {
            table.put("ClassLoader", this.getClass().getClassLoader());
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        ImageIcon questionIcon = ResourceManager.getThemeImage("question.gif");
        ImageIcon errorIcon = ResourceManager.getThemeImage("warning.gif");
        ImageIcon infoIcon = ResourceManager.getThemeImage("notsearching.gif");
        ImageIcon openDirIcon = ResourceManager.getThemeImage("dir_open.gif");
        ImageIcon closedDirIcon = ResourceManager.getThemeImage("dir_closed.gif");
        table.put("CheckBox.foreground", MetalLookAndFeel.getSystemTextColor());
        table.put("OptionPane.questionIcon", questionIcon);
        table.put("OptionPane.errorIcon", errorIcon);
        table.put("OptionPane.informationIcon", infoIcon);
        table.put("Table.foreground", MetalLookAndFeel.getUserTextColor());
        table.put("Table.selectionForeground", MetalLookAndFeel.getUserTextColor());
        table.put("Table.selectionBackground", new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));
        table.put("Table.focusCellForeground", MetalLookAndFeel.getUserTextColor());
        table.put("Table.focusCellBackground", new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));
        table.put("TableHeader.background", new ColorUIResource(ThemeFileHandler.TABLE_HEADER_BACKGROUND_COLOR.getValue()));
        table.put("TableHeader.cellBorder", new BorderUIResource(BorderFactory.createRaisedBevelBorder()));
        table.put("TableHeader.cellPressedBorder", new BorderUIResource(BorderFactory.createLoweredBevelBorder()));
        table.put("TextField.background", new ColorUIResource(ThemeFileHandler.WINDOW7_COLOR.getValue()));
        table.put("ToolTip.foreground", MetalLookAndFeel.getControlTextColor());
        table.put("ToolTip.background", MetalLookAndFeel.getControl());
        table.put("ProgressBar.selectionForeground", new ColorUIResource(ThemeFileHandler.WINDOW4_COLOR.getValue()));
        table.put("ProgressBar.selectionBackground", new ColorUIResource(ThemeFileHandler.WINDOW4_COLOR.getValue()));
        table.put("Tree.foreground", MetalLookAndFeel.getUserTextColor());
        table.put("Tree.expandedIcon", openDirIcon);
        table.put("Tree.collapsedIcon", closedDirIcon);
        table.put("Tree.rightChildIndent", new Integer(6));
        table.put("Tree.selectionForeground", MetalLookAndFeel.getUserTextColor());
        table.put("Tree.selectionBackground", new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));
        String os = System.getProperty("os.name");
        if (!os.startsWith("Windows")) {
            FontUIResource osFont = new FontUIResource("Dialog", 0, 11);
            table.put("Label.font", osFont);
            table.put("Button.font", osFont);
        }
    }
}

