/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.settings.ThemeSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class GUIUtils {
    private static final NumberFormat NUMBER_FORMAT0 = NumberFormat.getNumberInstance();
    private static final NumberFormat NUMBER_FORMAT1;
    private static final DateFormat DATETIME_FORMAT;
    public static final String GENERAL_UNIT_KILOBYTES;
    public static final String GENERAL_UNIT_MEGABYTES;
    public static final String GENERAL_UNIT_GIGABYTES;
    public static final String GENERAL_UNIT_TERABYTES;
    public static final String GENERAL_UNIT_KBPSEC;

    private GUIUtils() {
    }

    public static String toLocalizedInteger(long value) {
        return NUMBER_FORMAT0.format(value);
    }

    public static String toKilobytes(long bytes) {
        if (bytes < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        long kbytes = bytes / 1024L;
        if ((bytes & 0x200L) != 0L || bytes > 0L && bytes < 1024L) {
            ++kbytes;
        }
        return NUMBER_FORMAT0.format(kbytes) + GENERAL_UNIT_KILOBYTES;
    }

    public static String toUnitbytes(long bytes) {
        String unitName;
        long unitValue;
        if (bytes < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        if (bytes < 0x6400000L) {
            unitValue = 1024L;
            unitName = GENERAL_UNIT_KILOBYTES;
        } else if (bytes < 0x1900000000L) {
            unitValue = 0x100000L;
            unitName = GENERAL_UNIT_MEGABYTES;
        } else if (bytes < 0x640000000000L) {
            unitValue = 0x40000000L;
            unitName = GENERAL_UNIT_GIGABYTES;
        } else {
            unitValue = 0x10000000000L;
            unitName = GENERAL_UNIT_TERABYTES;
        }
        NumberFormat numberFormat = (double)bytes * 100.0 / (double)unitValue < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        return numberFormat.format((double)bytes / (double)unitValue) + " " + unitName;
    }

    public static String toUnitnumber(double value, boolean allowFractional) {
        String unitName;
        long unitValue;
        double abs;
        double d = abs = value < 0.0 ? -value : value;
        if (abs < 100000.0) {
            unitValue = 1L;
            unitName = "";
        } else if (abs < 1.0E8) {
            unitValue = 1000L;
            unitName = "k";
            allowFractional = true;
        } else if (abs < 1.0E11) {
            unitValue = 1000000L;
            unitName = "M";
            allowFractional = true;
        } else if (abs < 1.0E14) {
            unitValue = 1000000000L;
            unitName = "G";
            allowFractional = true;
        } else {
            unitValue = 1000000000000L;
            unitName = "T";
            allowFractional = true;
        }
        NumberFormat numberFormat = allowFractional && abs * 100.0 / (double)unitValue < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        return numberFormat.format(value / (double)unitValue) + unitName;
    }

    public static MultiLineLabel getSizedLabel(String msg) {
        Dimension dim = new Dimension();
        MultiLineLabel label = new MultiLineLabel(msg);
        FontMetrics fm = ((Component)label).getFontMetrics(label.getFont());
        int width = fm.stringWidth(msg);
        dim.setSize(Integer.MAX_VALUE, width / 9);
        label.setPreferredSize(dim);
        return label;
    }

    public static String speed2name(int rate) {
        if (rate <= 56) {
            return GUIConstants.MODEM_SPEED;
        }
        if (rate <= 350) {
            return GUIConstants.CABLE_SPEED;
        }
        if (rate <= 1000) {
            return GUIConstants.T1_SPEED;
        }
        if (rate < Integer.MAX_VALUE) {
            return GUIConstants.T3_SPEED;
        }
        return GUIConstants.MULTICAST_SPEED;
    }

    public static String rate2speed(double rate) {
        return NUMBER_FORMAT0.format(rate) + GENERAL_UNIT_KBPSEC;
    }

    public static String seconds2time(int seconds) {
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        minutes -= hours * 60;
        int days = hours / 24;
        hours -= days * 24;
        StringBuffer time = new StringBuffer();
        if (days != 0) {
            time.append(Integer.toString(days));
            time.append(":");
            if (hours < 10) {
                time.append("0");
            }
        }
        if (days != 0 || hours != 0) {
            time.append(Integer.toString(hours));
            time.append(":");
            if (minutes < 10) {
                time.append("0");
            }
        }
        time.append(Integer.toString(minutes));
        time.append(":");
        if (seconds < 10) {
            time.append("0");
        }
        time.append(Integer.toString(seconds));
        return time.toString();
    }

    public static String msec2DateTime(long milliseconds) {
        Date d = new Date(milliseconds);
        return DATETIME_FORMAT.format(d);
    }

    public static void setOpaque(boolean op, JComponent c) {
        c.setOpaque(op);
        Component[] cs = c.getComponents();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof JComponent && !(cs[i] instanceof JTextField) && (ThemeSettings.isNativeOSXTheme() || !(cs[i] instanceof JButton))) {
                ((JComponent)cs[i]).setOpaque(op);
                GUIUtils.setOpaque(op, (JComponent)cs[i]);
            }
            ++i;
        }
    }

    public static JPanel center(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(1, 0, 0));
        p.add(c);
        return p;
    }

    public static JPanel left(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(c);
        return p;
    }

    public static int width(JLabel c) {
        FontMetrics fm = ((Component)c).getFontMetrics(c.getFont());
        return fm.stringWidth(c.getText()) + 3;
    }

    static {
        NUMBER_FORMAT0.setMaximumFractionDigits(0);
        NUMBER_FORMAT0.setMinimumFractionDigits(0);
        NUMBER_FORMAT0.setGroupingUsed(true);
        NUMBER_FORMAT1 = NumberFormat.getNumberInstance();
        NUMBER_FORMAT1.setMaximumFractionDigits(1);
        NUMBER_FORMAT1.setMinimumFractionDigits(1);
        NUMBER_FORMAT1.setGroupingUsed(true);
        DATETIME_FORMAT = DateFormat.getDateTimeInstance();
        GENERAL_UNIT_KILOBYTES = GUIMediator.getStringResource("GENERAL_UNIT_KILOBYTES");
        GENERAL_UNIT_MEGABYTES = GUIMediator.getStringResource("GENERAL_UNIT_MEGABYTES");
        GENERAL_UNIT_GIGABYTES = GUIMediator.getStringResource("GENERAL_UNIT_GIGABYTES");
        GENERAL_UNIT_TERABYTES = GUIMediator.getStringResource("GENERAL_UNIT_TERABYTES");
        GENERAL_UNIT_KBPSEC = GUIMediator.getStringResource("GENERAL_UNIT_KBPSEC");
    }
}

