/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bugs.BugManager;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.LimeButtonUI;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.PROWindow;
import com.limegroup.gnutella.gui.PasswordDialog;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.ShoppingView;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.UpdatePanel;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;

public final class GUIMediator {
    private static final int STABLE_THRESHOLD = 5;
    private static boolean _displayedMessage;
    private static GUIMediator _instance;
    public static final int SEARCH_INDEX = 0;
    public static final int MONITOR_INDEX = 1;
    public static final int CONNECTIONS_INDEX = 2;
    public static final int LIBRARY_INDEX = 3;
    public static final int SHOPPING_INDEX = 4;
    private static boolean HAS_DONATED;
    private static final JFrame FRAME;
    private static final List REFRESH_LIST;
    private static final List THEME_OBSERVERS;
    private static final Component HORIZONTAL_SEPARATOR;
    private static final Component VERTICAL_SEPARATOR;
    private final String APP_TITLE = GUIMediator.getStringResource("APP_TITLE");
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    private static OptionsMediator _optionsMediator;
    private static PlayListGUI _playlistGUI;
    private final MainFrame MAIN_FRAME = new MainFrame(FRAME);
    private final DownloadMediator DOWNLOAD_MEDIATOR = this.MAIN_FRAME.getDownloadMediator();
    private final UploadMediator UPLOAD_MEDIATOR = this.MAIN_FRAME.getUploadMediator();
    private final ConnectionMediator CONNECTION_MEDIATOR = this.MAIN_FRAME.getConnectionMediator();
    private final ShoppingView SHOPPING_VIEW = this.MAIN_FRAME.getShoppingView();
    private final LibraryMediator LIBRARY_MEDIATOR = this.MAIN_FRAME.getLibraryMediator();
    private final MenuMediator MENU_MEDIATOR = this.MAIN_FRAME.getMenuMediator();
    private final StatusLine STATUS_LINE = this.MAIN_FRAME.getStatusLine();
    private final StatisticsMediator STATISTICS_MEDIATOR = this.MAIN_FRAME.getStatisticsMediator();
    private RouterService _routerService;
    private static boolean _visibleOnce;
    private static boolean _allowVisible;
    private final ProcessingQueue QUEUE = new ProcessingQueue("DelayedGUI");
    static /* synthetic */ Class class$java$awt$Frame;

    private GUIMediator() {
        FRAME.setTitle(this.APP_TITLE);
        _optionsMediator = this.MAIN_FRAME.getOptionsMediator();
        _playlistGUI = this.MAIN_FRAME.getPlayListGUI();
        GUIMediator.addRefreshListener(this.STATISTICS_MEDIATOR);
    }

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    public static synchronized boolean isConstructed() {
        return _instance != null;
    }

    public void schedule(Runnable r) {
        this.QUEUE.add(r);
    }

    public final void startTimer() {
        RefreshTimer timer = new RefreshTimer();
        timer.startTimer();
    }

    public static final boolean isAppVisible() {
        return FRAME.isShowing();
    }

    public static final void setAppVisible(boolean visible) {
        ((Component)FRAME).setVisible(visible);
        SearchMediator.requestSearchFocus();
        if (visible && !_visibleOnce) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUIMediator.showDialogsForFirstVisibility();
                }
            });
            _visibleOnce = true;
        }
    }

    private static final void showDialogsForFirstVisibility() {
        if (!GUIMediator.hasDonated()) {
            new PROWindow().showDialog();
        }
        boolean updateShown = UpdateManager.instance().displayUpdate();
        if (!_displayedMessage && !updateShown && ResourceManager.hasLocalizedTipsOfTheDay() && StartupSettings.SHOW_TOTD.getValue()) {
            TipOfTheDayMediator.instance().displayTipWindow();
        }
    }

    private static void closeStartupDialogs() {
        _displayedMessage = true;
        TipOfTheDayMediator.instance().hide();
    }

    private final void setStatistics(String stats) {
        if (RouterService.isShieldedLeaf()) {
            FRAME.setTitle(this.APP_TITLE);
        } else {
            FRAME.setTitle(this.APP_TITLE + "  (" + stats + ")");
        }
    }

    public static final Dimension getAppSize() {
        return FRAME.getSize();
    }

    public static final Point getAppLocation() {
        return FRAME.getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public void wakeupShoppingView() {
        this.getMainFrame().getShoppingView().wakeupComponent();
    }

    public static final JFrame getAppFrame() {
        return FRAME;
    }

    public final RouterService getRouter() {
        return this._routerService;
    }

    public final void setRouterService(RouterService routerService) {
        this._routerService = routerService;
    }

    public final void refreshGUI() {
        try {
            int i = 0;
            while (i < REFRESH_LIST.size()) {
                try {
                    ((RefreshListener)REFRESH_LIST.get(i)).refresh();
                }
                catch (Throwable t) {
                    GUIMediator.showInternalError(t);
                }
                ++i;
            }
            int numHosts = (int)RouterService.getNumHosts();
            long numFiles = RouterService.getNumFiles();
            long totSize = RouterService.getTotalFileSize();
            int sharedFiles = RouterService.getNumSharedFiles();
            int pendingShare = RouterService.getNumPendingShared();
            int quality = this.getConnectionQuality();
            String toDisplay = this.STATUS_LINE.setStatistics(numHosts, numFiles, totSize, sharedFiles, pendingShare);
            this.setStatistics(toDisplay);
            RouterService.updateHorizon();
            this.updateConnectionUI(quality);
        }
        catch (Throwable e) {
            GUIMediator.showInternalError(e);
        }
    }

    public int getConnectionQuality() {
        int multiplier;
        int stable = RouterService.countConnectionsWithNMessages(5);
        if (stable == 0) {
            int initializing = this.CONNECTION_MEDIATOR.getConnectingCount();
            int connections = RouterService.getNumInitializedConnections();
            if (initializing == 0 && connections == 0) {
                if (!RouterService.isFetchingEndpoints()) {
                    return 0;
                }
                return 1;
            }
            if (connections == 0) {
                return 1;
            }
            return 2;
        }
        int n = multiplier = RouterService.isSupernode() ? 2 : 1;
        if (stable <= 1 * multiplier) {
            return 2;
        }
        if (stable <= 2 * multiplier) {
            return 3;
        }
        if (stable <= 3 * multiplier) {
            return 4;
        }
        if (stable <= 4 * multiplier) {
            return 5;
        }
        return 6;
    }

    public void setOptionsVisible(boolean visible) {
        if (_optionsMediator == null) {
            return;
        }
        this.LIBRARY_MEDIATOR.cancelEditing();
        _optionsMediator.setOptionsVisible(visible);
    }

    public static boolean isOptionsVisible() {
        if (_optionsMediator == null) {
            return false;
        }
        return _optionsMediator.isOptionsVisible();
    }

    public static Component getMainOptionsComponent() {
        if (_optionsMediator == null) {
            return null;
        }
        return _optionsMediator.getMainOptionsComponent();
    }

    public final void setStatisticsVisible(boolean visible) {
        this.STATISTICS_MEDIATOR.setStatisticsVisible(visible);
    }

    public final int showPasswordDialog(PasswordDialog dialog) {
        return dialog.showDialog();
    }

    public final void handleTabSelection(int SELECTED_TAB) {
        switch (SELECTED_TAB) {
            case 0: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 1: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 2: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 3: {
                this.MENU_MEDIATOR.handleLibrarySelection();
                break;
            }
            case 4: {
                this.SHOPPING_VIEW.prepareComponent();
            }
        }
    }

    public void setWindow(int index) {
        this.MAIN_FRAME.setSelectedIndex(index);
    }

    public void updateTabIcon(int index) {
        this.MAIN_FRAME.updateTabIcon(index);
    }

    public void clearConnections() {
        this.CONNECTION_MEDIATOR.clearConnections();
    }

    public void setKeepAliveText(String keepAlive) {
        this.CONNECTION_MEDIATOR.setKeepAliveText(keepAlive);
    }

    private void updateConnectionUI(int quality) {
        this.STATUS_LINE.setConnectionQuality(quality);
        boolean connected = quality >= 1;
        this.MENU_MEDIATOR.setConnected(connected);
        if (!connected) {
            this.setSearching(false);
        }
    }

    public int getTotalUploads() {
        return this.UPLOAD_MEDIATOR.getTotalUploads();
    }

    public int getCurrentUploads() {
        return this.UPLOAD_MEDIATOR.getCurrentUploads();
    }

    public final int getTotalDownloads() {
        return this.DOWNLOAD_MEDIATOR.getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return this.DOWNLOAD_MEDIATOR.getCurrentDownloads();
    }

    public final void addSharedLibraryFolder() {
        this.LIBRARY_MEDIATOR.addSharedLibraryFolder();
    }

    public final void addNewLibraryFolder() {
        this.LIBRARY_MEDIATOR.addNewLibraryFolder();
    }

    public final void unshareLibraryFolder() {
        this.LIBRARY_MEDIATOR.unshareLibraryFolder();
    }

    public final void renameLibraryFolder() {
        this.LIBRARY_MEDIATOR.renameLibraryFolder();
    }

    public final void launchLibraryFile() {
        this.LIBRARY_MEDIATOR.launch();
    }

    public final void deleteLibraryFile() {
        this.LIBRARY_MEDIATOR.deleteLibraryFile();
    }

    public final void refreshLibrary() {
        this.LIBRARY_MEDIATOR.refresh();
    }

    public final void clearLibrary() {
        this.LIBRARY_MEDIATOR.clearLibrary();
    }

    public static boolean isPlaylistVisible() {
        if (!GUIMediator.isConstructed()) {
            return !CommonUtils.isMacClassic() && PlayerSettings.PLAYER_ENABLED.getValue();
        }
        return _playlistGUI != null;
    }

    public static void startupHidden() {
        GUIMediator.addNotify();
        if (CommonUtils.isMacOSX()) {
            GUIMediator.hideView();
        }
    }

    public static void allowVisibility() {
        _allowVisible = true;
    }

    public void loadFinished() {
        this.STATUS_LINE.loadFinished();
    }

    public static void handleReopen() {
        if (_allowVisible) {
            if (!_visibleOnce) {
                GUIMediator.restoreView();
            }
            GUIMediator.setAppVisible(true);
        }
    }

    public static void hideView() {
        if (CommonUtils.isJava118()) {
            GUIMediator.setAppVisible(false);
            return;
        }
        int ICONIFIED_FRAME_STATE = GUIMediator.getIconifiedFrameState();
        int FRAME_STATE = GUIMediator.getFrameState();
        if (ICONIFIED_FRAME_STATE == -1 || FRAME_STATE == -1) {
            GUIMediator.setAppVisible(false);
        } else {
            try {
                GUIMediator.setFrameState(ICONIFIED_FRAME_STATE);
            }
            catch (IOException e) {
                GUIMediator.setAppVisible(false);
            }
        }
        if (CommonUtils.supportsTray()) {
            GUIMediator.setAppVisible(false);
            GUIMediator.addNotify();
        }
    }

    public static void restoreView() {
        if (CommonUtils.supportsTray()) {
            boolean doHack = false;
            if (!_visibleOnce) {
                doHack = true;
            }
            GUIMediator.setAppVisible(true);
            GUIMediator.hideNotify();
            if (doHack) {
                GUIMediator.restoreView();
            }
        }
        Finalizer.cancelShutdown();
        if (CommonUtils.isJava118()) {
            GUIMediator.setAppVisible(true);
            return;
        }
        int NORMAL_FRAME_STATE = GUIMediator.getNormalFrameState();
        int FRAME_STATE = GUIMediator.getFrameState();
        if (NORMAL_FRAME_STATE == -1 || FRAME_STATE == -1) {
            GUIMediator.setAppVisible(true);
            return;
        }
        if (FRAME_STATE != NORMAL_FRAME_STATE) {
            try {
                GUIMediator.setFrameState(NORMAL_FRAME_STATE);
            }
            catch (IOException e) {
                GUIMediator.setAppVisible(true);
                return;
            }
        }
    }

    private static int getNormalFrameState() {
        try {
            Field normaleStateField = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame).getField("NORMAL");
            return normaleStateField.getInt(class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int getIconifiedFrameState() {
        try {
            Field iconifiedeStateField = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame).getField("ICONIFIED");
            return iconifiedeStateField.getInt(class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int getFrameState() {
        try {
            Method getStateMethod = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame).getDeclaredMethod("getState", new Class[0]);
            return (Integer)getStateMethod.invoke((Object)FRAME, new Object[0]);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void setFrameState(int state) throws IOException {
        try {
            Method setStateMethod = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame).getDeclaredMethod("setState", Integer.TYPE);
            setStateMethod.invoke((Object)FRAME, new Integer(state));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(boolean fromFrame) {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            GUIMediator.hideView();
        } else if (CommonUtils.isMacOSX() && CommonUtils.isJava14OrLater() && fromFrame) {
            GUIMediator.setAppVisible(false);
        } else if (ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue() && !CommonUtils.isMacClassic()) {
            GUIMediator.shutdownAfterTransfers();
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        Finalizer.shutdown();
    }

    public static void shutdownAfterTransfers() {
        Finalizer.shutdownAfterTransfers();
        GUIMediator.hideView();
    }

    public static final void showAboutWindow() {
        AboutWindow about = new AboutWindow();
        about.showDialog();
    }

    public static void updateNotifyImage(String imageFileName) {
        NotifyUserProxy.instance().updateImage(imageFileName);
    }

    public static void updateNotifyText(String text) {
        NotifyUserProxy.instance().updateDesc(text);
    }

    public static void updateNotify(String imageFileName, String text) {
        NotifyUserProxy.instance().updateNotify(imageFileName, text);
    }

    public static void hideNotify() {
        NotifyUserProxy.instance().hideNotify();
    }

    public static void addNotify() {
        GUIMediator.applyWindowSettings();
        NotifyUserProxy.instance().addNotify();
    }

    public static void applyWindowSettings() {
        ApplicationSettings.RUN_ONCE.setValue(true);
        if (GUIMediator.isAppVisible()) {
            Dimension dim = GUIMediator.getAppSize();
            if (dim.height > 100 && dim.width > 100) {
                Point loc = GUIMediator.getAppLocation();
                ApplicationSettings.APP_WIDTH.setValue(dim.width);
                ApplicationSettings.APP_HEIGHT.setValue(dim.height);
                ApplicationSettings.WINDOW_X.setValue(loc.x);
                ApplicationSettings.WINDOW_Y.setValue(loc.y);
            }
        }
    }

    public static final ImageIcon getThemeImage(String name) {
        return ResourceManager.getThemeImage(name);
    }

    public static final ImageIcon getImageFromPath(String loc) {
        return ResourceManager.getImageFromPath(loc);
    }

    public static URL getURLResource(String FILE_NAME) {
        return ResourceManager.getURLResource(FILE_NAME);
    }

    public static void resetLocale() {
        ResourceManager.resetLocaleOptions();
    }

    public static final String getStringResource(String resourceKey) {
        return ResourceManager.getStringResource(resourceKey);
    }

    public static final ResourceBundle getXMLResourceBundle(String schemaname) {
        return ResourceManager.getXMLResourceBundle(schemaname);
    }

    public static final int showYesNoMessage(String messageKey) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey));
    }

    public static final int showYesNoMessage(String messageKey, IntSetting defaultValue) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey), defaultValue);
    }

    public static final int showYesNoMessage(String messageKey, Object message) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final int showYesNoMessage(String messageKey, Object message, IntSetting defaultValue) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageKey) + " " + message, defaultValue);
    }

    public static final int showYesNoMessage(String messageStartKey, Object message, String messageEndKey) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final int showYesNoMessage(String messageStartKey, Object message, String messageEndKey, IntSetting defaultValue) {
        return MessageService.instance().showYesNoMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), defaultValue);
    }

    public static final void showMessage(String messageKey) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey));
    }

    public static final void showMessage(String messageKey, BooleanSetting ignore) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey), ignore);
    }

    public static final void showMessage(String messageKey, Object message) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final void showMessage(String messageKey, Object message, BooleanSetting ignore) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageKey) + " " + message, ignore);
    }

    public static final void showMessage(String messageStartKey, Object message, String messageEndKey) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final void showMessage(String messageStartKey, Object message, String messageEndKey, BooleanSetting ignore) {
        MessageService.instance().showMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), ignore);
    }

    public static final void showConfirmMessage(String messageKey) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey));
    }

    public static final void showConfirmMessage(String messageKey, BooleanSetting ignore) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey), ignore);
    }

    public static final void showConfirmMessage(String messageKey, Object message) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final void showConfirmMessage(String messageKey, Object message, BooleanSetting ignore) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageKey) + " " + message, ignore);
    }

    public static final void showConfirmMessage(String messageStartKey, Object message, String messageEndKey) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final void showConfirmMessage(String messageStartKey, Object message, String messageEndKey, BooleanSetting ignore) {
        MessageService.instance().showConfirmMessage(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), ignore);
    }

    public static final void showError(String messageKey) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey));
    }

    public static final void showError(String messageKey, BooleanSetting ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey), ignore);
    }

    public static final void showError(String messageKey, Object message) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey) + " " + message);
    }

    public static final void showError(String messageKey, Object message, BooleanSetting ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageKey) + " " + message, ignore);
    }

    public static final void showError(String messageStartKey, Object message, String messageEndKey) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey));
    }

    public static final void showError(String messageStartKey, Object message, String messageEndKey, BooleanSetting ignore) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(GUIMediator.getStringResource(messageStartKey) + " " + message + " " + GUIMediator.getStringResource(messageEndKey), ignore);
    }

    public static final void showInternalError(Throwable t, String detail, Thread curThread) {
        GUIMediator.closeStartupDialogs();
        BugManager.instance().handleBug(t, curThread, detail);
    }

    public static final void showInternalError(Throwable t) {
        GUIMediator.closeStartupDialogs();
        GUIMediator.showInternalError(t, null, Thread.currentThread());
    }

    public static final void showInternalError(Throwable t, String detail) {
        GUIMediator.closeStartupDialogs();
        GUIMediator.showInternalError(t, detail, Thread.currentThread());
    }

    public static final void showInternalError(Throwable t, Thread curThread) {
        GUIMediator.closeStartupDialogs();
        GUIMediator.showInternalError(t, null, curThread);
    }

    public static final int openURL(String url) throws IOException {
        return Launcher.openURL(url);
    }

    public static final int launchFile(File file) throws IOException {
        try {
            return Launcher.launchFile(file);
        }
        catch (SecurityException se) {
            GUIMediator.showError("MESSAGE_FILE_LAUNCHING_SECURITY_MESSAGE");
            return -1;
        }
    }

    public static final Component getHorizontalSeparator() {
        return HORIZONTAL_SEPARATOR;
    }

    public static final Component getVerticalSeparator() {
        return VERTICAL_SEPARATOR;
    }

    public void connect() {
        RouterService.connect();
    }

    public void disconnect() {
        RouterService.disconnect();
    }

    public static boolean hasDonated() {
        return HAS_DONATED;
    }

    public void setTabVisible(int TAB_INDEX, boolean VISIBLE) {
        this.MAIN_FRAME.setTabVisible(TAB_INDEX, VISIBLE);
    }

    public static void setSplashScreenString(String text) {
        if (!_allowVisible) {
            SplashWindow.setStatusText(text);
        } else if (GUIMediator.isConstructed()) {
            GUIMediator.instance().STATUS_LINE.setStatusText(text);
        }
    }

    public static Point getScreenCenterPoint(Component comp) {
        Dimension COMPONENT_DIMENSION = comp.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = Math.min(screenSize.width, COMPONENT_DIMENSION.width);
        int appHeight = Math.min(screenSize.height - 40, COMPONENT_DIMENSION.height);
        return new Point((screenSize.width - appWidth) / 2, (screenSize.height - appHeight) / 2);
    }

    public static void addFinalizeListener(FinalizeListener fin) {
        Finalizer.addFinalizeListener(fin);
    }

    public void setSearching(boolean searching) {
        this.MAIN_FRAME.setSearching(searching);
    }

    public static void addRefreshListener(RefreshListener listener) {
        REFRESH_LIST.add(listener);
    }

    public boolean isConnected() {
        return RouterService.isConnected();
    }

    public static Locale getLocale() {
        return ResourceManager.getLocale();
    }

    public static LookAndFeel getInitialLookAndFeel() {
        return ResourceManager.getInitialLookAndFeel();
    }

    public void launchAudio(File file) {
        this.STATUS_LINE.launchAudio(file);
    }

    public void showUpdateNotification(boolean blink) {
        UpdatePanel updatePanel = this.STATUS_LINE.getUpdatePanel();
        updatePanel.makeVisible(blink);
    }

    public void audioFileDoubleClicked() {
        this.STATUS_LINE.audioFileDoubleClicked();
    }

    public static boolean isBrowserPageLoaded() {
        return ResourceManager.isBrowserPageLoaded();
    }

    public static void addThemeObserver(ThemeObserver observer) {
        THEME_OBSERVERS.add(observer);
    }

    public static void removeThemeObserver(ThemeObserver observer) {
        THEME_OBSERVERS.remove(observer);
    }

    public byte[] triggerSearch(String query) {
        this.MAIN_FRAME.setSelectedIndex(0);
        return SearchMediator.triggerSearch(query);
    }

    public void setCurrentTheme() {
        ResourceManager.instance().themeChanged();
        LimeButtonUI.themeChanged();
        SwingUtilities.updateComponentTreeUI(GUIMediator.getMainOptionsComponent());
        SwingUtilities.updateComponentTreeUI(this.STATISTICS_MEDIATOR.getMainStatisticsComponent());
        SwingUtilities.updateComponentTreeUI(TipOfTheDayMediator.instance().getDialog());
        SwingUtilities.updateComponentTreeUI(FRAME);
        this.updateThemeObservers();
    }

    public void updateThemeObservers() {
        Iterator iter = THEME_OBSERVERS.iterator();
        while (iter.hasNext()) {
            ThemeObserver curObserver = (ThemeObserver)iter.next();
            curObserver.updateTheme();
        }
        GUIMediator.getMainOptionsComponent().validate();
        this.STATISTICS_MEDIATOR.getMainStatisticsComponent().validate();
        FRAME.validate();
    }

    public void doBrowseHost(String address, int port) {
        this.MAIN_FRAME.setSelectedIndex(0);
        SearchMediator.doBrowseHost(address, port, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _instance = null;
        HAS_DONATED = false;
        FRAME = new JFrame();
        REFRESH_LIST = new ArrayList();
        THEME_OBSERVERS = new LinkedList();
        HORIZONTAL_SEPARATOR = Box.createRigidArea(new Dimension(6, 0));
        VERTICAL_SEPARATOR = Box.createRigidArea(new Dimension(0, 6));
        _visibleOnce = false;
        _allowVisible = false;
    }
}

