/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class FileChooserHandler {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$System;

    public static File getInputDirectory() {
        return FileChooserHandler.getInputDirectory(GUIMediator.getAppFrame());
    }

    public static File getInputDirectory(Component parent) {
        return FileChooserHandler.getInputDirectory(parent, "FILE_CHOOSER_DIRECTORY_TITLE", CommonUtils.getCurrentDirectory());
    }

    public static File getInputDirectory(Component parent, File directory) {
        return FileChooserHandler.getInputDirectory(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory);
    }

    public static File getInputDirectory(Component parent, File directory, FileFilter filter) {
        return FileChooserHandler.getInputDirectory(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory, filter);
    }

    public static File getInputDirectory(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory);
    }

    public static File getInputDirectory(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory, filter);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getInputDirectory(parent, titleKey, approveKey, directory, null);
    }

    public static File getInputDirectory(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 1, 0, filter);
    }

    public static File getInputFile() {
        return FileChooserHandler.getInputFile(GUIMediator.getAppFrame());
    }

    public static File getInputFile(Component parent) {
        return FileChooserHandler.getInputFile(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", CommonUtils.getCurrentDirectory());
    }

    public static File getInputFile(Component parent, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, "FILE_CHOOSER_DIRECTORY_TITLE", "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", CommonUtils.getCurrentDirectory(), filter);
    }

    public static File getInputFile(Component parent, String titleKey, File directory) {
        return FileChooserHandler.getInputFile(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory);
    }

    public static File getInputFile(Component parent, String titleKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInputFile(parent, titleKey, "FILE_CHOOSER_DIRECTORY_BUTTON_LABEL", directory, filter);
    }

    public static File getInputFile(Component parent, String titleKey, String approveKey, File directory) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0);
    }

    public static File getInputFile(Component parent, String titleKey, String approveKey, File directory, FileFilter filter) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, 0, 0, filter);
    }

    public static File getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option) {
        return FileChooserHandler.getInput(parent, titleKey, approveKey, directory, mode, option, null);
    }

    public static File getInput(Component parent, String titleKey, String approveKey, File directory, int mode, int option, FileFilter filter) {
        if (!CommonUtils.isMacOSX() || !ThemeSettings.isDefaultTheme()) {
            JFileChooser fileChooser = FileChooserHandler.getDirectoryChooser(titleKey, approveKey, directory, mode, filter);
            try {
                if (fileChooser.showOpenDialog(parent) != option) {
                    return null;
                }
            }
            catch (NullPointerException npe) {
                return null;
            }
            return fileChooser.getSelectedFile();
        }
        Method setProperty = null;
        if (CommonUtils.isJava14OrLater()) {
            try {
                setProperty = (class$java$lang$System == null ? (class$java$lang$System = FileChooserHandler.class$("java.lang.System")) : class$java$lang$System).getMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = FileChooserHandler.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FileChooserHandler.class$("java.lang.String")) : class$java$lang$String);
                setProperty.invoke((Object)(class$java$lang$System == null ? (class$java$lang$System = FileChooserHandler.class$("java.lang.System")) : class$java$lang$System), "apple.awt.fileDialogForDirectories", "true");
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        FileDialog fileDialog = FileChooserHandler.getOSXDirectoryChooser();
        ((Component)fileDialog).setVisible(true);
        String dirStr = fileDialog.getDirectory();
        String fileStr = fileDialog.getFile();
        if (CommonUtils.isJava14OrLater() && setProperty != null) {
            try {
                setProperty.invoke((Object)(class$java$lang$System == null ? (class$java$lang$System = FileChooserHandler.class$("java.lang.System")) : class$java$lang$System), "apple.awt.fileDialogForDirectories", "false");
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (dirStr == null || fileStr == null) {
            return null;
        }
        return new File(dirStr, fileStr);
    }

    private static JFileChooser getDirectoryChooser(String titleKey, String approveKey, File directory, int mode, FileFilter filter) {
        JFileChooser chooser = null;
        if (directory == null) {
            chooser = new JFileChooser();
        } else {
            try {
                chooser = new JFileChooser(directory);
            }
            catch (NullPointerException e) {
                chooser = new JFileChooser(directory);
            }
        }
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        chooser.setFileSelectionMode(mode);
        String title = GUIMediator.getStringResource(titleKey);
        chooser.setDialogTitle(title);
        String approveButtonText = GUIMediator.getStringResource(approveKey);
        chooser.setApproveButtonText(approveButtonText);
        return chooser;
    }

    private static FileDialog getOSXDirectoryChooser() {
        if (!CommonUtils.isMacOSX()) {
            throw new RuntimeException("non-OS X systems should use the getOSXDirectoryChooser method");
        }
        return new FileDialog((Frame)GUIMediator.getAppFrame(), "", CommonUtils.isJava14OrLater() ? 0 : 3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

