/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class ButtonRow
extends JPanel {
    private JButton[] _buttons;
    private final int BUTTON_SEP = 6;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int TOP_GLUE = 10;
    public static final int BOTTOM_GLUE = 11;
    public static final int LEFT_GLUE = 12;
    public static final int RIGHT_GLUE = 13;
    public static final int NO_GLUE = 14;

    public ButtonRow(String[] labelKeys, String[] toolTipKeys, ActionListener[] listeners) {
        this(labelKeys, toolTipKeys, listeners, 0, 14);
    }

    public ButtonRow(String[] labelKeys, String[] toolTipKeys, ActionListener[] listeners, int orientation, int glue) {
        Dimension d;
        if (labelKeys.length != toolTipKeys.length || labelKeys.length != listeners.length || toolTipKeys.length != listeners.length) {
            throw new IllegalArgumentException("invalid ButtonRow constructor: array lengths must be equal");
        }
        BoxLayout bl = new BoxLayout(this, orientation);
        this.setLayout(bl);
        int length = labelKeys.length;
        int sepLength = length - 1;
        this._buttons = new JButton[length];
        Component[] separators = new Component[sepLength];
        int i = 0;
        while (i < length) {
            String label = GUIMediator.getStringResource(labelKeys[i]);
            this._buttons[i] = new JButton(label);
            if (toolTipKeys[i] != null) {
                String tip = GUIMediator.getStringResource(toolTipKeys[i]);
                this._buttons[i].setToolTipText(tip);
            }
            ++i;
        }
        this.setListeners(listeners);
        i = 0;
        if (orientation == 0) {
            d = new Dimension(6, 0);
            while (i < sepLength) {
                separators[i] = Box.createRigidArea(d);
                ++i;
            }
        } else {
            d = new Dimension(0, 6);
            while (i < sepLength) {
                separators[i] = Box.createRigidArea(d);
                ++i;
            }
        }
        i = 0;
        if (glue == 10 && orientation == 1) {
            this.add(Box.createVerticalGlue());
        } else if (glue == 12 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (glue == 14 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        }
        while (i < length) {
            this.add(this._buttons[i]);
            if (i < sepLength) {
                this.add(separators[i]);
            }
            ++i;
        }
        if (glue == 11 && orientation == 1) {
            this.add(Box.createVerticalGlue());
        } else if (glue == 13 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (glue == 14 && orientation == 0) {
            this.add(Box.createHorizontalGlue());
        }
    }

    private void setListeners(ActionListener[] listeners) {
        int i = 0;
        int listenLength = listeners.length;
        int length = this._buttons.length;
        if (listenLength <= length) {
            while (i < length) {
                this._buttons[i].addActionListener(listeners[i]);
                ++i;
            }
        }
    }

    public JButton getButtonAtIndex(int index) {
        if (index > this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._buttons[index];
    }

    public void setButtonEnabled(int buttonIndex, boolean enabled) {
        if (buttonIndex > this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._buttons[buttonIndex].setEnabled(enabled);
    }

    public void setButtonsEnabled(boolean enabled) {
        int i = 0;
        while (i < this._buttons.length) {
            this._buttons[i].setEnabled(enabled);
            ++i;
        }
    }

    public void transformButton(int index, String label, String tip) {
        JButton button = this.getButtonAtIndex(index);
        if (button != null) {
            button.setText(label);
            button.setToolTipText(tip);
        }
    }
}

