/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.KeyProcessingTextField;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.AutoCompleteDictionary;
import com.limegroup.gnutella.util.TrieSet;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.Document;

public class AutoCompleteTextField
extends KeyProcessingTextField {
    protected AutoCompleteDictionary dict;

    public AutoCompleteTextField() {
    }

    public AutoCompleteTextField(Document a, String b, int c) {
        super(a, b, c);
    }

    public AutoCompleteTextField(int a) {
        super(a);
    }

    public AutoCompleteTextField(String a) {
        super(a);
    }

    public AutoCompleteTextField(String a, int b) {
        super(a, b);
    }

    public void setDictionary(AutoCompleteDictionary dict) {
        if (this.dict == null) {
            this.setUp();
        }
        this.dict = dict;
    }

    public AutoCompleteDictionary getDictionary() {
        return this.dict;
    }

    public AutoCompleteDictionary createDefaultDictionary() {
        return new TrieSet(true);
    }

    public void setAutoComplete(boolean val) {
        UISettings.AUTOCOMPLETE_ENABLED.setValue(val);
    }

    public boolean getAutoComplete() {
        return UISettings.AUTOCOMPLETE_ENABLED.getValue();
    }

    public void addToDictionary() {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(this.getText().trim());
    }

    public void addToDictionary(String s) {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(s.trim());
    }

    protected void setUp() {
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                char charPressed = e.getKeyChar();
                int charCodePressed = e.getKeyCode();
                if (charCodePressed == 127 || charPressed == '\uffff' || charCodePressed == 8) {
                    return;
                }
                AutoCompleteTextField.this.autoCompleteInput();
            }
        });
    }

    public void autoCompleteInput() {
        String input;
        String newText;
        if (this.getSelectionStart() != this.getSelectionEnd()) {
            this.setText(this.getText().substring(0, this.getSelectionStart()));
        }
        if ((newText = this.lookup(input = this.getText())) != null) {
            this.setText(input + newText.substring(input.length()));
            this.setSelectionStart(input.length());
            this.setSelectionEnd(this.getText().length());
        }
    }

    protected String lookup(String s) {
        if (this.dict != null && this.getAutoComplete() && !s.equals("")) {
            return this.dict.lookup(s);
        }
        return null;
    }
}

