/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HeadRequester;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.MiniRemoteFileDesc;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.RemoteFileDescGrouper;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.URLRemoteFileDesc;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedDownloader
implements Downloader,
Serializable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$downloader$ManagedDownloader == null ? (class$com$limegroup$gnutella$downloader$ManagedDownloader = ManagedDownloader.class$("com.limegroup.gnutella.downloader.ManagedDownloader")) : class$com$limegroup$gnutella$downloader$ManagedDownloader);
    static final long serialVersionUID = 2772570805975885257L;
    private Object stealLock;
    private DownloadManager manager;
    private FileManager fileManager;
    private IncompleteFileManager incompleteFileManager;
    private ActivityCallback callback;
    private RemoteFileDesc[] allFiles;
    private static final int NORMAL_CONNECT_TIME = 10000;
    private static final int PUSH_CONNECT_TIME = 16000;
    private static final int MIN_SPLIT_SIZE = 100000;
    private static final int CHUNK_SIZE = 100000;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    static final int OVERLAP_BYTES = 10;
    private static final int MAX_CORRUPTION_RECOVERY_ATTEMPTS = 5;
    static int TIME_BETWEEN_REQUERIES = 300000;
    private static final int REQUERY_ATTEMPTS = 1;
    private static final int MATCHER_BUF_SIZE = 120;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    private static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    protected static final String UNKNOWN_FILENAME = "";
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private RemoteFileDescGrouper buckets;
    private List currentRFDs;
    private int bucketNumber;
    private Thread dloaderManagerThread;
    private boolean stopped;
    private List dloaders;
    private List threads;
    private Map queuedThreads;
    private List files;
    private AlternateLocationCollection validAlts;
    private Set invalidAlts;
    private Set recentInvalidAlts;
    private VerifyingFile commonOutFile;
    private Map miniRFDToLock;
    private Map threadLockToSocket;
    private int state;
    private long stateTime;
    private int retriesWaiting;
    private File incompleteFile;
    private File completeFile;
    private String queuePosition;
    private String queuedVendor;
    private String currentLocation;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private RequeryLock reqLock = new RequeryLock();
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private HashTree hashTree = null;
    private static final BandwidthTrackerImpl BANDWIDTH_TRACKER_IMPL = new BandwidthTrackerImpl();
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    static final boolean RECORD_STATS = !CommonUtils.isJava118();
    private final GUID originalQueryGUID;
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private boolean initDone;
    private final long SIXTY_KB = 60000L;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    private static final int CONNECTION_DELAY = 500;
    static boolean NO_DELAY = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$ManagedDownloader;

    public ManagedDownloader(RemoteFileDesc[] files, IncompleteFileManager ifc, GUID originalQueryGUID) {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        this.initDone = false;
        this.SIXTY_KB = 60000L;
        if (files == null) {
            throw new NullPointerException("null RFDS");
        }
        if (ifc == null) {
            throw new NullPointerException("null incomplete file manager");
        }
        this.allFiles = files;
        this.incompleteFileManager = ifc;
        this.originalQueryGUID = originalQueryGUID;
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.allFiles);
        IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
        synchronized (incompleteFileManager) {
            stream.writeObject(this.incompleteFileManager);
        }
        stream.writeObject(BANDWIDTH_TRACKER_IMPL);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.allFiles = (RemoteFileDesc[])stream.readObject();
        this.incompleteFileManager = (IncompleteFileManager)stream.readObject();
        stream.readObject();
        this.reqLock = new RequeryLock();
    }

    public void initialize(DownloadManager manager, FileManager fileManager, ActivityCallback callback, final boolean deserialized) {
        this.manager = manager;
        this.fileManager = fileManager;
        this.callback = callback;
        this.dloaders = new LinkedList();
        this.threads = new ArrayList();
        this.queuedThreads = new HashMap();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stealLock = new Object();
        this.stopped = false;
        this.setState(0);
        this.miniRFDToLock = Collections.synchronizedMap(new HashMap());
        this.threadLockToSocket = Collections.synchronizedMap(new HashMap());
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.altLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.invalidAlts = new FixedSizeExpiringSet(1000, 3600000L);
        this.recentInvalidAlts = new FixedSizeExpiringSet(10, 600000L);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
            if (this.shouldInitAltLocs(deserialized)) {
                this.initializeAlternateLocations();
            }
        }
        this.dloaderManagerThread = new ManagedThread("ManagedDownload"){

            public void managedRun() {
                try {
                    ManagedDownloader.this.tryAllDownloads(deserialized);
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                }
            }
        };
        this.dloaderManagerThread.setDaemon(true);
        this.dloaderManagerThread.start();
    }

    protected void initializeIncompleteFile(File incFile) {
        if (this.incompleteFile != null) {
            return;
        }
        this.incompleteFile = incFile;
        this.commonOutFile = this.incompleteFileManager.getEntry(incFile);
    }

    private synchronized void initializeAlternateLocations() {
        if (this.incompleteFile == null) {
            return;
        }
        URN hash = this.incompleteFileManager.getCompletedHash(this.incompleteFile);
        if (hash != null) {
            long size = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            FileDesc fd = this.fileManager.getFileDescForUrn(hash);
            if (fd != null) {
                AlternateLocationCollection coll;
                this.validAlts = AlternateLocationCollection.create(hash);
                AlternateLocationCollection alternateLocationCollection = coll = fd.getAlternateLocationCollection();
                synchronized (alternateLocationCollection) {
                    Iterator iter = coll.iterator();
                    while (iter.hasNext()) {
                        AlternateLocation loc = (AlternateLocation)iter.next();
                        this.addDownload(loc.createRemoteFileDesc((int)size), false);
                    }
                }
            }
        }
    }

    public boolean conflicts(RemoteFileDesc other) {
        try {
            File otherFile = this.incompleteFileManager.getFile(other);
            return this.conflicts(otherFile);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean conflicts(File incFile) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            int i = 0;
            while (i < this.allFiles.length) {
                RemoteFileDesc rfd = this.allFiles[i];
                try {
                    File thisFile = this.incompleteFileManager.getFile(rfd);
                    if (thisFile.equals(incFile)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (IOException ioe) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean conflicts(URN urn) {
        Assert.that(urn != null, "attempting to check conflicts with null urn");
        File otherFile = this.incompleteFileManager.getFileForUrn(urn);
        if (otherFile == null) {
            return false;
        }
        return this.conflicts(otherFile);
    }

    protected synchronized QueryRequest newRequery(int numRequeries) throws CantResumeException {
        if (this.allFiles.length < 0) {
            throw new CantResumeException(UNKNOWN_FILENAME);
        }
        if (this.allFiles[0].getSHA1Urn() == null) {
            return QueryRequest.createQuery(this.extractQueryString());
        }
        return QueryRequest.createQuery(this.extractQueryString());
    }

    protected int getQueryCount(boolean deserializedFromDisk) {
        return 0;
    }

    protected boolean pauseForRequery(int numRequeries, boolean deserializedFromDisk) throws InterruptedException {
        if (numRequeries >= 1) {
            return false;
        }
        boolean retVal = false;
        RequeryLock requeryLock = this.reqLock;
        synchronized (requeryLock) {
            this.setState(13);
            try {
                retVal = this.reqLock.lock(0L);
            }
            catch (InterruptedException stopException) {
                if (!this.stopped) {
                    ErrorService.error(stopException);
                }
                throw stopException;
            }
        }
        return retVal;
    }

    protected boolean shouldInitAltLocs(boolean deserializedFromDisk) {
        return false;
    }

    private final synchronized String extractQueryString() {
        Assert.that(this.allFiles.length > 0, "Precondition violated");
        String retString = null;
        int MAX_LEN = 30;
        Set intersection = ManagedDownloader.keywords(this.allFiles[0].getFileName());
        if (intersection.size() < 1) {
            retString = StringUtils.truncate(this.allFiles[0].getFileName(), 30);
        } else {
            StringBuffer sb = new StringBuffer();
            int numWritten = 0;
            Iterator keys = intersection.iterator();
            while (keys.hasNext() && numWritten < 30) {
                String currKey = (String)keys.next();
                if (numWritten + currKey.length() >= 30) continue;
                if (numWritten > 0) {
                    sb.append(" ");
                }
                sb.append(currKey);
                numWritten += currKey.length() + (numWritten == 0 ? 0 : 1);
            }
            retString = sb.toString();
            if (retString.equals(UNKNOWN_FILENAME)) {
                retString = StringUtils.truncate(this.allFiles[0].getFileName(), 30);
            }
        }
        Assert.that(retString.length() <= 30, "Original filename: " + this.allFiles[0].getFileName() + ", converted: " + retString);
        Assert.that(!retString.equals(UNKNOWN_FILENAME), "Original filename: " + this.allFiles[0].getFileName());
        Assert.that(retString != null, "Original filename: " + this.allFiles[0].getFileName());
        retString = I18NConvert.instance().getNorm(retString);
        Assert.that(!retString.equals(UNKNOWN_FILENAME), "I18N: Original filename: " + this.allFiles[0].getFileName());
        Assert.that(retString != null, "I18N: Original filename: " + this.allFiles[0].getFileName());
        return retString;
    }

    private static final Set keywords(String fileName) {
        fileName = ManagedDownloader.ripExtension(fileName);
        HashSet ret = new HashSet();
        StringTokenizer st = new StringTokenizer(fileName, " -._+/*()\\");
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().toLowerCase();
            try {
                new Double(currToken);
            }
            catch (NumberFormatException normalWord) {
                if (TRIVIAL_WORDS.contains(currToken)) continue;
                ret.add(currToken);
            }
        }
        return ret;
    }

    private static String ripExtension(String fileName) {
        String retString = null;
        int extStart = fileName.lastIndexOf(46);
        retString = extStart == -1 ? fileName : fileName.substring(0, extStart);
        return retString;
    }

    protected boolean allowAddition(RemoteFileDesc other) {
        Object object;
        if (!this.initDone) {
            object = matcher;
            synchronized (object) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            this.initDone = true;
        }
        if (other.getQuality() < 1) {
            return false;
        }
        if (!IPFilter.instance().allow(other.getHost())) {
            return false;
        }
        object = this.altLock;
        synchronized (object) {
            if (other.isFromAlternateLocation() && this.invalidAlts.contains(other.getRemoteHostData())) {
                boolean bl = false;
                return bl;
            }
        }
        URN otherUrn = other.getSHA1Urn();
        String otherName = other.getFileName();
        long otherLength = other.getSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            int i = 0;
            while (i < this.allFiles.length) {
                RemoteFileDesc rfd = this.allFiles[i];
                URN urn = rfd.getSHA1Urn();
                if (otherUrn != null && urn != null) {
                    boolean bl = otherUrn.equals(urn);
                    return bl;
                }
                String thisName = rfd.getFileName();
                long thisLength = rfd.getSize();
                if (this.sizeClose(otherLength, thisLength) && this.namesClose(otherName, thisName)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
        }
        return false;
    }

    private final boolean sizeClose(long one, long two) {
        boolean retVal = false;
        if (one == two) {
            retVal = true;
        } else {
            long sizeDiff = Math.abs(one - two);
            if (sizeDiff <= 60000L) {
                retVal = true;
            }
        }
        return retVal;
    }

    private final boolean namesClose(String one, String two) {
        boolean retVal = false;
        int allowedDifferences = Math.round(Math.min(0.1f * (float)ManagedDownloader.ripExtension(one).length(), 0.1f * (float)ManagedDownloader.ripExtension(two).length()));
        allowedDifferences = Math.min(allowedDifferences, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            retVal = matcher.matches(matcher.process(one), matcher.process(two), allowedDifferences);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD.namesClose(): one = " + one);
            LOG.debug("MD.namesClose(): two = " + two);
            LOG.debug("MD.namesClose(): retVal = " + retVal);
        }
        return retVal;
    }

    public synchronized boolean addDownload(RemoteFileDesc rfd, boolean cache) {
        if (!this.allowAddition(rfd)) {
            return false;
        }
        return this.addDownloadForced(rfd, cache);
    }

    protected final synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        rfd.setDownloading(true);
        if (NetworkUtils.isMe(rfd.getHost(), rfd.getPort())) {
            return true;
        }
        if (cache) {
            int i = 0;
            while (i < this.allFiles.length) {
                if (rfd.equals(this.allFiles[i])) {
                    cache = false;
                    break;
                }
                ++i;
            }
        }
        boolean added = false;
        if (this.shouldAllowRFD(rfd)) {
            boolean bl = added = this.buckets.add(rfd, true) != -1;
        }
        if (cache) {
            RemoteFileDesc[] newAllFiles = new RemoteFileDesc[this.allFiles.length + 1];
            System.arraycopy(this.allFiles, 0, newAllFiles, 0, this.allFiles.length);
            newAllFiles[newAllFiles.length - 1] = rfd;
            this.allFiles = newAllFiles;
        }
        if (added) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("added rfd: " + rfd);
            }
            if (this.state == 3 || this.state == 8 || this.state == 6 || this.state == 13) {
                this.reqLock.releaseDueToNewResults();
            } else {
                this.notify();
            }
        }
        return true;
    }

    private synchronized boolean shouldAllowRFD(RemoteFileDesc rfd) {
        if (this.buckets == null) {
            return false;
        }
        return this.currentRFDs == null || !this.currentRFDs.contains(rfd);
    }

    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) throws IOException {
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(file, index, clientGUID);
        Object lock = this.miniRFDToLock.get(mrfd);
        if (lock == null) {
            return false;
        }
        this.threadLockToSocket.put(lock, socket);
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
        return true;
    }

    public synchronized void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            ((HTTPDownloader)iter.next()).stop();
        }
        Iterator iter2 = this.threads.iterator();
        while (iter2.hasNext()) {
            ((Thread)iter2.next()).interrupt();
        }
        if (this.dloaderManagerThread != null) {
            this.dloaderManagerThread.interrupt();
        }
    }

    private synchronized void informMesh(RemoteFileDesc rfd, boolean good) {
        URN bucketHash = null;
        IncompleteFileDesc ifd = null;
        AlternateLocation loc = null;
        AlternateLocation forFD = null;
        if (!rfd.isAltLocCapable()) {
            return;
        }
        bucketHash = this.buckets.getURNForBucket(this.bucketNumber);
        Assert.that(bucketHash != null, "null bucketHash.");
        Assert.that(bucketHash.equals(rfd.getSHA1Urn()), "wrong loc SHA1");
        if (this.validAlts == null) {
            this.validAlts = AlternateLocationCollection.create(bucketHash);
        }
        try {
            loc = AlternateLocation.create(rfd);
            forFD = AlternateLocation.create(rfd);
        }
        catch (IOException iox) {
            return;
        }
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            HTTPDownloader httpDloader = (HTTPDownloader)iter.next();
            RemoteFileDesc r = httpDloader.getRemoteFileDesc();
            if (r.getHost() == rfd.getHost() && r.getPort() == rfd.getPort()) continue;
            if (good) {
                httpDloader.addSuccessfulAltLoc(loc);
                continue;
            }
            httpDloader.addFailedAltLoc(loc);
        }
        FileDesc fd = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fd != null && fd instanceof IncompleteFileDesc && !bucketHash.equals((ifd = (IncompleteFileDesc)fd).getSHA1Urn())) {
            Assert.silent(false, "wrong IFD.\nours  :   " + this.incompleteFile + "\ntheirs: " + ifd.getFile() + "\nour hash    : " + bucketHash + "\ntheir hashes: " + DataUtils.listSet(ifd.getUrns()) + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes());
            this.fileManager.removeFileIfShared(this.incompleteFile);
            ifd = null;
        }
        if (good) {
            Object object = this.altLock;
            synchronized (object) {
                if (!this.validAlts.contains(loc)) {
                    if (RECORD_STATS && rfd.isFromAlternateLocation()) {
                        DownloadStat.ALTERNATE_WORKED.incrementStat();
                    }
                    this.validAlts.add(loc);
                    if (ifd != null) {
                        ifd.addVerified(forFD);
                    }
                } else {
                    if (RECORD_STATS && rfd.isFromAlternateLocation()) {
                        DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
                    }
                    this.validAlts.remove(loc);
                    if (ifd != null) {
                        ifd.remove(forFD);
                    }
                    this.invalidAlts.add(rfd.getRemoteHostData());
                    this.recentInvalidAlts.add(loc);
                }
            }
        }
    }

    public boolean resume() throws AlreadyDownloadingException {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.state != 3 && this.state != 6 && this.state != 5 && this.state != 13) {
                boolean bl = false;
                return bl;
            }
        }
        String conflict = this.manager.conflicts(this.allFiles, this);
        if (conflict != null) {
            throw new AlreadyDownloadingException(conflict);
        }
        ManagedDownloader managedDownloader2 = this;
        synchronized (managedDownloader2) {
            if (this.state == 6 || this.state == 5) {
                if (this.state == 6 && this.dloaderManagerThread != null && this.dloaderManagerThread.isAlive()) {
                    ManagedDownloader managedDownloader3 = this;
                    synchronized (managedDownloader3) {
                        this.buckets = new RemoteFileDescGrouper(this.allFiles, this.incompleteFileManager);
                    }
                    this.reqLock.releaseDueToNewResults();
                } else {
                    this.initialize(this.manager, this.fileManager, this.callback, false);
                }
            } else if (this.state == 3) {
                if (this.dloaderManagerThread != null) {
                    this.dloaderManagerThread.interrupt();
                }
            } else if (this.state == 13) {
                this.reqLock.releaseDueToRequery();
            }
            boolean bl = true;
            return bl;
        }
    }

    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 4) {
            return this.completeFile;
        }
        return this.incompleteFile;
    }

    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        if (this.state != 4) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            int size = this.amountForPreview();
            if (size <= 0) {
                return null;
            }
            if (CommonUtils.copy(this.incompleteFile, size, file) <= 0) {
                return null;
            }
            return file;
        }
        return this.completeFile;
    }

    private synchronized int amountForPreview() {
        if (this.commonOutFile == null) {
            return 0;
        }
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iter = this.commonOutFile.getBlocks();
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                if (interval.low != 0) continue;
                int n = interval.high;
                return n;
            }
        }
        return 0;
    }

    protected long[] getFailedState(boolean deserialized, long timeSpentWaiting) {
        return new long[2];
    }

    public synchronized void finish() {
        if (this.commonOutFile != null) {
            this.commonOutFile.clearManagedDownloader();
        }
        if (this.allFiles != null) {
            int i = 0;
            while (i < this.allFiles.length) {
                this.allFiles[i].setDownloading(false);
                ++i;
            }
        }
    }

    private URN getBestURN() {
        URN retURN = null;
        List urns = this.buckets.getURNs();
        int currBigSize = 0;
        Iterator iter = urns.iterator();
        while (iter.hasNext()) {
            VerifyingFile vF;
            File incomplete;
            URN currURN = (URN)iter.next();
            if (currURN == null || (incomplete = this.incompleteFileManager.getFileForUrn(currURN)) == null || (vF = this.incompleteFileManager.getEntry(incomplete)) == null || retURN != null && vF.getBlockSize() <= currBigSize) continue;
            currBigSize = vF.getBlockSize();
            retURN = currURN;
        }
        if (retURN == null) {
            retURN = this.buckets.getBestURN();
        }
        return retURN;
    }

    /*
     * Unable to fully structure code
     */
    protected void tryAllDownloads(boolean deserializedFromDisk) {
        numQueries = this.getQueryCount(deserializedFromDisk);
        timeQuerySent = System.currentTimeMillis();
        timeSpentWaiting = 0L;
        triedLocatingSources = false;
        block9: while (true) {
            try {
                while (true) {
                    block29: {
                        this.setState(0);
                        this.queuePosition = "";
                        this.queuedVendor = "";
                        this.manager.waitForSlot(this);
                        waitForRetry = false;
                        currentBucket = 0;
                        try {
                            iter = this.buckets.buckets();
                            while (iter.hasNext()) {
                                this.bucketNumber = currentBucket;
                                this.cleanup();
                                this.files = (List)iter.next();
                                if (this.checkHosts()) {
                                    this.setState(6);
                                    return;
                                }
                                if (this.files.size() > 0) {
                                    status = this.tryAllDownloads2();
                                    if (status == 4) {
                                        this.setState(4);
                                        this.manager.remove(this, true);
                                        return;
                                    }
                                    if (status == 7) {
                                        this.setState(7);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (status == 9) {
                                        this.setState(9);
                                        this.manager.remove(this, false);
                                        return;
                                    }
                                    if (status == 3) {
                                        waitForRetry = true;
                                    } else {
                                        Assert.that(status == 6, "Bad status from tad2: " + status);
                                    }
                                }
                                ++currentBucket;
                            }
                        }
                        catch (InterruptedException e) {
                            if (this.stopped) break block29;
                            ErrorService.error(e);
                        }
                    }
                    this.manager.yieldSlot(this);
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    Assert.that(this.getState() != 6);
                    Assert.that(this.getState() != 4);
                    Assert.that(this.getState() != 7);
                    Assert.that(this.getState() != 9);
                    if (this.originalQueryGUID != null && !triedLocatingSources && (guessLocs = (mr = RouterService.getMessageRouter()).getGuessLocs(this.originalQueryGUID)) != null && !guessLocs.isEmpty()) {
                        this.setState(15);
                        triedLocatingSources = true;
                        areThereNewResults = false;
                        bestURN = this.getBestURN();
                        i = guessLocs.iterator();
                        while (bestURN != null && i.hasNext()) {
                            ep = (GUESSEndpoint)i.next();
                            OnDemandUnicaster.query(ep, bestURN);
                            if (areThereNewResults) continue;
                            areThereNewResults = this.reqLock.lock(750L);
                        }
                        if (areThereNewResults) continue;
                    }
                    if (this.stopped) {
                        this.setState(5);
                        this.manager.remove(this, false);
                        return;
                    }
                    currTime = System.currentTimeMillis();
                    if (waitForRetry) {
                        areThereNewResults = this;
                        synchronized (areThereNewResults) {
                            this.retriesWaiting = 0;
                            iter = this.buckets.buckets();
                            while (iter.hasNext()) {
                                bucket = (List)iter.next();
                                this.retriesWaiting += bucket.size();
                            }
                        }
                        time = this.calculateWaitTime();
                        this.setState(3, time);
                        this.reqLock.lock(time);
                        continue block9;
                    }
                    areThereNewResults = false;
                    timeToWait = (long)ManagedDownloader.TIME_BETWEEN_REQUERIES - (System.currentTimeMillis() - timeQuerySent);
                    if (numQueries > 0 && timeToWait > 0L) {
                        this.setState(8, timeToWait);
                        areThereNewResults = this.reqLock.lock(timeToWait);
                    }
                    if (areThereNewResults) continue block9;
                    if (!this.pauseForRequery(numQueries, deserializedFromDisk)) break;
                }
                if (numQueries < 1) {
                    this.waitForStableConnections();
                    try {
                        if (this.manager.sendQuery(this, this.newRequery(numQueries))) {
                            ++numQueries;
                        }
                        timeQuerySent = System.currentTimeMillis();
                    }
                    catch (CantResumeException ignore) {}
                    continue;
                }
                instructions = this.getFailedState(deserializedFromDisk, timeSpentWaiting);
                if (instructions[1] > 0L) {
                    this.setState((int)instructions[0], instructions[1]);
                    this.reqLock.lock(instructions[1]);
                    timeSpentWaiting += System.currentTimeMillis() - currTime;
                    continue;
                }
                this.setState(6);
                this.reqLock.lock(0L);
                continue;
            }
            catch (InterruptedException e) {
                if (this.stopped) ** break;
                continue;
                this.setState(5);
                this.manager.remove(this, false);
                return;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void waitForStableConnections() throws InterruptedException {
        if (!ManagedDownloader.NO_DELAY) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            this.setState(14);
            Thread.sleep(500L);
lbl5:
            // 2 sources

            ** while (RouterService.countConnectionsWithNMessages((int)6) < 2 && RouterService.getActiveConnectionMessages() < 45)
        }
lbl6:
        // 1 sources

    }

    private synchronized long calculateWaitTime() {
        if (this.files == null || this.files.size() == 0) {
            return 0L;
        }
        int waitTime = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.files.size()) {
            waitTime = Math.min(waitTime, ((RemoteFileDesc)this.files.get(i)).getWaitTime());
            ++i;
        }
        return waitTime * 1000;
    }

    private int tryAllDownloads2() throws InterruptedException {
        URN fileHash;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.files.size() == 0) {
                int n = 6;
                return n;
            }
        }
        String fileName = this.getFileName();
        try {
            this.incompleteFile = this.incompleteFileManager.getFile((RemoteFileDesc)this.files.get(0));
            File saveDir = SharingSettings.getSaveDirectory();
            this.completeFile = new File(saveDir, fileName);
            String savePath = saveDir.getCanonicalPath();
            String completeFileParentPath = new File(this.completeFile.getParent()).getCanonicalPath();
            if (!savePath.equals(completeFileParentPath)) {
                return 7;
            }
        }
        catch (IOException e) {
            ErrorService.error(e, "incomplete: " + this.incompleteFile);
            return 7;
        }
        URN sha1 = this.buckets.getURNForBucket(this.bucketNumber);
        if (sha1 != null) {
            this.validAlts = AlternateLocationCollection.create(sha1);
            this.hashTree = TigerTreeCache.instance().getHashTree(sha1);
        }
        int i = 0;
        while (true) {
            int status = -1;
            try {
                status = this.tryAllDownloads3();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.commonOutFile.close();
            this.waitForCorruptResponse();
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (status == -1) {
                throw new InterruptedException();
            }
            if (status != 4) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("stopping early with status: " + status);
                }
                return status;
            }
            fileHash = this.scanForCorruption(i);
            if (this.corruptState == 2) {
                this.cleanupCorrupt(this.incompleteFile, this.completeFile.getName());
                return 9;
            }
            if (this.state != 16) break;
            ++i;
        }
        return this.saveFile(fileHash);
    }

    private void waitForCorruptResponse() {
        if (this.corruptState != 0) {
            Object object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private URN scanForCorruption(int iteration) {
        if (this.corruptState == 2) {
            return null;
        }
        URN bucketHash = this.buckets.getURNForBucket(this.bucketNumber);
        URN fileHash = null;
        try {
            this.setState(11);
            fileHash = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException ignored) {
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        if (bucketHash == null) {
            return fileHash;
        }
        if (bucketHash.equals(fileHash)) {
            return fileHash;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("hash verification problem, fileHash=" + fileHash + ", bucketHash=" + bucketHash);
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.setState(9);
            this.promptAboutCorruptDownload();
            this.waitForCorruptResponse();
        }
        if (this.corruptState == 2) {
            return fileHash;
        }
        if (iteration == 5) {
            this.treeRecoveryFailed(bucketHash);
        } else if (this.hashTree != null) {
            try {
                this.setState(16);
                LOG.debug("identifying corruption...");
                int deleted = this.commonOutFile.deleteCorruptedBlocks(this.hashTree, this.incompleteFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("deleted " + deleted + " blocks");
                }
                this.corruptState = 0;
                if (deleted == 0) {
                    this.treeRecoveryFailed(bucketHash);
                }
            }
            catch (IOException ioe) {
                LOG.debug(ioe);
                this.treeRecoveryFailed(bucketHash);
            }
        }
        return fileHash;
    }

    private void treeRecoveryFailed(URN hash) {
        TigerTreeCache.instance().purgeTree(hash);
        this.hashTree = null;
        this.promptAboutCorruptDownload();
        this.waitForCorruptResponse();
        this.setState(17);
    }

    private int saveFile(URN fileHash) {
        FileDesc fd;
        this.setState(12);
        File completeFileDir = FileUtils.getParentFile(this.completeFile);
        FileUtils.setWriteable(completeFileDir);
        FileUtils.setWriteable(this.completeFile);
        this.completeFile.delete();
        boolean success = this.incompleteFile.renameTo(this.completeFile);
        if (!success && (fd = RouterService.getFileManager().getFileDescForFile(this.incompleteFile)) != null) {
            UploadManager upMan;
            UploadManager uploadManager = upMan = RouterService.getUploadManager();
            synchronized (uploadManager) {
                if (upMan.killUploadsForFileDesc(fd)) {
                    success = this.incompleteFile.renameTo(this.completeFile);
                }
            }
        }
        if (!success) {
            success = CommonUtils.copy(this.incompleteFile, this.completeFile);
        }
        if (!success) {
            return 7;
        }
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (this.fileExists(this.completeFile)) {
            this.fileManager.removeFileIfShared(this.completeFile);
        }
        if (fileHash != null) {
            HashSet urns = new HashSet(1);
            urns.add(fileHash);
            File file = this.completeFile;
            try {
                file = FileUtils.getCanonicalFile(this.completeFile);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            UrnCache.instance().addUrns(file, urns);
            SavedFileManager.instance().addSavedFile(file, urns);
        }
        FileDesc fileDesc = this.fileManager.addFileIfShared(this.completeFile, this.getXMLDocuments());
        if (this.validAlts != null && fileDesc != null) {
            this.sendAlternateLocations(fileDesc);
        }
        return 4;
    }

    private void sendAlternateLocations(FileDesc fileDesc) {
        URN fileHash = fileDesc.getSHA1Urn();
        if (fileHash.equals(this.validAlts.getSHA1Urn())) {
            LOG.trace("MANAGER: adding valid alts to FileDesc");
            this.addLocationsToFile(this.validAlts, fileDesc);
            this.callback.handleSharedFileUpdate(this.completeFile);
            HashSet set = null;
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                set = new HashSet(this.files);
            }
            if (fileDesc.getSize() < (long)HTTPDownloader.MIN_PARTIAL_FILE_BYTES || !UploadSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                LOG.trace("MANAGER: starting HEAD request");
                HeadRequester requester = new HeadRequester(set, fileHash, fileDesc, fileDesc.getAlternateLocationCollection());
                ManagedThread headThread = new ManagedThread(requester, "HEAD Request Thread");
                headThread.setDaemon(true);
                headThread.start();
            }
        }
    }

    private void addLocationsToFile(AlternateLocationCollection validAlts, AlternateLocationCollector collector) {
        Object object = this.altLock;
        synchronized (object) {
            Iterator i = validAlts.iterator();
            while (i.hasNext()) {
                AlternateLocation al = (AlternateLocation)i.next();
                collector.add(al.createClone());
            }
        }
    }

    private boolean fileExists(File f) {
        return f.exists();
    }

    private void cleanupCorrupt(File incFile, String name) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(incFile);
        boolean renamed = false;
        int i = 0;
        while (i < 10 && !renamed) {
            this.corruptFile = new File(incFile.getParent(), "CORRUPT-" + i + "-" + name);
            if (!this.corruptFile.exists()) {
                renamed = incFile.renameTo(this.corruptFile);
            }
            ++i;
        }
        if (!renamed) {
            incFile.delete();
            this.corruptFile = null;
        }
    }

    private int tryAllDownloads3() throws InterruptedException {
        LOG.trace("MANAGER: entered tryAllDownloads3");
        int completedSize = -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Assert.that(this.incompleteFile != null);
            completedSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
            IncompleteFileManager incompleteFileManager = this.incompleteFileManager;
            synchronized (incompleteFileManager) {
                if (this.commonOutFile != null) {
                    this.commonOutFile.clearManagedDownloader();
                }
                this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
            }
            if (this.commonOutFile == null) {
                LOG.trace("creating a verifying file");
                this.commonOutFile = new VerifyingFile(true, completedSize);
                try {
                    this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile);
                }
                catch (IOException ioe) {
                    ErrorService.error(ioe, "file: " + this.incompleteFile);
                    int n = 7;
                    return n;
                }
            }
            try {
                this.commonOutFile.open(this.incompleteFile, this);
            }
            catch (IOException e) {
                if (!IOUtils.handleException(e, "DOWNLOAD")) {
                    ErrorService.error(e);
                }
                int n = 7;
                return n;
            }
        }
        this.currentRFDs = new LinkedList();
        int size = -1;
        int connectTo = -1;
        int dloadsCount = -1;
        while (true) {
            Object t2;
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                int doneSize;
                if (this.stopped) {
                    LOG.warn("MANAGER: terminating because of stop");
                    throw new InterruptedException();
                }
                if (this.dloaders.size() == 0 && this.commonOutFile.isComplete()) {
                    doneSize = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
                    Assert.that(completedSize == doneSize, "incomplete files (or size!) changed!");
                    int i = this.threads.size();
                    while (i > 0) {
                        t2 = (Thread)this.threads.get(i - 1);
                        ((Thread)t2).interrupt();
                        --i;
                    }
                    LOG.trace("MANAGER: terminating because of completion");
                    int t2 = 4;
                    return t2;
                }
                if (this.threads.size() == 0) {
                    if (this.files.size() > 0 && this.calculateWaitTime() > 0L) {
                        LOG.trace("MANAGER: terminating with busy");
                        doneSize = 3;
                        return doneSize;
                    }
                    if (this.files.size() == 0) {
                        LOG.trace("MANAGER: terminating w/o hope");
                        doneSize = 6;
                        return doneSize;
                    }
                }
            }
            size = this.files.size();
            connectTo = this.getNumAllowedDownloads();
            dloadsCount = this.dloaders.size();
            int i = 0;
            while (i < connectTo + 1 && i < size && dloadsCount < this.getSwarmCapacity()) {
                RemoteFileDesc rfd;
                t2 = this;
                synchronized (t2) {
                    rfd = this.removeBest(this.files);
                    if (rfd.isBusy()) {
                        this.files.add(rfd);
                        break;
                    }
                    this.currentRFDs.add(rfd);
                }
                ManagedThread connectCreator = new ManagedThread("DownloadWorker"){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void managedRun() {
                        ManagedDownloader managedDownloader;
                        boolean iterate = false;
                        try {
                            try {
                                iterate = ManagedDownloader.this.connectAndDownload(rfd);
                            }
                            catch (Throwable e) {
                                iterate = true;
                                if (!(e instanceof InterruptedException)) {
                                    ErrorService.error(e);
                                }
                                Object var4_3 = null;
                                ManagedDownloader managedDownloader3 = ManagedDownloader.this;
                                synchronized (managedDownloader3) {
                                    ManagedDownloader.this.currentRFDs.remove(rfd);
                                    ManagedDownloader.this.threads.remove(this);
                                    if (!iterate) return;
                                    ManagedDownloader.this.notifyAll();
                                    return;
                                }
                            }
                            Object var4_2 = null;
                            managedDownloader = ManagedDownloader.this;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ManagedDownloader managedDownloader2 = ManagedDownloader.this;
                            synchronized (managedDownloader2) {
                                ManagedDownloader.this.currentRFDs.remove(rfd);
                                ManagedDownloader.this.threads.remove(this);
                                if (!iterate) throw throwable;
                                ManagedDownloader.this.notifyAll();
                                throw throwable;
                            }
                        }
                        synchronized (managedDownloader) {
                            ManagedDownloader.this.currentRFDs.remove(rfd);
                            ManagedDownloader.this.threads.remove(this);
                            if (!iterate) return;
                            ManagedDownloader.this.notifyAll();
                            return;
                        }
                    }
                };
                ManagedDownloader managedDownloader3 = this;
                synchronized (managedDownloader3) {
                    this.threads.add(connectCreator);
                }
                connectCreator.start();
                ++i;
            }
            ManagedDownloader managedDownloader4 = this;
            synchronized (managedDownloader4) {
                try {
                    this.wait(4000L);
                }
                catch (InterruptedException ee) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connectAndDownload(RemoteFileDesc rfd) {
        HTTPDownloader dloader;
        block31: {
            boolean bl;
            block35: {
                boolean bl2;
                block34: {
                    ManagedDownloader managedDownloader;
                    boolean bl3;
                    block33: {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("connectAndDownload for: " + rfd);
                        }
                        dloader = null;
                        dloader = this.establishConnection(rfd);
                        if (dloader == null) {
                            return true;
                        }
                        if (this.validAlts != null) {
                            Object object = this.altLock;
                            synchronized (object) {
                                Iterator iter = this.validAlts.iterator();
                                int count = 0;
                                while (true) {
                                    if (!iter.hasNext() || count >= 10) break;
                                    dloader.addSuccessfulAltLoc((AlternateLocation)iter.next());
                                    ++count;
                                }
                                iter = this.recentInvalidAlts.iterator();
                                while (iter.hasNext()) {
                                    dloader.addFailedAltLoc((AlternateLocation)iter.next());
                                }
                            }
                        }
                        boolean http11 = true;
                        try {
                            boolean downloadOK;
                            do {
                                Object object;
                                ConnectionStatus status;
                                block32: {
                                    if (!http11) {
                                        break block31;
                                    }
                                    http11 = rfd.isHTTP11();
                                    while (true) {
                                        HashTree temp;
                                        status = null;
                                        if (dloader.hasHashTree() && (this.hashTree == null || !this.hashTree.isGoodDepth()) && (status = dloader.requestHashTree()).isThexResponse() && (temp = status.getHashTree()).isBetterTree(this.hashTree)) {
                                            this.hashTree = temp;
                                            TigerTreeCache.instance();
                                            TigerTreeCache.addHashTree(rfd.getSHA1Urn(), this.hashTree);
                                        }
                                        dloader.consumeBodyIfNecessary();
                                        object = this.stealLock;
                                        synchronized (object) {
                                            if (status == null || !status.isQueued()) {
                                                status = this.assignAndRequest(dloader, http11);
                                            }
                                            if (!status.isConnected()) {
                                                this.releaseRanges(dloader);
                                            }
                                            if (status.isPartialData()) continue;
                                        }
                                        if (status.isNoFile() || status.isNoData()) break block32;
                                        Assert.that(status.isQueued() || status.isConnected());
                                        boolean addQueued = this.killQueuedIfNecessary(status);
                                        if (status.isConnected()) break block32;
                                        Assert.that(status.isQueued());
                                        if (!addQueued || this.handleQueued(status, dloader)) break;
                                    }
                                    bl3 = true;
                                    Object var13_11 = null;
                                    managedDownloader = this;
                                    break block33;
                                }
                                object = this;
                                synchronized (object) {
                                    this.queuedThreads.remove(Thread.currentThread());
                                }
                                switch (status.getType()) {
                                    case 0: {
                                        dloader.stop();
                                        bl2 = true;
                                        break block34;
                                    }
                                    case 3: {
                                        dloader.stop();
                                        bl = false;
                                        break block35;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("illegal status: " + status.getType());
                                    }
                                }
                                Assert.that(status.isConnected());
                                downloadOK = this.doDownload(dloader, http11);
                                this.releaseRanges(dloader);
                            } while (downloadOK);
                            break block31;
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            ManagedDownloader managedDownloader2 = this;
                            synchronized (managedDownloader2) {
                                this.dloaders.remove(dloader);
                                throw throwable;
                            }
                        }
                    }
                    synchronized (managedDownloader) {
                        this.dloaders.remove(dloader);
                        return bl3;
                    }
                }
                Object var13_12 = null;
                ManagedDownloader managedDownloader = this;
                synchronized (managedDownloader) {
                    this.dloaders.remove(dloader);
                    return bl2;
                }
            }
            Object var13_13 = null;
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.dloaders.remove(dloader);
                return bl;
            }
        }
        Object var13_14 = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.dloaders.remove(dloader);
            return true;
        }
    }

    private boolean handleQueued(ConnectionStatus status, HTTPDownloader dloader) {
        try {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.dloaders.remove(dloader);
            }
            Thread.sleep(status.getQueuePollTime());
            return false;
        }
        catch (InterruptedException ix) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("worker: interrupted while asleep in queue" + dloader);
            }
            this.queuedThreads.remove(Thread.currentThread());
            dloader.stop();
            return true;
        }
    }

    private boolean killQueuedIfNecessary(ConnectionStatus status) {
        Thread killThread = null;
        Thread currentThread = Thread.currentThread();
        int queuePos = status.isQueued() ? status.getQueuePosition() : -1;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.getNumDownloaders() < this.getSwarmCapacity()) {
                if (status.isQueued()) {
                    this.queuedThreads.put(currentThread, new Integer(queuePos));
                }
                boolean bl = true;
                return bl;
            }
            if (this.queuedThreads.containsKey(currentThread)) {
                if (status.isQueued()) {
                    this.queuedThreads.put(currentThread, new Integer(queuePos));
                }
                boolean bl = true;
                return bl;
            }
            Iterator iter = this.queuedThreads.keySet().iterator();
            int highest = queuePos;
            while (iter.hasNext()) {
                Object o = iter.next();
                int currQueue = (Integer)this.queuedThreads.get(o);
                if (currQueue <= highest) continue;
                killThread = (Thread)o;
                highest = currQueue;
            }
            if (killThread == null) {
                boolean bl = false;
                return bl;
            }
            killThread.interrupt();
            if (status.isQueued()) {
                this.queuedThreads.put(currentThread, new Integer(queuePos));
            }
            boolean bl = true;
            return bl;
        }
    }

    private HTTPDownloader establishConnection(RemoteFileDesc rfd) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("establishConnection(" + rfd + ")");
        }
        if (rfd == null) {
            return null;
        }
        if (this.stopped) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                this.files.add(rfd);
            }
            return null;
        }
        File incFile = this.incompleteFile;
        boolean needsPush = ManagedDownloader.needsPush(rfd);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.currentLocation = rfd.getHost();
            if (this.dloaders.size() == 0 && this.getState() != 4 && this.getState() != 5 && this.getState() != 6 && this.getState() != 7 && this.getState() != 9 && this.getState() != 11 && this.getState() != 12 && this.queuedThreads.size() == 0) {
                this.setState(1, needsPush ? 16000L : 10000L);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER: attempting connect to " + rfd.getHost() + ":" + rfd.getPort());
        }
        if (RECORD_STATS) {
            DownloadStat.CONNECTION_ATTEMPTS.incrementStat();
        }
        if (rfd.isReplyToMulticast()) {
            HTTPDownloader ret;
            try {
                ret = this.connectWithPush(rfd, incFile);
            }
            catch (IOException e) {
                try {
                    ret = this.connectDirectly(rfd, incFile);
                }
                catch (IOException e2) {
                    return null;
                }
            }
            return ret;
        }
        if (!needsPush) {
            try {
                HTTPDownloader ret = this.connectDirectly(rfd, incFile);
                return ret;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.informMesh(rfd, false);
        try {
            HTTPDownloader ret = this.connectWithPush(rfd, incFile);
            return ret;
        }
        catch (IOException e) {
            return null;
        }
    }

    private HTTPDownloader connectDirectly(RemoteFileDesc rfd, File incFile) throws IOException {
        LOG.trace("WORKER: attempt direct connection");
        HTTPDownloader ret = new HTTPDownloader(rfd, incFile);
        try {
            ret.connectTCP(10000);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_SUCCESS.incrementStat();
            }
        }
        catch (IOException iox) {
            if (RECORD_STATS) {
                DownloadStat.CONNECT_DIRECT_FAILURES.incrementStat();
            }
            throw iox;
        }
        return ret;
    }

    private HTTPDownloader connectWithPush(RemoteFileDesc rfd, File incFile) throws IOException {
        boolean pushSent;
        LOG.trace("WORKER: attempt push connection");
        Object threadLock = new Object();
        MiniRemoteFileDesc mrfd = new MiniRemoteFileDesc(rfd.getFileName(), rfd.getIndex(), rfd.getClientGUID());
        this.miniRFDToLock.put(mrfd, threadLock);
        Object object = threadLock;
        synchronized (object) {
            pushSent = this.manager.sendPush(rfd);
            if (pushSent) {
                try {
                    threadLock.wait(16000L);
                }
                catch (InterruptedException e) {
                    if (RECORD_STATS) {
                        DownloadStat.PUSH_FAILURE_INTERRUPTED.incrementStat();
                    }
                    throw new IOException("push interupted.");
                }
            }
        }
        Socket pushSocket = (Socket)this.threadLockToSocket.remove(threadLock);
        if (pushSocket == null) {
            if (RECORD_STATS) {
                if (!pushSent) {
                    DownloadStat.PUSH_FAILURE_NO_ROUTE.incrementStat();
                } else {
                    DownloadStat.PUSH_FAILURE_NO_RESPONSE.incrementStat();
                }
            }
            throw new IOException("push socket is null");
        }
        this.miniRFDToLock.remove(mrfd);
        HTTPDownloader ret = new HTTPDownloader(pushSocket, rfd, incFile);
        try {
            ret.connectTCP(0);
            if (RECORD_STATS) {
                DownloadStat.CONNECT_PUSH_SUCCESS.incrementStat();
            }
        }
        catch (IOException iox) {
            if (RECORD_STATS) {
                DownloadStat.PUSH_FAILURE_LOST.incrementStat();
            }
            throw iox;
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    private ConnectionStatus assignAndRequest(HTTPDownloader dloader, boolean http11) {
        RemoteFileDesc rfd;
        block114: {
            Throwable throwable222;
            block126: {
                AlternateLocationCollection alternateLocationCollection;
                AlternateLocationCollection c2222;
                rfd = dloader.getRemoteFileDesc();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("assignAndRequest for: " + rfd);
                }
                try {
                    block113: {
                        if (this.commonOutFile.hasFreeBlocksToAssign()) {
                            this.assignWhite(dloader, http11);
                            break block113;
                        }
                        this.assignGrey(dloader, http11);
                    }
                    Object var18_4 = null;
                    c2222 = dloader.getAltLocsReceived();
                    if (c2222 == null) break block114;
                    alternateLocationCollection = c2222;
                }
                catch (Throwable throwable222) {
                    Object var18_16 = null;
                    AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                    if (c2222 == null) break block126;
                    AlternateLocationCollection alternateLocationCollection2 = c2222;
                    synchronized (alternateLocationCollection2) {
                        Iterator iter = c2222.iterator();
                        while (iter.hasNext()) {
                            AlternateLocation al = (AlternateLocation)iter.next();
                            RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                            this.addDownload(rfd1, false);
                        }
                    }
                }
                synchronized (alternateLocationCollection) {
                    Iterator iter = c2222.iterator();
                    while (iter.hasNext()) {
                        AlternateLocation al = (AlternateLocation)iter.next();
                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                        this.addDownload(rfd1, false);
                    }
                }
                {
                    Object object;
                    block125: {
                        ConnectionStatus connectionStatus;
                        block124: {
                            ConnectionStatus newPos222;
                            block123: {
                                ConnectionStatus oldPos222222;
                                block122: {
                                    ConnectionStatus oldPos222222;
                                    block121: {
                                        ConnectionStatus connectionStatus2;
                                        block120: {
                                            ConnectionStatus connectionStatus3;
                                            block119: {
                                                ConnectionStatus connectionStatus4;
                                                block118: {
                                                    ConnectionStatus connectionStatus5;
                                                    block117: {
                                                        ConnectionStatus connectionStatus6;
                                                        block116: {
                                                            ConnectionStatus connectionStatus7;
                                                            block115: {
                                                                catch (NoSuchElementException nsex) {
                                                                    if (RECORD_STATS) {
                                                                        DownloadStat.NSE_EXCEPTION.incrementStat();
                                                                    }
                                                                    if (LOG.isDebugEnabled()) {
                                                                        LOG.debug("nsex thrown in assingAndRequest " + dloader, nsex);
                                                                    }
                                                                    ManagedDownloader managedDownloader = this;
                                                                    synchronized (managedDownloader) {
                                                                        this.files.add(rfd);
                                                                    }
                                                                    connectionStatus7 = ConnectionStatus.getNoData();
                                                                    Object var18_5 = null;
                                                                    AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                                                    if (c2222 == null) break block115;
                                                                    AlternateLocationCollection alternateLocationCollection3 = c2222;
                                                                    synchronized (alternateLocationCollection3) {
                                                                        Iterator iter = c2222.iterator();
                                                                        while (iter.hasNext()) {
                                                                            AlternateLocation al = (AlternateLocation)iter.next();
                                                                            RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                                            this.addDownload(rfd1, false);
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            return connectionStatus7;
                                                            catch (NoSuchRangeException nsrx) {
                                                                if (RECORD_STATS) {
                                                                    DownloadStat.NSR_EXCEPTION.incrementStat();
                                                                }
                                                                if (LOG.isDebugEnabled()) {
                                                                    LOG.debug("nsrx thrown in assignAndRequest " + dloader, nsrx);
                                                                }
                                                                ManagedDownloader managedDownloader = this;
                                                                synchronized (managedDownloader) {
                                                                    rfd.setAvailableRanges(null);
                                                                    if (!rfd.isBusy()) {
                                                                        rfd.setRetryAfter(300);
                                                                    }
                                                                    this.files.add(rfd);
                                                                }
                                                                rfd.resetFailedCount();
                                                                connectionStatus6 = ConnectionStatus.getNoFile();
                                                                Object var18_6 = null;
                                                                AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                                                if (c2222 == null) break block116;
                                                                AlternateLocationCollection alternateLocationCollection4 = c2222;
                                                                synchronized (alternateLocationCollection4) {
                                                                    Iterator iter = c2222.iterator();
                                                                    while (iter.hasNext()) {
                                                                        AlternateLocation al = (AlternateLocation)iter.next();
                                                                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                                        this.addDownload(rfd1, false);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        return connectionStatus6;
                                                        catch (TryAgainLaterException talx) {
                                                            if (RECORD_STATS) {
                                                                DownloadStat.TAL_EXCEPTION.incrementStat();
                                                            }
                                                            if (LOG.isDebugEnabled()) {
                                                                LOG.debug("talx thrown in assignAndRequest " + dloader, talx);
                                                            }
                                                            if (!rfd.isBusy()) {
                                                                rfd.setRetryAfter(60);
                                                            }
                                                            ManagedDownloader managedDownloader = this;
                                                            synchronized (managedDownloader) {
                                                                if (this.dloaders.size() > 0 && rfd.getWaitTime() < 600) {
                                                                    rfd.setRetryAfter(600);
                                                                }
                                                                this.files.add(rfd);
                                                            }
                                                            rfd.resetFailedCount();
                                                            connectionStatus5 = ConnectionStatus.getNoFile();
                                                            Object var18_7 = null;
                                                            AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                                            if (c2222 == null) break block117;
                                                            AlternateLocationCollection alternateLocationCollection5 = c2222;
                                                            synchronized (alternateLocationCollection5) {
                                                                Iterator iter = c2222.iterator();
                                                                while (iter.hasNext()) {
                                                                    AlternateLocation al = (AlternateLocation)iter.next();
                                                                    RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                                    this.addDownload(rfd1, false);
                                                                }
                                                            }
                                                        }
                                                    }
                                                    return connectionStatus5;
                                                    catch (RangeNotAvailableException rnae) {
                                                        if (RECORD_STATS) {
                                                            DownloadStat.RNA_EXCEPTION.incrementStat();
                                                        }
                                                        if (LOG.isDebugEnabled()) {
                                                            LOG.debug("rnae thrown in assignAndRequest " + dloader, rnae);
                                                        }
                                                        rfd.resetFailedCount();
                                                        this.informMesh(rfd, true);
                                                        connectionStatus4 = ConnectionStatus.getPartialData();
                                                        Object var18_8 = null;
                                                        AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                                        if (c2222 == null) break block118;
                                                        AlternateLocationCollection alternateLocationCollection6 = c2222;
                                                        synchronized (alternateLocationCollection6) {
                                                            Iterator iter = c2222.iterator();
                                                            while (iter.hasNext()) {
                                                                AlternateLocation al = (AlternateLocation)iter.next();
                                                                RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                                this.addDownload(rfd1, false);
                                                            }
                                                        }
                                                    }
                                                }
                                                return connectionStatus4;
                                                catch (FileNotFoundException fnfx) {
                                                    if (RECORD_STATS) {
                                                        DownloadStat.FNF_EXCEPTION.incrementStat();
                                                    }
                                                    if (LOG.isDebugEnabled()) {
                                                        LOG.debug("fnfx thrown in assignAndRequest" + dloader, fnfx);
                                                    }
                                                    this.informMesh(rfd, false);
                                                    connectionStatus3 = ConnectionStatus.getNoFile();
                                                    Object var18_9 = null;
                                                    AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                                    if (c2222 == null) break block119;
                                                    AlternateLocationCollection alternateLocationCollection7 = c2222;
                                                    synchronized (alternateLocationCollection7) {
                                                        Iterator iter = c2222.iterator();
                                                        while (iter.hasNext()) {
                                                            AlternateLocation al = (AlternateLocation)iter.next();
                                                            RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                            this.addDownload(rfd1, false);
                                                        }
                                                    }
                                                }
                                            }
                                            return connectionStatus3;
                                            catch (NotSharingException nsx) {
                                                if (RECORD_STATS) {
                                                    DownloadStat.NS_EXCEPTION.incrementStat();
                                                }
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug("nsx thrown in assignAndRequest " + dloader, nsx);
                                                }
                                                this.informMesh(rfd, false);
                                                connectionStatus2 = ConnectionStatus.getNoFile();
                                                Object var18_10 = null;
                                                AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                                if (c2222 == null) break block120;
                                                AlternateLocationCollection alternateLocationCollection8 = c2222;
                                                synchronized (alternateLocationCollection8) {
                                                    Iterator iter = c2222.iterator();
                                                    while (iter.hasNext()) {
                                                        AlternateLocation al = (AlternateLocation)iter.next();
                                                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                        this.addDownload(rfd1, false);
                                                    }
                                                }
                                            }
                                        }
                                        return connectionStatus2;
                                        catch (QueuedException qx) {
                                            if (RECORD_STATS) {
                                                DownloadStat.Q_EXCEPTION.incrementStat();
                                            }
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug("qx thrown in assignAndRequest " + dloader, qx);
                                            }
                                            ManagedDownloader managedDownloader = this;
                                            synchronized (managedDownloader) {
                                                if (this.dloaders.size() == 0) {
                                                    this.setState(10);
                                                }
                                                int oldPos222222 = this.queuePosition.equals(UNKNOWN_FILENAME) ? Integer.MAX_VALUE : Integer.parseInt(this.queuePosition);
                                                int newPos222 = qx.getQueuePosition();
                                                if (newPos222 < oldPos222222) {
                                                    this.queuePosition = UNKNOWN_FILENAME + newPos222;
                                                    this.queuedVendor = dloader.getVendor();
                                                }
                                            }
                                            rfd.resetFailedCount();
                                            oldPos222222 = ConnectionStatus.getQueued(qx.getQueuePosition(), qx.getMinPollTime());
                                            Object var18_11 = null;
                                            AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                            if (c2222 == null) break block121;
                                            AlternateLocationCollection alternateLocationCollection9 = c2222;
                                            synchronized (alternateLocationCollection9) {
                                                Iterator iter = c2222.iterator();
                                                while (iter.hasNext()) {
                                                    AlternateLocation al = (AlternateLocation)iter.next();
                                                    RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                    this.addDownload(rfd1, false);
                                                }
                                            }
                                        }
                                    }
                                    return oldPos222222;
                                    catch (ProblemReadingHeaderException prhe) {
                                        if (RECORD_STATS) {
                                            DownloadStat.PRH_EXCEPTION.incrementStat();
                                        }
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("prhe thrown in assignAndRequest " + dloader, prhe);
                                        }
                                        this.informMesh(rfd, false);
                                        oldPos222222 = ConnectionStatus.getNoFile();
                                        Object var18_12 = null;
                                        AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                        if (c2222 == null) break block122;
                                        AlternateLocationCollection alternateLocationCollection10 = c2222;
                                        synchronized (alternateLocationCollection10) {
                                            Iterator iter = c2222.iterator();
                                            while (iter.hasNext()) {
                                                AlternateLocation al = (AlternateLocation)iter.next();
                                                RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                                this.addDownload(rfd1, false);
                                            }
                                        }
                                    }
                                }
                                return oldPos222222;
                                catch (UnknownCodeException uce) {
                                    if (RECORD_STATS) {
                                        DownloadStat.UNKNOWN_CODE_EXCEPTION.incrementStat();
                                    }
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug("uce (" + uce.getCode() + ") thrown in assignAndRequest " + dloader, uce);
                                    }
                                    this.informMesh(rfd, false);
                                    newPos222 = ConnectionStatus.getNoFile();
                                    Object var18_13 = null;
                                    AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                    if (c2222 == null) break block123;
                                    AlternateLocationCollection alternateLocationCollection11 = c2222;
                                    synchronized (alternateLocationCollection11) {
                                        Iterator iter = c2222.iterator();
                                        while (iter.hasNext()) {
                                            AlternateLocation al = (AlternateLocation)iter.next();
                                            RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                            this.addDownload(rfd1, false);
                                        }
                                    }
                                }
                            }
                            return newPos222;
                            catch (ContentUrnMismatchException cume) {
                                if (RECORD_STATS) {
                                    DownloadStat.CONTENT_URN_MISMATCH_EXCEPTION.incrementStat();
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("cume thrown in assignAndRequest " + dloader, cume);
                                }
                                connectionStatus = ConnectionStatus.getNoFile();
                                Object var18_14 = null;
                                AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                                if (c2222 == null) break block124;
                                AlternateLocationCollection alternateLocationCollection12 = c2222;
                                synchronized (alternateLocationCollection12) {
                                    Iterator iter = c2222.iterator();
                                    while (iter.hasNext()) {
                                        AlternateLocation al = (AlternateLocation)iter.next();
                                        RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                        this.addDownload(rfd1, false);
                                    }
                                }
                            }
                        }
                        return connectionStatus;
                        catch (IOException iox) {
                            if (RECORD_STATS) {
                                DownloadStat.IO_EXCEPTION.incrementStat();
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("iox thrown in assignAndRequest " + dloader, iox);
                            }
                            rfd.incrementFailedCount();
                            if (rfd.getFailedCount() < 2) {
                                rfd.setRetryAfter(60);
                                object = this;
                                synchronized (object) {
                                    this.files.add(rfd);
                                }
                            } else {
                                this.informMesh(rfd, false);
                            }
                            object = ConnectionStatus.getNoFile();
                            Object var18_15 = null;
                            AlternateLocationCollection c2222 = dloader.getAltLocsReceived();
                            if (c2222 == null) break block125;
                            AlternateLocationCollection alternateLocationCollection13 = c2222;
                            synchronized (alternateLocationCollection13) {
                                Iterator iter = c2222.iterator();
                                while (iter.hasNext()) {
                                    AlternateLocation al = (AlternateLocation)iter.next();
                                    RemoteFileDesc rfd1 = al.createRemoteFileDesc(rfd.getSize());
                                    this.addDownload(rfd1, false);
                                }
                            }
                        }
                    }
                    return object;
                }
            }
            throw throwable222;
        }
        if (RECORD_STATS && rfd.getFailedCount() > 0) {
            DownloadStat.RETRIED_SUCCESS.incrementStat();
        }
        rfd.resetFailedCount();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.setState(2);
        }
        if (this.stopped) {
            LOG.trace("Stopped in assignAndRequest");
            ManagedDownloader managedDownloader2 = this;
            synchronized (managedDownloader2) {
                this.files.add(rfd);
            }
            return ConnectionStatus.getNoData();
        }
        ManagedDownloader managedDownloader3 = this;
        synchronized (managedDownloader3) {
            if (!this.dloaders.contains(dloader)) {
                this.dloaders.add(dloader);
            }
            this.chatList.addHost(dloader);
            this.browseList.addHost(dloader);
        }
        if (RECORD_STATS) {
            DownloadStat.RESPONSE_OK.incrementStat();
        }
        return ConnectionStatus.getConnected();
    }

    public int getNumberOfAlternateLocations() {
        if (this.validAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            int n = this.validAlts.getAltLocsSize();
            return n;
        }
    }

    public int getNumberOfInvalidAlternateLocations() {
        if (this.invalidAlts == null) {
            return 0;
        }
        Object object = this.altLock;
        synchronized (object) {
            int n = this.invalidAlts.size();
            return n;
        }
    }

    public synchronized int getPossibleHostCount() {
        return this.files == null ? 0 : this.files.size();
    }

    public synchronized int getBusyHostCount() {
        if (this.files == null) {
            return 0;
        }
        int busy = 0;
        int i = 0;
        while (i < this.files.size()) {
            if (((RemoteFileDesc)this.files.get(i)).isBusy()) {
                ++busy;
            }
            ++i;
        }
        return busy;
    }

    public synchronized int getQueuedHostCount() {
        return this.queuedThreads.size();
    }

    private void assignWhite(HTTPDownloader dloader, boolean http11) throws IOException, TryAgainLaterException, FileNotFoundException, NotSharingException, QueuedException, NoSuchRangeException, NoSuchElementException {
        Interval interval = null;
        if (!dloader.getRemoteFileDesc().isPartialSource()) {
            interval = http11 ? this.commonOutFile.leaseWhite(100000) : this.commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet availableRanges = dloader.getRemoteFileDesc().getAvailableRanges();
                interval = http11 ? this.commonOutFile.leaseWhite(availableRanges, 100000) : this.commonOutFile.leaseWhite(availableRanges);
            }
            catch (NoSuchElementException nsee) {
                throw new NoSuchRangeException();
            }
        }
        int low = interval.low;
        int high = interval.high;
        dloader.connectHTTP(this.getOverlapOffset(low), high + 1, true);
        int newLow = dloader.getInitialReadingPoint();
        int newHigh = dloader.getAmountToRead() - 1 + newLow;
        if (newLow > low) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER: Host gave subrange, different low.  Was: " + low + ", is now: " + newLow);
            }
            this.commonOutFile.releaseBlock(new Interval(low, newLow - 1));
        }
        if (newHigh < high) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER: Host gave subrange, different high.  Was: " + high + ", is now: " + newHigh);
            }
            this.commonOutFile.releaseBlock(new Interval(newHigh + 1, high));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER: assigning white " + newLow + "-" + newHigh + " to " + dloader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignGrey(HTTPDownloader dloader, boolean http11) throws NoSuchElementException, IOException, TryAgainLaterException, QueuedException, FileNotFoundException, NotSharingException, NoSuchRangeException {
        if (dloader.getRemoteFileDesc().isPartialSource()) {
            throw new NoSuchRangeException();
        }
        HTTPDownloader biggest = null;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Iterator iter = this.dloaders.iterator();
            while (iter.hasNext()) {
                HTTPDownloader h = (HTTPDownloader)iter.next();
                if (!h.isActive()) continue;
                if (biggest == null) {
                    biggest = h;
                    continue;
                }
                int hLeft = h.getAmountToRead() - h.getAmountRead();
                int bLeft = biggest.getAmountToRead() - biggest.getAmountRead();
                if (hLeft <= 0 || hLeft <= bLeft) continue;
                biggest = h;
            }
        }
        if (biggest == null) {
            throw new NoSuchElementException();
        }
        int amountRead = biggest.getAmountRead();
        int left = biggest.getAmountToRead() - amountRead;
        if (http11 && left < 100000 || !http11 && left < 100000) {
            float bandwidthVictim = -1.0f;
            float bandwidthStealer = -1.0f;
            try {
                bandwidthVictim = biggest.getAverageBandwidth();
                biggest.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                LOG.debug("victim does not have datapoints", ide);
                bandwidthVictim = -1.0f;
            }
            try {
                bandwidthStealer = dloader.getAverageBandwidth();
                dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                LOG.debug("stealer does not have datapoints", ide);
                bandwidthStealer = -1.0f;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER: " + dloader + " attempting to steal from " + biggest + ", stealer speed [" + bandwidthStealer + "], victim speed [ " + bandwidthVictim + "]");
            }
            if (!(bandwidthVictim != -1.0f && bandwidthVictim < MIN_ACCEPTABLE_SPEED) && (!(bandwidthStealer > MIN_ACCEPTABLE_SPEED) || !(bandwidthStealer > bandwidthVictim))) throw new NoSuchElementException();
            int start = biggest.getInitialReadingPoint() + amountRead;
            int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
            if (stop <= start) {
                throw new NoSuchElementException();
            }
            dloader.connectHTTP(this.getOverlapOffset(start), stop, false);
            int newLow = dloader.getInitialReadingPoint();
            int newHigh = dloader.getAmountToRead() + newLow;
            if (newLow > start || newHigh < stop) {
                if (!LOG.isDebugEnabled()) throw new IOException("bad stealer.");
                LOG.debug("WORKER: not stealing because stealer gave a subrange.  Expected low: " + start + ", high: " + stop + ".  Was low: " + newLow + ", high: " + newHigh);
                throw new IOException("bad stealer.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER: picking stolen grey " + start + "-" + stop + " from " + biggest + " to " + dloader);
            }
            biggest.stopAt(start);
            biggest.stop();
            return;
        }
        int start = http11 ? biggest.getInitialReadingPoint() + biggest.getAmountToRead() - 100000 + 1 : biggest.getInitialReadingPoint() + amountRead + left / 2;
        int stop = biggest.getInitialReadingPoint() + biggest.getAmountToRead();
        if (stop <= start) {
            throw new NoSuchElementException();
        }
        dloader.connectHTTP(this.getOverlapOffset(start), stop, true);
        int newLow = dloader.getInitialReadingPoint();
        int newHigh = dloader.getAmountToRead() + newLow;
        if (newHigh < stop) {
            if (!LOG.isDebugEnabled()) throw new IOException("bad stealer");
            LOG.debug("WORKER: not stealing because stealer gave a lower high.  Expected high: " + stop + ".  Was high: " + newHigh);
            throw new IOException("bad stealer");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER: assigning split grey " + newLow + "-" + newHigh + " from " + biggest + " to " + dloader);
        }
        if (newLow > start) {
            start = newLow;
        }
        biggest.stopAt(start);
    }

    private int getOverlapOffset(int i) {
        return Math.max(0, i - 10);
    }

    private Interval addOverlap(Interval in) {
        if (in.low + 10 < in.high) {
            return new Interval(in.low + 10, in.high);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDownload(HTTPDownloader downloader, boolean http11) {
        boolean problem;
        block33: {
            ManagedDownloader managedDownloader;
            if (LOG.isTraceEnabled()) {
                LOG.trace("WORKER: about to start downloading " + downloader);
            }
            problem = false;
            RemoteFileDesc rfd = downloader.getRemoteFileDesc();
            try {
                block31: {
                    try {
                        downloader.doDownload(this.commonOutFile);
                        rfd.resetFailedCount();
                        if (!RECORD_STATS) break block31;
                        if (http11) {
                            DownloadStat.SUCCESFULL_HTTP11.incrementStat();
                        } else {
                            DownloadStat.SUCCESFULL_HTTP10.incrementStat();
                        }
                    }
                    catch (IOException e) {
                        if (RECORD_STATS) {
                            if (http11) {
                                DownloadStat.FAILED_HTTP11.incrementStat();
                            } else {
                                DownloadStat.FAILED_HTTP10.incrementStat();
                            }
                        }
                        problem = true;
                        this.chatList.removeHost(downloader);
                        this.browseList.removeHost(downloader);
                        Object var7_6 = null;
                        int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("    WORKER: terminating from " + downloader + " at " + stop + " error? " + problem);
                        }
                        ManagedDownloader managedDownloader3 = this;
                        synchronized (managedDownloader3) {
                            if (problem) {
                                downloader.stop();
                                rfd.incrementFailedCount();
                                if (rfd.getFailedCount() < 2) {
                                    rfd.setRetryAfter(60);
                                    this.files.add(rfd);
                                } else {
                                    this.informMesh(rfd, false);
                                }
                            } else {
                                this.informMesh(rfd, true);
                                if (!http11) {
                                    this.files.add(rfd);
                                }
                            }
                            break block33;
                        }
                    }
                }
                Object var7_5 = null;
                int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("    WORKER: terminating from " + downloader + " at " + stop + " error? " + problem);
                }
                managedDownloader = this;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                int stop = downloader.getInitialReadingPoint() + downloader.getAmountRead();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("    WORKER: terminating from " + downloader + " at " + stop + " error? " + problem);
                }
                ManagedDownloader managedDownloader2 = this;
                synchronized (managedDownloader2) {
                    if (problem) {
                        downloader.stop();
                        rfd.incrementFailedCount();
                        if (rfd.getFailedCount() < 2) {
                            rfd.setRetryAfter(60);
                            this.files.add(rfd);
                        } else {
                            this.informMesh(rfd, false);
                        }
                    } else {
                        this.informMesh(rfd, true);
                        if (http11) throw throwable;
                        this.files.add(rfd);
                    }
                    throw throwable;
                }
            }
            synchronized (managedDownloader) {
                if (problem) {
                    downloader.stop();
                    rfd.incrementFailedCount();
                    if (rfd.getFailedCount() < 2) {
                        rfd.setRetryAfter(60);
                        this.files.add(rfd);
                    } else {
                        this.informMesh(rfd, false);
                    }
                } else {
                    this.informMesh(rfd, true);
                    if (!http11) {
                        this.files.add(rfd);
                    }
                }
            }
        }
        if (problem) return false;
        return true;
    }

    private synchronized void releaseRanges(HTTPDownloader dloader) {
        int low = dloader.getInitialReadingPoint();
        int high = dloader.getInitialReadingPoint() + dloader.getAmountToRead() - 1;
        if (high - low > 0) {
            this.commonOutFile.releaseBlock(new Interval(low, high));
        }
    }

    private synchronized int getNumAllowedDownloads() {
        int downloads = this.threads.size();
        return this.getSwarmCapacity() - downloads;
    }

    private int getSwarmCapacity() {
        int capacity = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (capacity <= 56) {
            return 2;
        }
        if (capacity <= 1000) {
            return 6;
        }
        return 8;
    }

    private synchronized RemoteFileDesc removeBest(List filesLeft) {
        Iterator iter = filesLeft.iterator();
        RemoteFileDesc ret = (RemoteFileDesc)iter.next();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
            if (ret.isBusy()) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() != null && ret.getSHA1Urn() == null) {
                ret = rfd;
                continue;
            }
            if (rfd.getSHA1Urn() == null != (ret.getSHA1Urn() == null)) continue;
            if (rfd.getQuality() > ret.getQuality()) {
                ret = rfd;
                continue;
            }
            if (rfd.getQuality() != ret.getQuality() || rfd.getSpeed() <= ret.getSpeed()) continue;
            ret = rfd;
        }
        filesLeft.remove(ret);
        return ret;
    }

    private static boolean needsPush(RemoteFileDesc rfd) {
        if (rfd.isReplyToMulticast()) {
            return true;
        }
        if (rfd.isPrivate()) {
            return !(rfd instanceof URLRemoteFileDesc);
        }
        return !NetworkUtils.isValidPort(rfd.getPort());
    }

    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            RouterService.getFileManager().removeFileIfShared(this.incompleteFile);
            if (this.corruptState == 0 && this.hashTree == null) {
                this.corruptState = 1;
                this.callback.promptAboutCorruptDownload(this);
            }
        }
    }

    public void discardCorruptDownload(boolean delete) {
        if (this.hashTree != null) {
            this.corruptState = 3;
        } else if (delete) {
            this.corruptState = 2;
            this.stop();
        } else {
            this.corruptState = 3;
        }
        Object object = this.corruptStateLock;
        synchronized (object) {
            this.corruptStateLock.notify();
        }
    }

    private synchronized List getXMLDocuments() {
        ArrayList allDocs = new ArrayList();
        int i = 0;
        while (i < this.allFiles.length) {
            LimeXMLDocument doc;
            if (this.allFiles[i] != null && (doc = this.allFiles[i].getXMLDoc()) != null) {
                allDocs.add(doc);
            }
            ++i;
        }
        return allDocs;
    }

    private void cleanup() {
        this.miniRFDToLock.clear();
        this.threadLockToSocket.clear();
        this.files = null;
        this.validAlts = null;
    }

    private void setState(int newState) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = Long.MAX_VALUE;
        }
    }

    private void setState(int newState, long time) {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this.state = newState;
            this.stateTime = System.currentTimeMillis() + time;
        }
    }

    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(remaining, 0L) / 1000;
            }
            case 8: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.max(remaining, 0L) / 1000;
            }
        }
        return Integer.MAX_VALUE;
    }

    public synchronized String getFileName() {
        String ret = null;
        if (this.allFiles.length > 0) {
            ret = this.allFiles[0].getFileName();
        } else {
            Assert.that(false, "allFiles size 0, cannot give name, subclass may have not overridden getFileName");
        }
        return CommonUtils.convertFileName(ret);
    }

    protected synchronized boolean hasRFD() {
        return this.allFiles != null && this.allFiles.length > 0;
    }

    public synchronized int getContentLength() {
        if (this.dloaders.size() == 0) {
            if (this.allFiles.length > 0) {
                return this.allFiles[0].getSize();
            }
            return -1;
        }
        return ((HTTPDownloader)this.dloaders.get(0)).getRemoteFileDesc().getSize();
    }

    public synchronized int getAmountRead() {
        if (this.state == 9) {
            return this.corruptFileBytes;
        }
        if (this.state == 11) {
            if (this.incompleteFile == null) {
                return 0;
            }
            return URN.getHashingProgress(this.incompleteFile);
        }
        if (this.commonOutFile == null) {
            return 0;
        }
        return this.commonOutFile.getBlockSize();
    }

    public String getAddress() {
        return this.currentLocation;
    }

    public synchronized Iterator getHosts() {
        return this.getHosts(false);
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized String getQueuePosition() {
        if (this.getState() != 10) {
            return UNKNOWN_FILENAME;
        }
        return this.queuePosition;
    }

    public synchronized int getNumDownloaders() {
        return this.dloaders.size() + this.queuedThreads.size();
    }

    private final Iterator getHosts(boolean chattableOnly) {
        LinkedList buf = new LinkedList();
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            HTTPDownloader dloader = (HTTPDownloader)iter.next();
            if (!(chattableOnly ? dloader.chatEnabled() : true)) continue;
            buf.add(new Endpoint(dloader.getInetAddress().getHostAddress(), dloader.getPort()));
        }
        return buf.iterator();
    }

    public synchronized String getVendor() {
        if (this.dloaders.size() > 0) {
            HTTPDownloader dl = (HTTPDownloader)this.dloaders.get(0);
            return dl.getVendor();
        }
        if (this.getState() == 10) {
            return this.queuedVendor;
        }
        return UNKNOWN_FILENAME;
    }

    public synchronized int getRetriesWaiting() {
        return this.retriesWaiting;
    }

    public synchronized void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            c = true;
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            dloader.measureBandwidth();
            currentTotal += dloader.getAverageBandwidth();
        }
        if (c) {
            this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
        }
    }

    public synchronized float getMeasuredBandwidth() {
        float retVal = 0.0f;
        Iterator iter = this.dloaders.iterator();
        while (iter.hasNext()) {
            BandwidthTracker dloader = (BandwidthTracker)iter.next();
            float curr = 0.0f;
            try {
                curr = dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            retVal += curr;
        }
        return retVal;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    private boolean checkHosts() {
        byte[] b = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String s = this.callback.getHostValue(new String(b));
        if (s == null) {
            return false;
        }
        return (s = s.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RequeryLock {
        private volatile boolean shouldWait = true;
        private volatile boolean newResults = false;

        private RequeryLock() {
        }

        public synchronized void releaseDueToNewResults() {
            this.shouldWait = false;
            this.newResults = true;
            this.notifyAll();
        }

        public synchronized void releaseDueToRequery() {
            this.notifyAll();
        }

        private synchronized boolean getAndClearNewResult() {
            boolean retVal = this.newResults;
            this.newResults = false;
            return retVal;
        }

        public synchronized boolean lock(long waitTime) throws InterruptedException {
            try {
                if (this.shouldWait) {
                    this.wait(waitTime);
                }
            }
            catch (InterruptedException ie) {
                this.shouldWait = true;
                throw ie;
            }
            this.shouldWait = true;
            return this.getAndClearNewResult();
        }
    }
}

