/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dime;

import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.util.DataUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.UnsupportedOperationException;
import java.io.IOException;
import java.io.InputStream;

public class DIMEParser
implements Iterator {
    private final InputStream IN;
    private boolean _lastRead = false;
    private boolean _firstRead = false;

    public DIMEParser(InputStream in) {
        this.IN = in;
    }

    public Object next() {
        try {
            return this.nextRecord();
        }
        catch (IOException ioe) {
            throw new NoSuchElementException(ioe.getMessage());
        }
    }

    public DIMERecord nextRecord() throws IOException {
        return this.getNext();
    }

    public List getRecords() throws IOException {
        if (this._lastRead) {
            return DataUtils.EMPTY_LIST;
        }
        LinkedList records = new LinkedList();
        while (!this._lastRead) {
            records.add(this.getNext());
        }
        return records;
    }

    public boolean hasNext() {
        return !this._lastRead;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private DIMERecord getNext() throws IOException {
        if (this._lastRead) {
            throw new IOException("already read last message.");
        }
        DIMERecord next = DIMERecord.createFromStream(this.IN);
        if (next.isLastRecord()) {
            this._lastRead = true;
        }
        if (!this._firstRead && !next.isFirstRecord()) {
            throw new IOException("middle of stream.");
        }
        if (this._firstRead && next.isFirstRecord()) {
            throw new IOException("two first records.");
        }
        this._firstRead = true;
        return next;
    }
}

