/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.BucketQueue;

public class PriorityMessageQueue
extends MessageQueue {
    private static final int PRIORITIES = 8;
    private BucketQueue _queue;

    public PriorityMessageQueue(int cycle, int timeout, int capacity) {
        super(cycle, timeout);
        this._queue = new BucketQueue(8, capacity);
    }

    protected Message addInternal(Message m) {
        return (Message)this._queue.insert(m, PriorityMessageQueue.priority(m));
    }

    private static final int priority(Message m) {
        if (m instanceof QueryReply) {
            return PriorityMessageQueue.priority((QueryReply)m);
        }
        if (m instanceof PingReply) {
            return PriorityMessageQueue.bound(m.getHops());
        }
        return PriorityMessageQueue.bound(7 - m.getHops());
    }

    private static final int priority(QueryReply m) {
        int volume = m.getPriority();
        if (volume == 0) {
            return 7;
        }
        if (volume < 1000) {
            return 6;
        }
        if (volume < 5000) {
            return 5;
        }
        if (volume < 10000) {
            return 4;
        }
        if (volume < 20000) {
            return 3;
        }
        if (volume < 30000) {
            return 2;
        }
        if (volume < 40000) {
            return 1;
        }
        return 0;
    }

    private static final int bound(int priority) {
        if (priority < 0) {
            return 0;
        }
        if (priority >= 8) {
            return 7;
        }
        return priority;
    }

    protected Message removeNextInternal() {
        if (this._queue.isEmpty()) {
            return null;
        }
        return (Message)this._queue.extractMax();
    }

    public int size() {
        return this._queue.size();
    }
}

