/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalControl {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$browser$ExternalControl == null ? (class$com$limegroup$gnutella$browser$ExternalControl = ExternalControl.class$("com.limegroup.gnutella.browser.ExternalControl")) : class$com$limegroup$gnutella$browser$ExternalControl);
    private static final String LOCALHOST = "127.0.0.1";
    private static final String HTTP = "http://";
    private static boolean initialized = false;
    private static String enqueuedRequest = null;
    static /* synthetic */ Class class$com$limegroup$gnutella$browser$ExternalControl;

    public static String preprocessArgs(String[] args) {
        LOG.trace("enter proprocessArgs");
        String arg = new String();
        int i = 0;
        while (i < args.length) {
            arg = arg + args[i];
            ++i;
        }
        return arg;
    }

    public static void checkForActiveLimeWire() {
        if (ExternalControl.testForLimeWire(null)) {
            System.exit(0);
        }
    }

    public static void checkForActiveLimeWire(String arg) {
        if (CommonUtils.isWindows() && ExternalControl.testForLimeWire(arg)) {
            System.exit(0);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void enqueueMagnetRequest(String arg) {
        LOG.trace("enter enqueueMagnetRequest");
        enqueuedRequest = arg;
    }

    public static void runQueuedMagnetRequest() {
        initialized = true;
        if (enqueuedRequest != null) {
            String request = enqueuedRequest;
            enqueuedRequest = null;
            ExternalControl.handleMagnetRequest(request);
        }
    }

    public static void handleMagnetRequest(String arg) {
        LOG.trace("enter handleMagnetRequest");
        ActivityCallback callback = RouterService.getCallback();
        if (RouterService.getNumInitializedConnections() <= 0) {
            RouterService.connect();
        }
        callback.restoreApplication();
        callback.showDownloads();
        MagnetOptions[] options = ExternalControl.parseMagnet(arg);
        if (options == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid magnet, ignoring: " + arg);
            }
            return;
        }
        ExternalControl.downloadMagnet(options);
    }

    public static void downloadMagnet(MagnetOptions[] options) {
        if (LOG.isDebugEnabled()) {
            int i = 0;
            while (i < options.length) {
                LOG.debug("Kicking off downloader for option " + i + " " + options[i]);
                ++i;
            }
        }
        boolean xtSHA1 = false;
        boolean xsSHA1 = false;
        boolean asSHA1 = false;
        int i = 0;
        while (i < options.length) {
            URN urn;
            MagnetOptions curOpt;
            block25: {
                curOpt = options[i];
                urn = null;
                if (curOpt.xt != null && curOpt.xt.length() > 0) {
                    try {
                        urn = URN.createSHA1Urn(curOpt.xt);
                        xtSHA1 = true;
                    }
                    catch (IOException e) {
                        if (curOpt.xs == null || curOpt.xs.length() <= 0) break block25;
                        try {
                            urn = URN.createSHA1Urn(curOpt.xs);
                            xsSHA1 = true;
                        }
                        catch (IOException e2) {
                            if (curOpt.as == null || curOpt.as.length() <= 0) break block25;
                            try {
                                urn = URN.createSHA1Urn(curOpt.as);
                                asSHA1 = true;
                            }
                            catch (IOException e3) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            String[] defaultURLs = null;
            ArrayList urls = new ArrayList();
            String errorMsg = null;
            if (!xtSHA1 && curOpt.xt != null && curOpt.xt.startsWith(HTTP)) {
                urls.add(curOpt.xt);
            }
            if (!xsSHA1 && curOpt.xs != null && curOpt.xs.startsWith(HTTP)) {
                urls.add(curOpt.xs);
            }
            if (!asSHA1 && curOpt.as != null && curOpt.as.startsWith(HTTP)) {
                urls.add(curOpt.as);
            }
            if (urls.size() > 0) {
                Iterator it = urls.iterator();
                while (it.hasNext()) {
                    try {
                        String nextURL = (String)it.next();
                        new URI(nextURL.toCharArray());
                    }
                    catch (URIException e) {
                        LOG.warn("Invalid URI in magnet", e);
                        errorMsg = e.getMessage();
                        it.remove();
                    }
                }
                defaultURLs = (String[])urls.toArray(new String[urls.size()]);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing magnet with params:\nurn [" + urn + "]\n" + "options [" + curOpt + "]");
            }
            if (urls.size() <= 0 && urn == null && (curOpt.kt == null || "".equals(curOpt.kt))) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid magnet. urls.size == " + urls.size() + "curOpt.kt == " + curOpt.kt);
                }
                errorMsg = errorMsg != null ? curOpt.toString() + " (" + errorMsg + ")" : curOpt.toString();
                MessageService.showError("ERROR_BAD_MAGNET_LINK", errorMsg);
                return;
            }
            if (errorMsg != null) {
                MessageService.showError("ERROR_INVALID_URLS_IN_MAGNET");
            }
            try {
                RouterService.download(urn, curOpt.kt, curOpt.dn, defaultURLs, false);
            }
            catch (AlreadyDownloadingException a) {
                MessageService.showError("ERROR_ALREADY_DOWNLOADING", a.getFilename());
            }
            catch (IllegalArgumentException il) {
                ErrorService.error(il);
            }
            catch (FileExistsException fex) {
                MessageService.showError("ERROR_ALREADY_EXISTS", fex.getFileName());
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fireMagnet(Socket socket) {
        block13: {
            block12: {
                ExternalControl.LOG.trace("enter fireMagnet");
                Thread.currentThread().setName("IncomingMagnetThread");
                try {
                    try {
                        if (!"127.0.0.1".equals(socket.getInetAddress().getHostAddress())) {
                            if (ExternalControl.LOG.isWarnEnabled()) {
                                ExternalControl.LOG.warn("Invalid magnet request from: " + socket.getInetAddress().getHostAddress());
                            }
                            var7_1 = null;
                            break block12;
                        }
                        socket.setSoTimeout(8000);
                        br = new ByteReader(socket.getInputStream());
                        line = br.readLine();
                        socket.setSoTimeout(0);
                        out = new BufferedOutputStream(socket.getOutputStream());
                        s = CommonUtils.getUserName() + "\r\n";
                        bytes = s.getBytes();
                        out.write(bytes);
                        out.flush();
                        ExternalControl.handleMagnetRequest(line);
                        break block13;
                    }
                    catch (IOException e) {
                        ExternalControl.LOG.warn("Exception while responding to magnet request", e);
                        var7_3 = null;
                        try {
                            socket.close();
                            return;
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                }
                catch (Throwable var6_15) {
                    var7_4 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 200->207)] { 
lbl35:
                    // 1 sources

                    socket.close();
                    throw var6_15;
lbl37:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var6_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 200->207)] { 
lbl42:
            // 1 sources

            socket.close();
            return;
lbl44:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var7_2 = null;
        try {}
        catch (IOException e) {}
        socket.close();
        return;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean testForLimeWire(String arg) {
        socket = null;
        port = ConnectionSettings.PORT.getValue();
        if (!NetworkUtils.isValidPort(port)) {
            ConnectionSettings.PORT.revertToDefault();
            port = ConnectionSettings.PORT.getValue();
        }
        try {
            try {
                socket = Sockets.connect("127.0.0.1", port, 500);
                istream = socket.getInputStream();
                socket.setSoTimeout(500);
                byteReader = new ByteReader(istream);
                os = socket.getOutputStream();
                osw = new OutputStreamWriter(os);
                out = new BufferedWriter(osw);
                out.write("MAGNET " + arg + " ");
                out.write("\r\n");
                out.flush();
                str = byteReader.readLine();
                var9_10 = str != null && str.startsWith(CommonUtils.getUserName()) != false;
                var11_11 = null;
                if (socket == null) return var9_10;
            }
            catch (IOException e2) {
                var11_12 = null;
                if (socket == null) return false;
                try {
                    socket.close();
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        catch (Throwable var10_17) {
            var11_13 = null;
            if (socket == null) throw var10_17;
            ** try [egrp 2[TRYBLOCK] [2 : 187->194)] { 
lbl38:
            // 1 sources

            socket.close();
            throw var10_17;
lbl40:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var10_17;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 187->194)] { 
lbl45:
        // 1 sources

        socket.close();
        return var9_10;
lbl47:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var9_10;
    }

    public static MagnetOptions[] parseMagnet(String arg) {
        LOG.trace("enter parseMagnet");
        Object[] ret = null;
        HashMap options = new HashMap();
        if (arg.startsWith("'")) {
            arg = arg.substring(1);
        }
        if (arg.endsWith("'")) {
            arg = arg.substring(0, arg.length() - 1);
        }
        if (!arg.startsWith("magnet:?")) {
            return ret;
        }
        arg = arg.substring(8);
        StringTokenizer st = new StringTokenizer(arg, "&");
        while (st.hasMoreTokens()) {
            Integer iIndex;
            MagnetOptions curOptions;
            int index;
            String cmdstr;
            String keystr;
            block19: {
                keystr = st.nextToken();
                int start = (keystr = keystr.trim()).indexOf("=") + 1;
                if (start == 0) continue;
                cmdstr = keystr.substring(start);
                keystr = keystr.substring(0, start - 1);
                try {
                    cmdstr = URLDecoder.decode(cmdstr);
                }
                catch (IOException e1) {
                    continue;
                }
                int periodLoc = keystr.indexOf(".");
                if (periodLoc > 0) {
                    try {
                        index = Integer.parseInt(keystr.substring(periodLoc + 1));
                        break block19;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                index = 0;
            }
            if ((curOptions = (MagnetOptions)options.get(iIndex = new Integer(index))) == null) {
                curOptions = new MagnetOptions();
            }
            if (keystr.startsWith("xt")) {
                curOptions.xt = cmdstr;
            } else if (keystr.startsWith("dn")) {
                curOptions.dn = cmdstr;
            } else if (keystr.startsWith("kt")) {
                curOptions.kt = cmdstr;
            } else if (keystr.startsWith("xs")) {
                curOptions.xs = cmdstr;
            } else if (keystr.startsWith("as")) {
                curOptions.as = cmdstr;
            }
            options.put(iIndex, curOptions);
        }
        ret = new MagnetOptions[options.size()];
        ret = (MagnetOptions[])options.values().toArray(ret);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

