/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;

public class UDPHostRanker {
    private static final MessageRouter ROUTER = RouterService.getMessageRouter();

    public static void rank(final Collection hosts, final MessageListener listener) {
        if (hosts == null) {
            throw new NullPointerException("null hosts not allowed");
        }
        ManagedThread ranker = new ManagedThread(new Runnable(){

            public void run() {
                new UDPHostRanker(hosts, listener);
            }
        }, "UDPHostRanker");
        ranker.setDaemon(true);
        ranker.start();
    }

    private UDPHostRanker(Collection hosts, MessageListener listener) {
        int waits = 0;
        while (!UDPService.instance().isListening() && waits < 10) {
            UDPHostRanker uDPHostRanker = this;
            synchronized (uDPHostRanker) {
                try {
                    this.wait(600L);
                }
                catch (InterruptedException e) {
                    ErrorService.error(e);
                }
            }
            ++waits;
        }
        PingRequest ping = new PingRequest(1);
        final GUID pingGUID = new GUID(ping.getGUID());
        if (listener != null) {
            ROUTER.registerMessageListener(pingGUID, listener);
        }
        int MAX_SENDS = 15;
        Iterator iter = hosts.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i == 15) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                i = 0;
            }
            IpPort host = (IpPort)iter.next();
            UDPService.instance().send(ping, host);
            ++i;
        }
        if (listener != null) {
            Runnable udpPingPurger = new Runnable(){

                public void run() {
                    ROUTER.unregisterMessageListener(pingGUID);
                }
            };
            RouterService.schedule(udpPingPurger, 20000L, 0L);
        }
    }
}

