/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PongCacher;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.statistics.RoutedQueryStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class StandardMessageRouter
extends MessageRouter {
    private final boolean RECORD_STATS = !CommonUtils.isJava118();

    protected void respondToPingRequest(PingRequest ping, ReplyHandler handler) {
        byte ttl;
        byte hops = ping.getHops();
        if (hops + (ttl = ping.getTTL()) > 2 && !MessageRouter._manager.allowAnyConnection()) {
            return;
        }
        if (NetworkUtils.isValidAddress(RouterService.getAddress()) && NetworkUtils.isValidPort(RouterService.getPort())) {
            if (hops == 1 && ttl == 1) {
                this.handleCrawlerPing(ping, handler);
                return;
            }
            if (ping.isHeartbeat()) {
                this.sendPingReply(PingReply.create(ping.getGUID(), (byte)1), handler);
                return;
            }
            int newTTL = hops + 1;
            if (hops + ttl <= 2) {
                newTTL = 1;
            }
            if (RouterService.getConnectionManager().hasFreeSlots() || Statistics.instance().calculateDailyUptime() > 1800) {
                PingReply pr = PingReply.create(ping.getGUID(), (byte)newTTL);
                this.sendPingReply(pr, handler);
            }
        }
        List pongs = PongCacher.instance().getBestPongs(ping.getLocale());
        Iterator iter = pongs.iterator();
        byte[] guid = ping.getGUID();
        InetAddress pingerIP = handler.getInetAddress();
        while (iter.hasNext()) {
            PingReply pr = (PingReply)iter.next();
            if (pr.getInetAddress().equals(pingerIP)) continue;
            this.sendPingReply(pr.mutateGUID(guid), handler);
        }
    }

    protected void respondToUDPPingRequest(PingRequest request, DatagramPacket datagram, ReplyHandler handler) {
        this.sendPingReply(PingReply.create(request.getGUID(), (byte)1), handler);
    }

    private void handleCrawlerPing(PingRequest m, ReplyHandler handler) {
        List leafConnections = MessageRouter._manager.getInitializedClientConnections();
        Iterator iterator = leafConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iterator.next();
            PingReply pr = PingReply.createExternal(m.getGUID(), (byte)2, connection.getPort(), connection.getInetAddress().getAddress(), false);
            pr.hop();
            this.sendPingReply(pr, handler);
        }
    }

    protected void handlePingReply(PingReply pingReply, ReplyHandler receivingConnection) {
        if (receivingConnection instanceof ManagedConnection) {
            ManagedConnection mc = (ManagedConnection)receivingConnection;
            mc.updateHorizonStats(pingReply);
        }
        super.handlePingReply(pingReply, receivingConnection);
    }

    protected boolean respondToQueryRequest(QueryRequest queryRequest, byte[] clientGUID, ReplyHandler handler) {
        if (queryRequest.getCapabilitySelector() > 0 && queryRequest.getCapabilitySelector() > 1) {
            return false;
        }
        if (RouterService.getUploadManager().isBusy()) {
            return false;
        }
        if (!NetworkUtils.isValidPort(RouterService.getPort()) || !NetworkUtils.isValidAddress(RouterService.getAddress())) {
            return false;
        }
        Response[] responses = RouterService.getFileManager().query(queryRequest);
        if (RouterService.isShieldedLeaf() && queryRequest.isTCP() && this.RECORD_STATS) {
            if (responses != null && responses.length > 0) {
                RoutedQueryStat.LEAF_HIT.incrementStat();
            } else {
                RoutedQueryStat.LEAF_FALSE_POSITIVE.incrementStat();
            }
        }
        return this.sendResponses(responses, queryRequest, handler);
    }

    public boolean sendResponses(Response[] responses, QueryRequest query, ReplyHandler handler) {
        if (responses == null || responses.length < 1) {
            return false;
        }
        if (query.desiresOutOfBandReplies() && !this.isConnectedTo(query, handler) && RouterService.isGUESSCapable() && RouterService.acceptedIncomingConnection() && !RouterService.getUploadManager().isBusy()) {
            if (this.bufferResponsesForLaterDelivery(query, responses)) {
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByName(query.getReplyAddress());
                }
                catch (UnknownHostException uhe) {
                    return false;
                }
                int port = query.getReplyPort();
                int resultCount = responses.length > 255 ? 255 : responses.length;
                ReplyNumberVendorMessage vm = new ReplyNumberVendorMessage(new GUID(query.getGUID()), resultCount);
                UDPService.instance().send(vm, addr, port);
                return true;
            }
            return false;
        }
        Iterator iterator = this.responsesToQueryReplies(responses, query);
        try {
            while (iterator.hasNext()) {
                QueryReply queryReply = (QueryReply)iterator.next();
                this.sendQueryReply(queryReply);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    private final boolean isConnectedTo(QueryRequest query, ReplyHandler handler) {
        return query.matchesReplyAddress(handler.getInetAddress().getAddress());
    }

    protected List createQueryReply(byte[] guid, byte ttl, long speed, Response[] res, byte[] clientGUID, boolean busy, boolean uploaded, boolean measuredSpeed, boolean isFromMcast) {
        Set proxies;
        ArrayList queryReplies = new ArrayList();
        QueryReply queryReply = null;
        int port = isFromMcast ? RouterService.getNonForcedPort() : RouterService.getPort();
        byte[] ip = isFromMcast ? RouterService.getNonForcedAddress() : RouterService.getAddress();
        String xmlCollectionString = LimeXMLDocumentHelper.getAggregateString(res);
        if (xmlCollectionString == null) {
            xmlCollectionString = "";
        }
        byte[] xmlBytes = null;
        try {
            xmlBytes = xmlCollectionString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            ErrorService.error(ueex, "encountered UnsupportedEncodingException in creation of QueryReply : xmlCollectionString : " + xmlCollectionString);
        }
        boolean notIncoming = !RouterService.acceptedIncomingConnection();
        Set set = proxies = notIncoming ? MessageRouter._manager.getPushProxies() : null;
        if (xmlBytes.length > 32768) {
            LinkedList splitResps = new LinkedList();
            this.splitAndAddResponses(splitResps, res);
            while (!splitResps.isEmpty()) {
                Response[] currResps = (Response[])splitResps.remove(0);
                String currXML = LimeXMLDocumentHelper.getAggregateString(currResps);
                byte[] currXMLBytes = null;
                try {
                    currXMLBytes = currXML.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException ueex) {
                    ErrorService.error(ueex, "encountered UnsupportedEncodingException : currXML " + currXML);
                    currXMLBytes = "".getBytes();
                }
                if (currXMLBytes.length > 32768 && currResps.length > 1) {
                    this.splitAndAddResponses(splitResps, currResps);
                    continue;
                }
                byte[] xmlCompressed = null;
                xmlCompressed = currXML != null && !currXML.equals("") ? LimeXMLUtils.compress(currXMLBytes) : DataUtils.EMPTY_BYTE_ARRAY;
                queryReply = new QueryReply(guid, ttl, port, ip, speed, currResps, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, proxies);
                queryReplies.add(queryReply);
            }
        } else {
            byte[] xmlCompressed = null;
            xmlCompressed = xmlCollectionString != null && !xmlCollectionString.equals("") ? LimeXMLUtils.compress(xmlBytes) : DataUtils.EMPTY_BYTE_ARRAY;
            queryReply = new QueryReply(guid, ttl, port, ip, speed, res, this._clientGUID, xmlCompressed, notIncoming, busy, uploaded, measuredSpeed, ChatSettings.CHAT_ENABLED.getValue(), isFromMcast, proxies);
            queryReplies.add(queryReply);
        }
        return queryReplies;
    }

    private Response[][] splitResponses(Response[] in) {
        int middle = in.length / 2;
        Response[][] retResps = new Response[][]{new Response[middle], new Response[in.length - middle]};
        int i = 0;
        while (i < middle) {
            retResps[0][i] = in[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < in.length - middle) {
            retResps[1][i2] = in[i2 + middle];
            ++i2;
        }
        return retResps;
    }

    private void splitAndAddResponses(List addTo, Response[] toSplit) {
        Response[][] splits = this.splitResponses(toSplit);
        addTo.add(splits[0]);
        addTo.add(splits[1]);
    }
}

