/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;

public final class PushManager {
    private static final int PUSH_INVALIDATE_TIME = 300;
    private static final int CONNECT_TIMEOUT = 10000;
    private List _failedPushes = new LinkedList();
    private List _attemptingPushes = new LinkedList();

    public void acceptPushUpload(final String file, final String host, final int port, final int index, final String guid, final boolean forceAllow) {
        if (file == null) {
            throw new NullPointerException("null file");
        }
        if (host == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        FileManager fm = RouterService.getFileManager();
        FileDesc fd = null;
        if (fm.isValidIndex(index)) {
            fd = fm.get(index);
        }
        if (fd == null) {
            return;
        }
        if (!file.equals(fd.getName())) {
            return;
        }
        PushManager pushManager = this;
        synchronized (pushManager) {
            this.clearFailedPushes();
            if (!(forceAllow || this.testAttemptingPush(host, index) && this.testFailedPush(host, index))) {
                return;
            }
            this.insertAttemptingPush(host, index);
        }
        ManagedThread runner = new ManagedThread("PushUploadThread"){

            /*
             * Loose catch block
             */
            public void managedRun() {
                Socket s;
                block39: {
                    s = null;
                    s = Sockets.connect(host, port, 10000);
                    OutputStream ostream = s.getOutputStream();
                    String giv = "GIV " + index + ":" + guid + "/" + file + "\n\n";
                    ostream.write(giv.getBytes());
                    ostream.flush();
                    String word = IOUtils.readWord(s.getInputStream(), 4);
                    if (word.equals("GET")) {
                        UploadStat.PUSHED_GET.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, s, forceAllow);
                    } else if (word.equals("HEAD")) {
                        UploadStat.PUSHED_HEAD.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, s, forceAllow);
                    } else {
                        UploadStat.PUSHED_UNKNOWN.incrementStat();
                        throw new IOException();
                    }
                    Object var7_8 = null;
                    if (s == null) break block39;
                    try {
                        s.getInputStream().close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    try {
                        s.getOutputStream().close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    try {
                        s.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                1 var8_12 = this;
                synchronized (var8_12) {
                    PushManager.this.removeAttemptingPush(host, index);
                }
                {
                    catch (IOException ioe) {
                        UploadStat.PUSH_FAILED.incrementStat();
                        1 giv = this;
                        synchronized (giv) {
                            PushManager.this.insertFailedPush(host, index);
                        }
                        Object var7_9 = null;
                        if (s != null) {
                            try {
                                s.getInputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.getOutputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        1 var8_13 = this;
                        synchronized (var8_13) {
                            PushManager.this.removeAttemptingPush(host, index);
                        }
                    }
                    catch (Throwable e) {
                        ErrorService.error(e);
                        Object var7_10 = null;
                        if (s != null) {
                            try {
                                s.getInputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.getOutputStream().close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                            try {
                                s.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        1 var8_14 = this;
                        synchronized (var8_14) {
                            PushManager.this.removeAttemptingPush(host, index);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (s != null) {
                        try {
                            s.getInputStream().close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                        try {
                            s.getOutputStream().close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                        try {
                            s.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    1 var8_15 = this;
                    synchronized (var8_15) {
                        PushManager.this.removeAttemptingPush(host, index);
                    }
                    throw throwable;
                }
            }
        };
        runner.start();
    }

    private synchronized void insertFailedPush(String host, int index) {
        this._failedPushes.add(new PushedFile(host, index));
    }

    private synchronized boolean testFailedPush(String host, int index) {
        PushedFile pf = new PushedFile(host, index);
        Iterator iter = this._failedPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pfile = (PushedFile)iter.next();
            if (!pf.equals(pfile)) continue;
            return false;
        }
        return true;
    }

    private synchronized void insertAttemptingPush(String host, int index) {
        this._attemptingPushes.add(new PushedFile(host, index));
    }

    private synchronized boolean testAttemptingPush(String host, int index) {
        PushedFile pf = new PushedFile(host, index);
        Iterator iter = this._attemptingPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pfile = (PushedFile)iter.next();
            if (!pf.equals(pfile)) continue;
            return false;
        }
        return true;
    }

    private synchronized void removeAttemptingPush(String host, int index) {
        PushedFile pf = new PushedFile(host, index);
        Iterator iter = this._attemptingPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pfile = (PushedFile)iter.next();
            if (!pf.equals(pfile)) continue;
            iter.remove();
        }
    }

    private synchronized void clearFailedPushes() {
        Date time = new Date();
        time.setTime(time.getTime() - 300000L);
        Iterator iter = this._failedPushes.iterator();
        while (iter.hasNext()) {
            PushedFile pf = (PushedFile)iter.next();
            if (!pf.before(time)) continue;
            iter.remove();
        }
    }

    private static class PushedFile {
        private final String _host;
        private final int _index;
        private final Date _time;

        public PushedFile(String host, int index) {
            this._host = host;
            this._index = index;
            this._time = new Date();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PushedFile)) {
                return false;
            }
            PushedFile pf = (PushedFile)o;
            return this._index == pf._index && this._host.equals(pf._host);
        }

        public boolean before(Date time) {
            return this._time.before(time);
        }
    }
}

