/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPHostRanker;
import com.limegroup.gnutella.bootstrap.BootstrapServer;
import com.limegroup.gnutella.bootstrap.BootstrapServerManager;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.BucketQueue;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FixedsizePriorityQueue;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Set;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCatcher {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$HostCatcher == null ? (class$com$limegroup$gnutella$HostCatcher = HostCatcher.class$("com.limegroup.gnutella.HostCatcher")) : class$com$limegroup$gnutella$HostCatcher);
    static final int CACHE_SIZE = 20;
    static final int GOOD_SIZE = 1000;
    static final int NORMAL_SIZE = 400;
    static final int PERMANENT_SIZE = 400;
    public static final int CACHE_PRIORITY = 2;
    public static final int GOOD_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 0;
    private final BucketQueue ENDPOINT_QUEUE = new BucketQueue(new int[]{400, 1000, 20});
    private final Set ENDPOINT_SET = new HashSet();
    private final Set FREE_ULTRAPEER_SLOTS_SET = new HashSet();
    private final Set FREE_LEAF_SLOTS_SET = new HashSet();
    private final Map LOCALE_2_SET = new HashMap();
    private static final int NUM_2_KEEP_LOCALE_SET = 100;
    private FixedsizePriorityQueue permanentHosts = new FixedsizePriorityQueue(ExtendedEndpoint.priorityComparator(), 400);
    private Set permanentHostsSet = new HashSet();
    private BootstrapServerManager gWebCache = BootstrapServerManager.instance();
    private final File HOST_FILE;
    private int _failures;
    private final Set EXPIRED_HOSTS = new HashSet();
    private final Set PROBATION_HOSTS = new HashSet();
    private static long PROBATION_RECOVERY_WAIT_TIME = 60000L;
    private static long PROBATION_RECOVERY_TIME = 60000L;
    public static final int PROBATION_HOSTS_SIZE = 500;
    public static final int EXPIRED_HOSTS_SIZE = 500;
    public final GWebCacheFetcher FETCHER = new GWebCacheFetcher();
    private volatile int _catchersWaiting = 0;
    static boolean DEBUG = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$HostCatcher;

    public HostCatcher() {
        this.HOST_FILE = new File(CommonUtils.getUserSettingsDir(), "gnutella.net");
    }

    public void initialize() {
        LOG.trace("START readHostsFile");
        this.readHostsFile();
        LOG.trace("STOP readHostsFile");
        LOG.trace("START sendUDPPings");
        this.sendUDPPings();
        LOG.trace("STOP sendUDPPings");
        LOG.trace("START scheduling");
        Runnable updater = new Runnable(){

            public void run() {
                try {
                    if (RouterService.acceptedIncomingConnection() && RouterService.isSupernode()) {
                        byte[] addr = RouterService.getAddress();
                        int port = RouterService.getPort();
                        if (NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port) && !NetworkUtils.isPrivateAddress(addr)) {
                            Endpoint e = new Endpoint(addr, port);
                            HostCatcher.this.gWebCache.sendUpdatesAsync(e);
                        }
                    }
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        RouterService.schedule(updater, BootstrapServerManager.UPDATE_DELAY_MSEC, BootstrapServerManager.UPDATE_DELAY_MSEC);
        Runnable probationRestorer = new Runnable(){

            public void run() {
                try {
                    LOG.trace("restoring hosts on probation");
                    HostCatcher hostCatcher = HostCatcher.this;
                    synchronized (hostCatcher) {
                        Iterator iter = HostCatcher.this.PROBATION_HOSTS.iterator();
                        while (iter.hasNext()) {
                            Endpoint host = (Endpoint)iter.next();
                            HostCatcher.this.add(host, false);
                        }
                        HostCatcher.this.PROBATION_HOSTS.clear();
                    }
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        RouterService.schedule(probationRestorer, PROBATION_RECOVERY_WAIT_TIME, PROBATION_RECOVERY_TIME);
        RouterService.schedule(this.FETCHER, 0L, 2000L);
        LOG.trace("STOP scheduling");
    }

    private void sendUDPPings() {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            UDPHostRanker.rank(new HashSet(this.ENDPOINT_SET), null);
        }
    }

    synchronized void read(File hostFile) throws FileNotFoundException, IOException {
        LOG.trace("entered HostCatcher.read(File)");
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(hostFile));
            while (true) {
                String line = in.readLine();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("read line: " + line);
                }
                if (line == null) break;
                try {
                    this.gWebCache.addBootstrapServer(new BootstrapServer(line));
                }
                catch (ParseException ignore) {
                    try {
                        this.add(ExtendedEndpoint.read(line), 0);
                    }
                    catch (ParseException pe) {}
                }
            }
            Object var6_7 = null;
            this.gWebCache.bootstrapServersAdded();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.gWebCache.bootstrapServersAdded();
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {}
        LOG.trace("left HostCatcher.read(File)");
    }

    synchronized void write() throws IOException {
        this.write(this.HOST_FILE);
    }

    synchronized void write(File hostFile) throws IOException {
        Object e;
        Iterator iter;
        this.repOk();
        FileWriter out = new FileWriter(hostFile);
        BootstrapServerManager bootstrapServerManager = this.gWebCache;
        synchronized (bootstrapServerManager) {
            iter = this.gWebCache.getBootstrapServers();
            while (iter.hasNext()) {
                e = (BootstrapServer)iter.next();
                out.write(((BootstrapServer)e).toString());
                out.write("\n");
            }
        }
        iter = this.permanentHosts.iterator();
        while (iter.hasNext()) {
            e = (ExtendedEndpoint)iter.next();
            ((ExtendedEndpoint)e).write(out);
        }
        out.close();
    }

    public boolean add(PingReply pr) {
        ExtendedEndpoint endpoint = pr.getDailyUptime() != -1 ? new ExtendedEndpoint(pr.getAddress(), pr.getPort(), pr.getDailyUptime()) : new ExtendedEndpoint(pr.getAddress(), pr.getPort());
        if (!pr.getClientLocale().equals("")) {
            endpoint.setClientLocale(pr.getClientLocale());
        }
        if (!this.isValidHost(endpoint)) {
            return false;
        }
        if (pr.supportsUnicast()) {
            QueryUnicaster.instance().addUnicastEndpoint(pr.getInetAddress(), pr.getPort());
        }
        if (pr.isUltrapeer()) {
            if (pr.hasFreeLeafSlots()) {
                this.addToFixedSizeSet(endpoint, this.FREE_LEAF_SLOTS_SET);
                if (!pr.hasFreeUltrapeerSlots()) {
                    return true;
                }
            }
            if (pr.hasFreeUltrapeerSlots() || ApplicationSettings.LANGUAGE.getValue().equals(pr.getClientLocale()) && pr.getNumFreeLocaleSlots() > 0) {
                this.addToFixedSizeSet(endpoint, this.FREE_ULTRAPEER_SLOTS_SET);
                return true;
            }
            return this.add(endpoint, 1);
        }
        return this.add(endpoint, 0);
    }

    private synchronized void addToFixedSizeSet(ExtendedEndpoint host, Set hosts) {
        if (hosts.add(host) && hosts.size() > 200) {
            hosts.remove(hosts.iterator().next());
        }
        this.addPermanent(host);
        this.notify();
    }

    private synchronized void addToLocaleMap(ExtendedEndpoint endpoint) {
        String loc = endpoint.getClientLocale();
        if (this.LOCALE_2_SET.containsKey(loc)) {
            Set s = (Set)this.LOCALE_2_SET.get(loc);
            if (s.add(endpoint) && s.size() > 100) {
                s.remove(s.iterator().next());
            }
        } else {
            HashSet s = new HashSet();
            s.add(endpoint);
            this.LOCALE_2_SET.put(loc, s);
        }
    }

    public boolean add(Endpoint e, boolean forceHighPriority) {
        if (forceHighPriority) {
            return this.add(e, 1);
        }
        return this.add(e, 0);
    }

    public boolean add(Endpoint e, boolean forceHighPriority, String locale) {
        if (forceHighPriority) {
            return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 1);
        }
        return this.add(new ExtendedEndpoint(e.getAddress(), e.getPort(), locale), 0);
    }

    public boolean add(Endpoint host, int priority) {
        LOG.trace("adding host");
        return this.add(new ExtendedEndpoint(host.getAddress(), host.getPort()), priority);
    }

    private boolean add(ExtendedEndpoint e, int priority) {
        this.repOk();
        if (!this.isValidHost(e)) {
            return false;
        }
        this.addPermanent(e);
        boolean ret = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (!this.ENDPOINT_SET.contains(e)) {
                ret = true;
                this.ENDPOINT_SET.add(e);
                Object ejected = this.ENDPOINT_QUEUE.insert(e, priority);
                if (ejected != null) {
                    this.ENDPOINT_SET.remove(ejected);
                }
                this.notify();
            }
        }
        this.repOk();
        return ret;
    }

    private synchronized boolean addPermanent(ExtendedEndpoint e) {
        if (NetworkUtils.isPrivateAddress(e.getInetAddress())) {
            return false;
        }
        if (this.permanentHostsSet.contains(e)) {
            return false;
        }
        this.addToLocaleMap(e);
        Object removed = this.permanentHosts.insert(e);
        if (removed != e) {
            this.permanentHostsSet.add(e);
            if (removed != null) {
                this.permanentHostsSet.remove(removed);
            }
            return true;
        }
        return false;
    }

    private synchronized boolean removePermanent(ExtendedEndpoint e) {
        boolean removed2;
        boolean removed1 = this.permanentHosts.remove(e);
        Assert.that(removed1 == (removed2 = this.permanentHostsSet.remove(e)), "Queue " + removed1 + " but set " + removed2);
        return removed1;
    }

    private boolean isValidHost(ExtendedEndpoint host) {
        if (host.isPrivateAddress()) {
            return false;
        }
        if (NetworkUtils.isMe(host.getAddress(), host.getPort())) {
            return false;
        }
        if (RouterService.getAcceptor().isBannedIP(host.getAddress())) {
            return false;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this.EXPIRED_HOSTS.contains(host)) {
                boolean bl = false;
                return bl;
            }
            if (this.PROBATION_HOSTS.contains(host)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public synchronized Endpoint getAnEndpoint() throws InterruptedException {
        while (true) {
            try {
                return this.getAnEndpointInternal();
            }
            catch (NoSuchElementException noSuchElementException) {
                Object var3_2;
                try {
                    ++this._catchersWaiting;
                    this.wait();
                    var3_2 = null;
                    --this._catchersWaiting;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    --this._catchersWaiting;
                    throw throwable;
                }
            }
        }
    }

    public synchronized void doneWithConnect(Endpoint e, boolean success) {
        if (!(e instanceof ExtendedEndpoint)) {
            return;
        }
        ExtendedEndpoint ee = (ExtendedEndpoint)e;
        this.removePermanent(ee);
        if (success) {
            ee.recordConnectionSuccess();
        } else {
            ++this._failures;
            ee.recordConnectionFailure();
        }
        this.addPermanent(ee);
    }

    private ExtendedEndpoint getAnEndpointInternal() throws NoSuchElementException {
        if (RouterService.isSupernode() && !this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (RouterService.isShieldedLeaf() && !this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_LEAF_SLOTS_SET);
        }
        if (!this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (!this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            Iterator iter = this.FREE_LEAF_SLOTS_SET.iterator();
            ExtendedEndpoint ee = (ExtendedEndpoint)iter.next();
            iter.remove();
            return ee;
        }
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            ExtendedEndpoint e = (ExtendedEndpoint)this.ENDPOINT_QUEUE.extractMax();
            boolean ok = this.ENDPOINT_SET.remove(e);
            Assert.that(ok, "Rep. invariant for HostCatcher broken.");
            return e;
        }
        throw new NoSuchElementException();
    }

    private ExtendedEndpoint preferenceWithLocale(Set s) {
        String loc = ApplicationSettings.LANGUAGE.getValue();
        if (this.LOCALE_2_SET.containsKey(loc)) {
            Set locales = (Set)this.LOCALE_2_SET.get(loc);
            HashSet retain = new HashSet(s);
            retain.retainAll(locales);
            if (retain.size() != 0) {
                Iterator itr = retain.iterator();
                ExtendedEndpoint ee = (ExtendedEndpoint)itr.next();
                locales.remove(ee);
                s.remove(ee);
                return ee;
            }
        }
        Iterator iter = s.iterator();
        ExtendedEndpoint ee = (ExtendedEndpoint)iter.next();
        iter.remove();
        return ee;
    }

    public int getNumHosts() {
        return this.ENDPOINT_QUEUE.size() + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    public int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(1) + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    Iterator getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Collection getUltrapeersWithFreeUltrapeerSlots() {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue());
    }

    public synchronized Collection getUltrapeersWithFreeUltrapeerSlots(String locale) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, locale);
    }

    public synchronized Collection getUltrapeersWithFreeLeafSlots() {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue());
    }

    public synchronized Collection getUltrapeersWithFreeLeafSlots(String locale) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, locale);
    }

    private Collection getPreferencedCollection(Set s, String loc) {
        Iterator itr;
        HashSet copy;
        if (loc == null || loc.equals("")) {
            loc = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        int i = 0;
        HashSet returnSet = new HashSet();
        if (this.LOCALE_2_SET.containsKey(loc)) {
            Set locales = (Set)this.LOCALE_2_SET.get(loc);
            copy = new HashSet(s);
            copy.retainAll(locales);
            itr = copy.iterator();
            while (itr.hasNext() && i < 10) {
                returnSet.add(itr.next());
                ++i;
            }
        }
        if (i < 10) {
            copy = new HashSet(s);
            copy.removeAll(returnSet);
            itr = copy.iterator();
            while (itr.hasNext() && i < 10) {
                returnSet.add(itr.next());
                ++i;
            }
        }
        return returnSet;
    }

    public synchronized void expire() {
        this.gWebCache.fetchBootstrapServersAsync();
    }

    public synchronized void clear() {
        this.FREE_LEAF_SLOTS_SET.clear();
        this.FREE_ULTRAPEER_SLOTS_SET.clear();
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
    }

    public String toString() {
        return "[volatile:" + this.ENDPOINT_QUEUE.toString() + ", permanent:" + this.permanentHosts.toString() + "]";
    }

    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            Iterator iter = this.ENDPOINT_SET.iterator();
            block3: while (iter.hasNext()) {
                Object e = iter.next();
                Iterator iter2 = this.ENDPOINT_QUEUE.iterator();
                while (iter2.hasNext()) {
                    if (e.equals(iter2.next())) continue block3;
                }
                Assert.that(false, "Couldn't find " + e + " in queue");
            }
            Iterator iter2 = this.ENDPOINT_QUEUE.iterator();
            while (iter2.hasNext()) {
                Object e = iter2.next();
                Assert.that(e instanceof ExtendedEndpoint);
                Assert.that(this.ENDPOINT_SET.contains(e));
            }
            Iterator iter3 = this.permanentHosts.iterator();
            while (iter3.hasNext()) {
                Object o = iter3.next();
                Assert.that(o instanceof ExtendedEndpoint);
                Assert.that(this.permanentHostsSet.contains(o));
            }
            Iterator iter4 = this.permanentHostsSet.iterator();
            while (iter4.hasNext()) {
                Object e = iter4.next();
                Assert.that(e instanceof ExtendedEndpoint);
                Assert.that(this.permanentHosts.contains(e), "Couldn't find " + e + " from " + this.permanentHostsSet + " in " + this.permanentHosts);
            }
        }
    }

    private void readHostsFile() {
        LOG.trace("Reading Hosts File");
        try {
            this.read(this.HOST_FILE);
        }
        catch (IOException e) {
            LOG.debug(this.HOST_FILE, e);
        }
    }

    public synchronized void recoverHosts() {
        LOG.debug("recovering hosts file");
        this.PROBATION_HOSTS.clear();
        this.EXPIRED_HOSTS.clear();
        this._failures = 0;
        this.FETCHER.resetFetchTime();
        this.gWebCache.resetData();
        this.readHostsFile();
        this.sendUDPPings();
    }

    public synchronized void putHostOnProbation(Endpoint host) {
        this.PROBATION_HOSTS.add(host);
        if (this.PROBATION_HOSTS.size() > 500) {
            this.PROBATION_HOSTS.remove(this.PROBATION_HOSTS.iterator().next());
        }
    }

    public synchronized void expireHost(Endpoint host) {
        this.EXPIRED_HOSTS.add(host);
        if (this.EXPIRED_HOSTS.size() > 500) {
            this.EXPIRED_HOSTS.remove(this.EXPIRED_HOSTS.iterator().next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GWebCacheFetcher
    implements Runnable {
        private long nextAllowedFetchTime = 0L;
        private int delay = 20000;

        private GWebCacheFetcher() {
        }

        public synchronized void run() {
            if (HostCatcher.this._catchersWaiting == 0) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now < this.nextAllowedFetchTime) {
                return;
            }
            if (!this.needsHosts(now)) {
                return;
            }
            this.getHosts(now);
        }

        synchronized void resetFetchTime() {
            this.nextAllowedFetchTime = 0L;
        }

        synchronized boolean needsHosts(long now) {
            HostCatcher hostCatcher = HostCatcher.this;
            synchronized (hostCatcher) {
                boolean bl = HostCatcher.this.getNumHosts() == 0 || !RouterService.isConnected() && HostCatcher.this._failures > 200;
                return bl;
            }
        }

        synchronized void getHosts(long now) {
            int ret = HostCatcher.this.gWebCache.fetchEndpointsAsync();
            switch (ret) {
                case 1: {
                    this.delay *= 5;
                    this.nextAllowedFetchTime = now + (long)this.delay;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("Fetching hosts.  Next allowed time: " + this.nextAllowedFetchTime);
                    break;
                }
                case 2: {
                    LOG.debug("Tried to fetch, but was already fetching.");
                    break;
                }
                case 0: {
                    LOG.debug("Didn't fetch, gWebCache's turned off.");
                    break;
                }
                case 3: {
                    LOG.debug("We've received a bunch of endpoints already, didn't fetch.");
                    MessageService.showError("GWEBCACHE_FETCHED_TOO_MANY");
                    break;
                }
                case 4: {
                    LOG.debug("Already contacted each gWebCache, didn't fetch.");
                    MessageService.showError("GWEBCACHE_NO_CACHES_LEFT");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid value: " + ret);
                }
            }
        }
    }
}

