/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileDesc
implements AlternateLocationCollector {
    private final int _index;
    private final String _path;
    private final String _name;
    private final int _size;
    private long _modTime;
    private final Set URNS;
    private final File FILE;
    private final URN SHA1_URN;
    private volatile List _limeXMLDocs = DataUtils.EMPTY_LIST;
    private AlternateLocationCollection ALT_LOCS;
    private int _hits;
    private int _attemptedUploads;
    private int _completedUploads;

    public FileDesc(File file, Set urns, int index) {
        if (file == null) {
            throw new NullPointerException("cannot create a FileDesc with a null File");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative values not permitted in FileDesc: " + index);
        }
        if (urns == null) {
            throw new NullPointerException("cannot create a FileDesc with a null URN Set");
        }
        this.FILE = new File(file.getAbsolutePath());
        this._index = index;
        this._name = this.FILE.getName();
        this._path = this.FILE.getAbsolutePath();
        this._size = (int)this.FILE.length();
        this._modTime = this.FILE.lastModified();
        this.URNS = Collections.unmodifiableSet(urns);
        this.SHA1_URN = this.extractSHA1();
        if (this.SHA1_URN == null) {
            throw new IllegalArgumentException("no SHA1 URN");
        }
        this.ALT_LOCS = AlternateLocationCollection.create(this.SHA1_URN);
        try {
            this.addUrnsForSelf();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this._hits = 0;
    }

    public static Set calculateAndCacheURN(File file) throws IOException, InterruptedException {
        if (file == null) {
            throw new NullPointerException("cannot accept null file argument");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("file does not exist: " + file);
        }
        Set urns = UrnCache.instance().getUrns(file);
        if (urns.size() == 0) {
            urns = FileDesc.calculateUrns(file);
            UrnCache.instance().addUrns(file, urns);
        }
        return urns;
    }

    public boolean hasUrns() {
        return !this.URNS.isEmpty();
    }

    public int getIndex() {
        return this._index;
    }

    public long getSize() {
        return this._size;
    }

    public String getName() {
        return this._name;
    }

    public long lastModified() {
        return this._modTime;
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    private URN extractSHA1() {
        Iterator iter = this.URNS.iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            if (!urn.isSHA1()) continue;
            return urn;
        }
        return null;
    }

    public File getFile() {
        return new File(this.FILE.getAbsolutePath());
    }

    public Set getUrns() {
        return this.URNS;
    }

    public String getPath() {
        return this.FILE.getAbsolutePath();
    }

    public void addLimeXMLDocument(LimeXMLDocument doc) {
        ArrayList newDocs = new ArrayList(this._limeXMLDocs.size() + 1);
        newDocs.addAll(this._limeXMLDocs);
        newDocs.add(doc);
        this._limeXMLDocs = newDocs;
    }

    public boolean replaceLimeXMLDocument(LimeXMLDocument oldDoc, LimeXMLDocument newDoc) {
        int index = this._limeXMLDocs.indexOf(oldDoc);
        if (index == -1) {
            return false;
        }
        ArrayList newDocs = new ArrayList(this._limeXMLDocs);
        Object removed = newDocs.remove(index);
        Assert.that(removed == oldDoc, "wrong doc removed!");
        newDocs.add(newDoc);
        this._limeXMLDocs = newDocs;
        return true;
    }

    public boolean removeLimeXMLDocument(LimeXMLDocument toRemove) {
        if (this._limeXMLDocs.size() == 0) {
            return false;
        }
        ArrayList newDocs = new ArrayList(this._limeXMLDocs);
        boolean removed = newDocs.remove(toRemove);
        this._limeXMLDocs = newDocs;
        return removed;
    }

    public List getLimeXMLDocuments() {
        return this._limeXMLDocs;
    }

    public AlternateLocationCollection getAlternateLocationCollection() {
        return this.ALT_LOCS;
    }

    public void addUrnsForSelf() {
        this.ALT_LOCS.add(AlternateLocation.create(this.SHA1_URN));
    }

    public boolean add(AlternateLocation al) {
        if (al == null) {
            throw new NullPointerException("cannot accept null alt locs");
        }
        URN sha1 = al.getSHA1Urn();
        if (sha1 == null) {
            throw new IllegalArgumentException("sha1 cannot be null");
        }
        if (!sha1.equals(this.SHA1_URN)) {
            throw new IllegalArgumentException("URN does not match:\n" + this.SHA1_URN + "\n" + sha1);
        }
        return this.ALT_LOCS.add(al);
    }

    public boolean remove(AlternateLocation al) {
        if (al == null) {
            throw new NullPointerException("cannot accept null alt locs");
        }
        URN sha1 = al.getSHA1Urn();
        if (sha1 == null) {
            throw new IllegalArgumentException("sha1 cannot be null");
        }
        if (!sha1.equals(this.SHA1_URN)) {
            throw new IllegalArgumentException("URN does not match:\n" + this.SHA1_URN + "\n" + sha1);
        }
        return this.ALT_LOCS.remove(al);
    }

    public int addAll(AlternateLocationCollection alc) {
        if (alc == null) {
            throw new NullPointerException("cannot accept null alt loc coll");
        }
        if (!alc.getSHA1Urn().equals(this.SHA1_URN)) {
            throw new IllegalArgumentException("SHA1 does not match:\n" + this.SHA1_URN + "\n" + alc.getSHA1Urn());
        }
        return this.ALT_LOCS.addAll(alc);
    }

    public boolean hasAlternateLocations() {
        return this.ALT_LOCS.hasAlternateLocations();
    }

    public int getAltLocsSize() {
        return this.ALT_LOCS.getAltLocsSize();
    }

    private static Set calculateUrns(File file) throws IOException, InterruptedException {
        HashSet set = new HashSet(1);
        set.add(URN.createSHA1Urn(file));
        return set;
    }

    public boolean containsUrn(URN urn) {
        if (urn == null) {
            throw new NullPointerException("null URNS not allowed in containsUrn");
        }
        Iterator iter = this.URNS.iterator();
        while (iter.hasNext()) {
            if (!urn.equals((URN)iter.next())) continue;
            return true;
        }
        return false;
    }

    public HashTree getHashTree() {
        return TigerTreeCache.instance().getHashTree(this);
    }

    public int incrementHitCount() {
        return ++this._hits;
    }

    public int getHitCount() {
        return this._hits;
    }

    public int incrementAttemptedUploads() {
        return ++this._attemptedUploads;
    }

    public int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public InputStream createInputStream() throws FileNotFoundException {
        return new FileInputStream(this.FILE);
    }

    private String listInformation(Iterator i) {
        StringBuffer stuff = new StringBuffer();
        while (i.hasNext()) {
            stuff.append(i.next().toString());
            if (!i.hasNext()) continue;
            stuff.append(", ");
        }
        return stuff.toString();
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this._index + "\r\n" + "path:     " + this._path + "\r\n" + "size:     " + this._size + "\r\n" + "modTime:  " + this._modTime + "\r\n" + "File:     " + this.FILE + "\r\n" + "urns:     " + this.listInformation(this.URNS.iterator()) + "\r\n" + "docs:     " + (this._limeXMLDocs == null ? "null" : this.listInformation(this._limeXMLDocs.iterator())) + "\r\n" + "alt locs: " + this.ALT_LOCS + "\r\n";
    }
}

