/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;

public class ExtendedEndpoint
extends Endpoint {
    static final long DEFAULT_TIME_RECORDED = 0L;
    private long timeRecorded = -1L;
    static final int DEFAULT_DAILY_UPTIME = 345;
    private int dailyUptime = -1;
    static final int HISTORY_SIZE = 3;
    static final long WINDOW_TIME = 86400000L;
    private Buffer connectSuccesses = new Buffer(3);
    private Buffer connectFailures = new Buffer(3);
    private String _clientLocale = ApplicationSettings.DEFAULT_LOCALE.getValue();
    private static final String ownLocale = ApplicationSettings.LANGUAGE.getValue();
    private static final String LIST_SEPARATOR = ";";
    private static final String FIELD_SEPARATOR = ",";
    static final String EOL = "\n";

    public ExtendedEndpoint(String host, int port, int dailyUptime) {
        super(host, port);
        this.dailyUptime = dailyUptime;
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String host, int port) {
        super(host, port);
        this.timeRecorded = this.now();
    }

    public ExtendedEndpoint(String host, int port, int dailyUptime, String locale) {
        super(host, port);
        this.dailyUptime = dailyUptime;
        this.timeRecorded = this.now();
        this._clientLocale = locale;
    }

    public ExtendedEndpoint(String host, int port, String locale) {
        this(host, port);
        this._clientLocale = locale;
    }

    public long getTimeRecorded() {
        if (this.timeRecorded < 0L) {
            return 0L;
        }
        return this.timeRecorded;
    }

    public int getDailyUptime() {
        if (this.dailyUptime < 0) {
            return 345;
        }
        return this.dailyUptime;
    }

    public void setDailyUptime(int uptime) {
        this.dailyUptime = uptime;
    }

    public void recordConnectionSuccess() {
        this.recordConnectionAttempt(this.connectSuccesses, this.now());
    }

    public void recordConnectionFailure() {
        this.recordConnectionAttempt(this.connectFailures, this.now());
    }

    public Iterator getConnectionSuccesses() {
        return this.connectSuccesses.iterator();
    }

    public Iterator getConnectionFailures() {
        return this.connectFailures.iterator();
    }

    public String getClientLocale() {
        return this._clientLocale;
    }

    public void setClientLocale(String l) {
        this._clientLocale = l;
    }

    private void recordConnectionAttempt(Buffer buf, long now) {
        if (buf.isEmpty()) {
            buf.addFirst(new Long(now));
        } else if (now - (Long)buf.first() >= 86400000L) {
            buf.addFirst(new Long(now));
        } else {
            buf.removeFirst();
            buf.addFirst(new Long(now));
        }
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    public void write(Writer out) throws IOException {
        out.write(this.getAddress());
        out.write(":");
        out.write(Integer.toString(this.getPort()));
        out.write(FIELD_SEPARATOR);
        if (this.dailyUptime >= 0) {
            out.write(Integer.toString(this.dailyUptime));
        }
        out.write(FIELD_SEPARATOR);
        if (this.timeRecorded >= 0L) {
            out.write(Long.toString(this.timeRecorded));
        }
        out.write(FIELD_SEPARATOR);
        this.write(out, this.getConnectionSuccesses());
        out.write(FIELD_SEPARATOR);
        this.write(out, this.getConnectionFailures());
        out.write(FIELD_SEPARATOR);
        out.write(this._clientLocale);
        out.write(EOL);
    }

    private void write(Writer out, Iterator longs) throws IOException {
        while (longs.hasNext()) {
            long n = (Long)longs.next();
            out.write(Long.toString(n));
            if (!longs.hasNext()) continue;
            out.write(LIST_SEPARATOR);
        }
    }

    public static ExtendedEndpoint read(String line) throws ParseException {
        int i;
        String[] times;
        int port;
        String host;
        String[] linea = StringUtils.splitNoCoalesce(line, FIELD_SEPARATOR);
        if (linea.length == 0) {
            throw new ParseException("Empty line", 0);
        }
        try {
            Endpoint tmp = new Endpoint(linea[0], true);
            host = tmp.getAddress();
            port = tmp.getPort();
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Couldn't extract address and port", 0);
        }
        ExtendedEndpoint ret = new ExtendedEndpoint(host, port);
        if (linea.length >= 2) {
            try {
                ret.dailyUptime = Integer.parseInt(linea[1].trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ret.timeRecorded = 0L;
        if (linea.length >= 3) {
            try {
                ret.timeRecorded = Long.parseLong(linea[2].trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (linea.length >= 4) {
            try {
                times = StringUtils.split(linea[3], LIST_SEPARATOR);
                i = times.length - 1;
                while (i >= 0) {
                    ret.recordConnectionAttempt(ret.connectSuccesses, Long.parseLong(times[i].trim()));
                    --i;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (linea.length >= 5) {
            try {
                times = StringUtils.split(linea[4], LIST_SEPARATOR);
                i = times.length - 1;
                while (i >= 0) {
                    ret.recordConnectionAttempt(ret.connectFailures, Long.parseLong(times[i].trim()));
                    --i;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (linea.length >= 6) {
            ret.setClientLocale(linea[5]);
        }
        return ret;
    }

    public static Comparator priorityComparator() {
        return new PriorityComparator();
    }

    private int connectScore() {
        long failure;
        if (this.connectSuccesses.isEmpty() && this.connectFailures.isEmpty()) {
            return 0;
        }
        if (this.connectSuccesses.isEmpty()) {
            return -1;
        }
        if (this.connectFailures.isEmpty()) {
            return 1;
        }
        long success = (Long)this.connectSuccesses.last();
        if (success > (failure = ((Long)this.connectFailures.last()).longValue())) {
            return 1;
        }
        if (success < failure) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    static class PriorityComparator
    implements Comparator {
        PriorityComparator() {
        }

        public int compare(Object extEndpoint1, Object extEndpoint2) {
            int ret;
            ExtendedEndpoint a = (ExtendedEndpoint)extEndpoint1;
            ExtendedEndpoint b = (ExtendedEndpoint)extEndpoint2;
            boolean bLoc = ownLocale.equals(b.getClientLocale());
            if (ownLocale.equals(a.getClientLocale())) {
                if (!bLoc) {
                    return 1;
                }
            } else if (bLoc) {
                return -1;
            }
            if ((ret = a.connectScore() - b.connectScore()) != 0) {
                return ret;
            }
            return a.getDailyUptime() - b.getDailyUptime();
        }
    }
}

