/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SupernodeAssigner;
import com.limegroup.gnutella.connection.ConnectionChecker;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.security.Authenticator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.SystemUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionManager {
    private volatile long _disconnectTime = 0L;
    private volatile long _automaticConnectTime = 0L;
    private volatile boolean _automaticallyConnecting;
    private volatile long _lastSuccessfulConnect = 0L;
    private volatile long _lastConnectionCheck = 0L;
    private static volatile int _connectionAttempts;
    private static final Log LOG;
    public static final int ULTRAPEER_CONNECTIONS;
    public static final int PREFERRED_CONNECTIONS_FOR_LEAF = 4;
    public static final int RESERVED_GOOD_LEAF_CONNECTIONS;
    public static final int RESERVED_NON_LIMEWIRE_LEAVES = 2;
    public static final int RESERVED_NON_LIMEWIRE_PEERS = 3;
    private HostCatcher _catcher;
    private volatile int _keepAlive = 0;
    private final List _fetchers = new ArrayList();
    private final List _initializingFetchedConnections = new ArrayList();
    private ConnectionFetcher _dedicatedPrefFetcher;
    private volatile boolean _needPref = true;
    private volatile List _connections = new ArrayList();
    private volatile List _initializedConnections = new ArrayList();
    private volatile List _initializedClientConnections = new ArrayList();
    private volatile int _shieldedConnections = 0;
    private volatile int _nonLimeWireLeaves = 0;
    private volatile int _nonLimeWirePeers = 0;
    private volatile int _localeMatchingPeers = 0;
    private final Authenticator _authenticator;
    private volatile int _leafTries;
    private volatile int _demotionLimit = 0;
    private volatile float _measuredUpstreamBandwidth = 0.0f;
    private volatile float _measuredDownstreamBandwidth = 0.0f;
    static /* synthetic */ Class class$com$limegroup$gnutella$ConnectionManager;

    public ConnectionManager(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public void initialize() {
        this._catcher = RouterService.getHostCatcher();
    }

    public ManagedConnection createConnectionBlocking(String hostname, int portnum) throws IOException {
        ManagedConnection c = new ManagedConnection(hostname, portnum);
        this.initializeExternallyGeneratedConnection(c);
        ManagedThread conn = new ManagedThread(new OutgoingConnector(c, false), "OutgoingConnector");
        conn.setDaemon(true);
        conn.start();
        return c;
    }

    public void createConnectionAsynchronously(String hostname, int portnum) {
        OutgoingConnector outgoingRunner = new OutgoingConnector(new ManagedConnection(hostname, portnum), true);
        ManagedThread outgoingConnectionRunner = new ManagedThread(outgoingRunner, "OutgoingConnectionThread");
        outgoingConnectionRunner.setDaemon(true);
        outgoingConnectionRunner.start();
    }

    void acceptConnection(Socket socket) {
        block11: {
            Thread.currentThread().setName("IncommingConnectionThread");
            ManagedConnection connection = new ManagedConnection(socket);
            try {
                this.initializeExternallyGeneratedConnection(connection);
            }
            catch (IOException e) {
                connection.close();
                return;
            }
            try {
                try {
                    this.startConnection(connection);
                }
                catch (IOException e) {
                    Object var6_6 = null;
                    if (connection.isClientSupernodeConnection()) {
                        this.lostShieldedClientSupernodeConnection();
                    }
                    break block11;
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                    Object var6_7 = null;
                    if (connection.isClientSupernodeConnection()) {
                        this.lostShieldedClientSupernodeConnection();
                    }
                }
                Object var6_5 = null;
                if (connection.isClientSupernodeConnection()) {
                    this.lostShieldedClientSupernodeConnection();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (connection.isClientSupernodeConnection()) {
                    this.lostShieldedClientSupernodeConnection();
                }
                throw throwable;
            }
        }
    }

    public synchronized void remove(ManagedConnection mc) {
        if (!ConnectionSettings.REMOVE_ENABLED.getValue()) {
            return;
        }
        this.removeInternal(mc);
        this.adjustConnectionFetchers();
    }

    public int getKeepAlive() {
        return this._keepAlive;
    }

    public synchronized void setKeepAlive(int newKeep) {
        this._keepAlive = newKeep;
        this.adjustConnectionFetchers();
    }

    public boolean isSupernode() {
        return this._initializedClientConnections.size() > 0 || this.isSupernodeCapable();
    }

    public boolean isSupernodeCapable() {
        return !NetworkUtils.isPrivate() && UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue() && !this.isShieldedLeaf() && !UltrapeerSettings.DISABLE_ULTRAPEER_MODE.getValue();
    }

    public boolean isShieldedLeaf() {
        return this._shieldedConnections != 0;
    }

    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    public boolean hasFreeSlots() {
        return this.isSupernode() && (this.hasFreeUltrapeerSlots() || this.hasFreeLeafSlots());
    }

    private boolean hasFreeUltrapeerSlots() {
        return this.getNumFreeNonLeafSlots() > 0;
    }

    private boolean hasFreeLeafSlots() {
        return this.getNumFreeLeafSlots() > 0;
    }

    boolean isConnectedTo(String hostName) {
        List connections = this.getConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.getAddress().equals(hostName)) continue;
            return true;
        }
        return false;
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    public int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    public int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    public int getNumClientSupernodeConnections() {
        return this._shieldedConnections;
    }

    public synchronized int getNumUltrapeerConnections() {
        return this.ultrapeerToUltrapeerConnections();
    }

    public synchronized int getNumOldConnections() {
        return this.oldConnections();
    }

    public int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return UltrapeerSettings.MAX_LEAVES.getValue() - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    public int getNumFreeLimeWireLeafSlots() {
        return Math.max(0, this.getNumFreeLeafSlots() - Math.max(0, 2 - this._nonLimeWireLeaves));
    }

    public int getNumFreeNonLeafSlots() {
        return ULTRAPEER_CONNECTIONS - this.getNumInitializedConnections();
    }

    public int getNumFreeLimeWireNonLeafSlots() {
        return Math.max(0, this.getNumFreeNonLeafSlots() - Math.max(0, 3 - this._nonLimeWirePeers) - this.getNumLimeWireLocalePrefSlots());
    }

    public int getNumLimeWireLocalePrefSlots() {
        return Math.max(0, ConnectionSettings.NUM_LOCALE_PREF.getValue() - this._localeMatchingPeers);
    }

    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    public void measureBandwidth() {
        float upstream = 0.0f;
        float downstream = 0.0f;
        List connections = this.getInitializedConnections();
        Iterator iter = connections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            mc.measureBandwidth();
            upstream += mc.getMeasuredUpstreamBandwidth();
            downstream += mc.getMeasuredDownstreamBandwidth();
        }
        this._measuredUpstreamBandwidth = upstream;
        this._measuredDownstreamBandwidth = downstream;
    }

    public float getMeasuredUpstreamBandwidth() {
        return this._measuredUpstreamBandwidth;
    }

    public float getMeasuredDownstreamBandwidth() {
        return this._measuredDownstreamBandwidth;
    }

    private boolean allowConnection(ManagedConnection c) {
        if (!c.receivedHeaders()) {
            return false;
        }
        return this.allowConnection(c.headers(), false);
    }

    public boolean allowConnectionAsLeaf(HandshakeResponse hr) {
        return this.allowConnection(hr, true);
    }

    public boolean allowConnection(HandshakeResponse hr) {
        return this.allowConnection(hr, !hr.isUltrapeer());
    }

    public boolean allowAnyConnection() {
        if (this.isShieldedLeaf()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._keepAlive || this.isSupernode() && this.getNumInitializedClientConnections() < UltrapeerSettings.MAX_LEAVES.getValue();
    }

    public boolean allowConnection(HandshakeResponse hr, boolean leaf) {
        if (!ConnectionSettings.PREFERENCING_ACTIVE.getValue()) {
            return true;
        }
        if (!ConnectionSettings.IGNORE_KEEP_ALIVE.getValue() && this._keepAlive <= 0) {
            return false;
        }
        if (RouterService.isShieldedLeaf()) {
            return hr.isGoodUltrapeer() && this._shieldedConnections < 4;
        }
        if (hr.isLeaf() || leaf) {
            if (!ConnectionManager.allowUltrapeer2LeafConnection(hr)) {
                return false;
            }
            int leaves = this.getNumInitializedClientConnections();
            int nonLimeWireLeaves = this._nonLimeWireLeaves;
            if (!hr.isLimeWire()) {
                return leaves < UltrapeerSettings.MAX_LEAVES.getValue() && nonLimeWireLeaves < 2;
            }
            if (hr.isGoodLeaf()) {
                return leaves + 2 - nonLimeWireLeaves < UltrapeerSettings.MAX_LEAVES.getValue();
            }
            return leaves < UltrapeerSettings.MAX_LEAVES.getValue() - RESERVED_GOOD_LEAF_CONNECTIONS;
        }
        if (hr.isUltrapeer()) {
            int peers = this.getNumInitializedConnections();
            int nonLimeWirePeers = this._nonLimeWirePeers;
            int locale_num = 0;
            if (!ConnectionManager.allowUltrapeer2UltrapeerConnection(hr)) {
                return false;
            }
            if (ConnectionSettings.USE_LOCALE_PREF.getValue()) {
                if (this.checkLocale(hr.getLocalePref()) && this._localeMatchingPeers < ConnectionSettings.NUM_LOCALE_PREF.getValue()) {
                    return true;
                }
                locale_num = this.getNumLimeWireLocalePrefSlots();
            }
            if (!hr.isLimeWire() && peers < ULTRAPEER_CONNECTIONS && nonLimeWirePeers < 3) {
                return true;
            }
            return peers + 3 - nonLimeWirePeers + locale_num < ULTRAPEER_CONNECTIONS;
        }
        return false;
    }

    private static boolean allowUltrapeer2UltrapeerConnection(HandshakeResponse hr) {
        String userAgent = hr.getUserAgent();
        if (userAgent == null) {
            return false;
        }
        return StringUtils.indexOfIgnoreCase(userAgent, "pheus") == -1;
    }

    private static boolean allowUltrapeer2LeafConnection(HandshakeResponse hr) {
        String userAgent = hr.getUserAgent();
        if (userAgent == null) {
            return false;
        }
        return StringUtils.indexOfIgnoreCase(userAgent, "pheus") == -1;
    }

    private int ultrapeerConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.isSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    private int ultrapeerToUltrapeerConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (!mc.isSupernodeSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    private int oldConnections() {
        int ret = 0;
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            if (mc.isSupernodeConnection()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean supernodeNeeded() {
        return (double)this.getNumInitializedClientConnections() >= (double)UltrapeerSettings.MAX_LEAVES.getValue() * 0.9;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public List getInitializedConnections() {
        return this._initializedConnections;
    }

    public List getInitializedConnectionsMatchLocale(String loc) {
        LinkedList matches = new LinkedList();
        Iterator itr = this._initializedConnections.iterator();
        while (itr.hasNext()) {
            Connection conn = (Connection)itr.next();
            if (!loc.equals(conn.getLocalePref())) continue;
            matches.add(conn);
        }
        return matches;
    }

    public List getInitializedClientConnections() {
        return this._initializedClientConnections;
    }

    public List getInitializedClientConnectionsMatchLocale(String loc) {
        LinkedList matches = new LinkedList();
        Iterator itr = this._initializedClientConnections.iterator();
        while (itr.hasNext()) {
            Connection conn = (Connection)itr.next();
            if (!loc.equals(conn.getLocalePref())) continue;
            matches.add(conn);
        }
        return matches;
    }

    public List getConnections() {
        ArrayList clone = new ArrayList(this._connections);
        return clone;
    }

    public Set getPushProxies() {
        if (this.isShieldedLeaf()) {
            Iterator ultrapeers = this.getInitializedConnections().iterator();
            HashSet proxies = new HashSet();
            while (ultrapeers.hasNext() && proxies.size() < 4) {
                ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
                if (currMC.getPushProxyPort() < 0) continue;
                proxies.add(currMC);
            }
            return proxies;
        }
        return DataUtils.EMPTY_SET;
    }

    public List getTCPRedirectUltrapeers() {
        Iterator ultrapeers = this.getInitializedConnections().iterator();
        ArrayList retList = new ArrayList(2);
        while (ultrapeers.hasNext() && retList.size() < 2) {
            ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
            if (currMC.remoteHostSupportsTCPRedirect() < 0) continue;
            retList.add(currMC);
        }
        return retList;
    }

    public List getUDPRedirectUltrapeers() {
        Iterator ultrapeers = this.getInitializedConnections().iterator();
        ArrayList retList = new ArrayList(2);
        while (ultrapeers.hasNext() && retList.size() < 2) {
            ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
            if (currMC.remoteHostSupportsUDPRedirect() < 0) continue;
            retList.add(currMC);
        }
        return retList;
    }

    public boolean sendTCPConnectBackRequests() {
        int sent = 0;
        TCPConnectBackVendorMessage cb = new TCPConnectBackVendorMessage(RouterService.getPort());
        Iterator ultrapeers = this.getInitializedConnections().iterator();
        while (sent < 2 && ultrapeers.hasNext()) {
            ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
            if (currMC.remoteHostSupportsTCPConnectBack() < 0) continue;
            currMC.send(cb);
            ++sent;
        }
        return sent > 0;
    }

    public boolean sendUDPConnectBackRequests(GUID cbGuid) {
        int sent = 0;
        UDPConnectBackVendorMessage cb = new UDPConnectBackVendorMessage(RouterService.getPort(), cbGuid);
        Iterator ultrapeers = this.getInitializedConnections().iterator();
        while (sent < 4 && ultrapeers.hasNext()) {
            ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
            if (currMC.remoteHostSupportsUDPConnectBack() < 0) continue;
            currMC.send(cb);
            ++sent;
        }
        return sent > 0;
    }

    public void updateQueryStatus(QueryStatusResponse stat) {
        if (this.isShieldedLeaf()) {
            Iterator ultrapeers = this.getInitializedConnections().iterator();
            while (ultrapeers.hasNext()) {
                ManagedConnection currMC = (ManagedConnection)ultrapeers.next();
                if (currMC.remoteHostSupportsLeafGuidance() < 0) continue;
                currMC.send(stat);
            }
        }
    }

    public Endpoint getConnectedGUESSUltrapeer() {
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iter.next();
            if (!connection.isSupernodeConnection() || !connection.isGUESSUltrapeer()) continue;
            return new Endpoint(connection.getInetAddress().getAddress(), connection.getPort());
        }
        return null;
    }

    public List getConnectedGUESSUltrapeers() {
        ArrayList retList = new ArrayList();
        Iterator iter = this._initializedConnections.iterator();
        while (iter.hasNext()) {
            ManagedConnection connection = (ManagedConnection)iter.next();
            if (!connection.isSupernodeConnection() || !connection.isGUESSUltrapeer()) continue;
            retList.add(connection);
        }
        return retList;
    }

    private void connectionInitializing(Connection c) {
        ArrayList newConnections = new ArrayList(this._connections);
        newConnections.add(c);
        this._connections = Collections.unmodifiableList(newConnections);
    }

    private void connectionInitializingIncoming(ManagedConnection c) {
        this.connectionInitializing(c);
    }

    private boolean connectionInitialized(ManagedConnection c) {
        if (this._connections.contains(c)) {
            c.buildAndStartQueues();
            if (!c.isSupernodeClientConnection()) {
                ArrayList newConnections = new ArrayList(this._initializedConnections);
                newConnections.add(c);
                this._initializedConnections = Collections.unmodifiableList(newConnections);
                if (c.isClientSupernodeConnection()) {
                    ++this._shieldedConnections;
                }
                if (!c.isLimeWire()) {
                    ++this._nonLimeWirePeers;
                }
                if (this.checkLocale(c.getLocalePref())) {
                    ++this._localeMatchingPeers;
                }
            } else {
                ArrayList newConnections = new ArrayList(this._initializedClientConnections);
                newConnections.add(c);
                this._initializedClientConnections = Collections.unmodifiableList(newConnections);
                if (!c.isLimeWire()) {
                    ++this._nonLimeWireLeaves;
                }
            }
            c.postInit();
            this.sendInitialPingRequest(c);
            return true;
        }
        return false;
    }

    public synchronized void disconnect() {
        this._disconnectTime = System.currentTimeMillis();
        this.setKeepAlive(0);
        Iterator iter = this.getConnections().iterator();
        while (iter.hasNext()) {
            ManagedConnection c = (ManagedConnection)iter.next();
            this.remove(c);
            if (!c.isSupernodeConnection()) continue;
            this._catcher.add(new Endpoint(c.getInetAddress().getHostAddress(), c.getPort()), true, c.getLocalePref());
        }
    }

    public synchronized void connect() {
        int outgoing;
        this._disconnectTime = 0L;
        if (this.isConnected() || this._catcher == null) {
            return;
        }
        this.recoverHosts();
        _connectionAttempts = 0;
        this._lastConnectionCheck = 0L;
        this._lastSuccessfulConnect = 0L;
        long fetched = ConnectionSettings.LAST_GWEBCACHE_FETCH_TIME.getValue();
        if (fetched + 604800000L <= System.currentTimeMillis()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fetching more bootstrap servers. Last fetch time: " + fetched);
            }
            this._catcher.expire();
        }
        int n = outgoing = !this.isSupernodeCapable() ? 4 : ConnectionSettings.NUM_CONNECTIONS.getValue();
        if (outgoing < 1) {
            ConnectionSettings.NUM_CONNECTIONS.revertToDefault();
            outgoing = ConnectionSettings.NUM_CONNECTIONS.getValue();
        }
        this.setKeepAlive(outgoing);
    }

    private void sendInitialPingRequest(ManagedConnection connection) {
        if (connection.supportsPongCaching()) {
            return;
        }
        PingRequest pr = this.getNumInitializedConnections() >= this._keepAlive ? new PingRequest(1) : new PingRequest(4);
        connection.send(pr);
        try {
            connection.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeInternal(ManagedConnection c) {
        ArrayList newConnections;
        int i;
        if (!c.isSupernodeClientConnection()) {
            i = this._initializedConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList();
                newConnections.addAll(this._initializedConnections);
                newConnections.remove(c);
                this._initializedConnections = Collections.unmodifiableList(newConnections);
                if (c.isClientSupernodeConnection()) {
                    --this._shieldedConnections;
                }
                if (!c.isLimeWire()) {
                    --this._nonLimeWirePeers;
                }
                if (this.checkLocale(c.getLocalePref())) {
                    --this._localeMatchingPeers;
                }
            }
        } else {
            i = this._initializedClientConnections.indexOf(c);
            if (i != -1) {
                newConnections = new ArrayList();
                newConnections.addAll(this._initializedClientConnections);
                newConnections.remove(c);
                this._initializedClientConnections = Collections.unmodifiableList(newConnections);
                if (!c.isLimeWire()) {
                    --this._nonLimeWireLeaves;
                }
            }
        }
        i = this._connections.indexOf(c);
        if (i != -1) {
            newConnections = new ArrayList(this._connections);
            newConnections.remove(c);
            this._connections = Collections.unmodifiableList(newConnections);
        }
        c.close();
        RouterService.getMessageRouter().removeConnection(c);
        RouterService.getCallback().connectionClosed(c);
        QueryUnicaster.instance().purgeQuery(c);
    }

    private void adjustConnectionFetchers() {
        int multiple;
        if (ConnectionSettings.USE_LOCALE_PREF.getValue() && RouterService.isShieldedLeaf() && this._needPref && this._dedicatedPrefFetcher == null) {
            this._dedicatedPrefFetcher = new ConnectionFetcher(true);
            Runnable interrupted = new Runnable(){

                public void run() {
                    ConnectionManager connectionManager = ConnectionManager.this;
                    synchronized (connectionManager) {
                        if (ConnectionManager.this._dedicatedPrefFetcher == null) {
                            return;
                        }
                        ConnectionManager.this._dedicatedPrefFetcher.interrupt();
                        ConnectionManager.this._dedicatedPrefFetcher = null;
                        ConnectionManager.this._needPref = false;
                    }
                }
            };
            RouterService.schedule(interrupted, 15000L, 0L);
        }
        int goodConnections = this.getNumInitializedConnections();
        int neededConnections = this._keepAlive - goodConnections;
        if (!RouterService.acceptedIncomingConnection()) {
            multiple = 4;
        } else if (this.isShieldedLeaf() || !this.isSupernode() || this.getNumUltrapeerConnections() == 0) {
            multiple = 4;
        } else if (neededConnections > 10) {
            multiple = 4;
        } else {
            multiple = 2;
            neededConnections -= 8;
        }
        int need = Math.min(20, multiple * neededConnections) - this._fetchers.size() - this._initializingFetchedConnections.size();
        while (need > 0) {
            this._fetchers.add(new ConnectionFetcher());
            --need;
        }
        int lastFetcherIndex = this._fetchers.size();
        while (need < 0 && lastFetcherIndex > 0) {
            ConnectionFetcher fetcher = (ConnectionFetcher)this._fetchers.remove(--lastFetcherIndex);
            fetcher.interrupt();
            ++need;
        }
        int lastInitializingConnectionIndex = this._initializingFetchedConnections.size();
        while (need < 0 && lastInitializingConnectionIndex > 0) {
            ManagedConnection connection = (ManagedConnection)this._initializingFetchedConnections.remove(--lastInitializingConnectionIndex);
            this.removeInternal(connection);
            ++need;
        }
    }

    private void initializeFetchedConnection(ManagedConnection mc, ConnectionFetcher fetcher) throws NoGnutellaOkException, BadHandshakeException, IOException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (fetcher.isInterrupted()) {
                throw new IOException("connection fetcher");
            }
            this._initializingFetchedConnections.add(mc);
            if (fetcher == this._dedicatedPrefFetcher) {
                this._dedicatedPrefFetcher = null;
            } else {
                this._fetchers.remove(fetcher);
            }
            this.connectionInitializing(mc);
        }
        RouterService.getCallback().connectionInitializing(mc);
        try {
            try {
                mc.initialize();
            }
            catch (IOException e) {
                ConnectionManager connectionManager2 = this;
                synchronized (connectionManager2) {
                    this._initializingFetchedConnections.remove(mc);
                    this.removeInternal(mc);
                    this.adjustConnectionFetchers();
                }
                throw e;
            }
            Object var8_6 = null;
            this.processConnectionHeaders(mc);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.processConnectionHeaders(mc);
            throw throwable;
        }
        this.completeConnectionInitialization(mc, true);
    }

    private synchronized void gotShieldedClientSupernodeConnection() {
        boolean firstShieldedConnection;
        boolean bl = firstShieldedConnection = this.ultrapeerConnections() == 1 && this._keepAlive > 0;
        if (firstShieldedConnection) {
            this.setKeepAlive(4);
        }
    }

    private synchronized void lostShieldedClientSupernodeConnection() {
    }

    private void processConnectionHeaders(Connection connection) {
        if (!connection.receivedHeaders()) {
            return;
        }
        Properties headers = connection.headers().props();
        if (headers == null) {
            return;
        }
        this.updateHostCache(connection.headers());
        String remoteAddress = headers.getProperty("Listen-IP");
        if (remoteAddress == null) {
            remoteAddress = headers.getProperty("X-My-Address");
        }
        if (remoteAddress != null && !connection.isOutgoing()) {
            int colonIndex = remoteAddress.indexOf(58);
            if (colonIndex == -1) {
                return;
            }
            if (++colonIndex > remoteAddress.length()) {
                return;
            }
            try {
                int port = Integer.parseInt(remoteAddress.substring(colonIndex).trim());
                if (NetworkUtils.isValidPort(port)) {
                    connection.setListeningPort(port);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public boolean allowLeafDemotion() {
        ++this._leafTries;
        int connections = this.getNumInitializedConnections() + this.getNumInitializedClientConnections();
        if (UltrapeerSettings.FORCE_ULTRAPEER_MODE.getValue() || this.isSupernode() && connections > 0) {
            return false;
        }
        return !SupernodeAssigner.isTooGoodToPassUp() || this._leafTries >= this._demotionLimit;
    }

    public void tryToBecomeAnUltrapeer(int demotionLimit) {
        if (this.isSupernode()) {
            return;
        }
        this._demotionLimit = demotionLimit;
        this._leafTries = 0;
        this.disconnect();
        this.connect();
    }

    private void updateHostCache(HandshakeResponse headers) {
        if (!headers.hasXTryUltrapeers()) {
            return;
        }
        String hostAddresses = headers.getXTryUltrapeers();
        StringTokenizer st = new StringTokenizer(hostAddresses, ",");
        while (st.hasMoreTokens()) {
            Endpoint e;
            String address = st.nextToken().trim();
            try {
                e = new Endpoint(address);
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            this._catcher.add(e, true);
        }
    }

    private void initializeExternallyGeneratedConnection(ManagedConnection c) throws IOException {
        ConnectionManager connectionManager;
        if (c.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(c);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(c);
        }
        try {
            try {
                c.initialize();
            }
            catch (IOException e) {
                this.remove(c);
                throw e;
            }
            Object var5_5 = null;
            this.processConnectionHeaders(c);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.processConnectionHeaders(c);
            throw throwable;
        }
        if (!c.isOutgoing() && !this.allowConnection(c)) {
            c.loopToReject();
            throw new IOException("No space for connection");
        }
        if (!c.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializingIncoming(c);
                this.adjustConnectionFetchers();
            }
            RouterService.getCallback().connectionInitializing(c);
        }
        this.completeConnectionInitialization(c, false);
    }

    private void completeConnectionInitialization(ManagedConnection mc, boolean fetched) {
        boolean connectionOpen = false;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (fetched) {
                this._initializingFetchedConnections.remove(mc);
            }
            if ((connectionOpen = this.connectionInitialized(mc)) && mc.isClientSupernodeConnection()) {
                this.gotShieldedClientSupernodeConnection();
            }
            if (connectionOpen) {
                RouterService.getCallback().connectionInitialized(mc);
            }
        }
    }

    private void startConnection(ManagedConnection conn) throws IOException {
        Thread.currentThread().setName("MessageLoopingThread");
        if (conn.isGUESSUltrapeer()) {
            QueryUnicaster.instance().addUnicastEndpoint(conn.getInetAddress(), conn.getPort());
        }
        conn.loopForMessages();
    }

    public void noInternetConnection() {
        if (this._automaticallyConnecting) {
            return;
        }
        if (SystemUtils.supportsIdleTime() && SystemUtils.getIdleTime() < 30000L && !QuestionsHandler.NO_INTERNET.getValue()) {
            MessageService.showError("NO_INTERNET", QuestionsHandler.NO_INTERNET);
        } else {
            MessageService.showError("NO_INTERNET_RETRYING", QuestionsHandler.NO_INTERNET_RETRYING);
            this.disconnect();
            RouterService.schedule(new Runnable(){

                public void run() {
                    if (ConnectionManager.this._automaticConnectTime < ConnectionManager.this._disconnectTime) {
                        return;
                    }
                    if (!RouterService.isConnected()) {
                        ConnectionManager.this.recoverHosts();
                        ConnectionManager.this.connect();
                    }
                }
            }, 10000L, 120000L);
            this._automaticConnectTime = System.currentTimeMillis();
            this._automaticallyConnecting = true;
        }
        this.recoverHosts();
    }

    private void recoverHosts() {
        if (this._catcher != null && this._catcher.getNumHosts() < 100) {
            this._catcher.recoverHosts();
        }
    }

    private boolean checkLocale(String loc) {
        if (loc == null) {
            loc = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        return ApplicationSettings.LANGUAGE.getValue().equals(loc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOG = LogFactory.getLog(class$com$limegroup$gnutella$ConnectionManager == null ? (class$com$limegroup$gnutella$ConnectionManager = ConnectionManager.class$("com.limegroup.gnutella.ConnectionManager")) : class$com$limegroup$gnutella$ConnectionManager);
        ULTRAPEER_CONNECTIONS = ConnectionSettings.NUM_CONNECTIONS.getValue();
        RESERVED_GOOD_LEAF_CONNECTIONS = UltrapeerSettings.MAX_LEAVES.getValue() - 15;
    }

    private class ConnectionFetcher
    extends ManagedThread {
        private boolean _pref = false;

        public ConnectionFetcher() {
            this(false);
        }

        public ConnectionFetcher(boolean pref) {
            this.setName("ConnectionFetcher");
            this._pref = pref;
            this.setDaemon(true);
            this.start();
        }

        public void managedRun() {
            try {
                Endpoint endpoint = null;
                do {
                    endpoint = ConnectionManager.this._catcher.getAnEndpoint();
                } while (!IPFilter.instance().allow(endpoint.getAddress()) || ConnectionManager.this.isConnectedTo(endpoint.getAddress()));
                Assert.that(endpoint != null);
                _connectionAttempts++;
                ManagedConnection connection = new ManagedConnection(endpoint.getAddress(), endpoint.getPort());
                connection.setLocalePreferencing(this._pref);
                long curTime = System.currentTimeMillis();
                if (!ConnectionManager.this.isConnected() && _connectionAttempts > 40 && curTime - ConnectionManager.this._lastSuccessfulConnect > 4000L && curTime - ConnectionManager.this._lastConnectionCheck > 3600000L) {
                    _connectionAttempts = 0;
                    ConnectionManager.this._lastConnectionCheck = curTime;
                    LOG.debug("checking for live connection");
                    ConnectionChecker.checkForLiveConnection();
                }
                try {
                    ConnectionManager.this.initializeFetchedConnection(connection, this);
                    ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
                    ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                    if (this._pref) {
                        ConnectionManager.this._needPref = false;
                    }
                }
                catch (NoGnutellaOkException e) {
                    ConnectionManager.this._lastSuccessfulConnect = System.currentTimeMillis();
                    if (e.getCode() == 577) {
                        ConnectionManager.this._catcher.add(endpoint, true, connection.getLocalePref());
                    } else {
                        ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                        ConnectionManager.this._catcher.putHostOnProbation(endpoint);
                    }
                    throw e;
                }
                catch (IOException e) {
                    ConnectionManager.this._catcher.doneWithConnect(endpoint, false);
                    ConnectionManager.this._catcher.expireHost(endpoint);
                    throw e;
                }
                ConnectionManager.this.startConnection(connection);
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                ErrorService.error(e);
            }
        }

        public String toString() {
            return "ConnectionFetcher";
        }
    }

    private class OutgoingConnector
    implements Runnable {
        private final ManagedConnection _connection;
        private final boolean _doInitialization;

        public OutgoingConnector(ManagedConnection connection, boolean initialize) {
            this._connection = connection;
            this._doInitialization = initialize;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (this._doInitialization) {
                        ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection);
                    }
                    ConnectionManager.this.startConnection(this._connection);
                }
                catch (IOException e) {
                    Object var4_2 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                catch (Throwable e) {
                    ErrorService.error(e);
                    Object var4_3 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                Object var4_1 = null;
                if (!this._connection.isClientSupernodeConnection()) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!this._connection.isClientSupernodeConnection()) throw throwable;
                ConnectionManager.this.lostShieldedClientSupernodeConnection();
                throw throwable;
            }
            ConnectionManager.this.lostShieldedClientSupernodeConnection();
        }
    }
}

