/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.apache.commons.httpclient.Header;

public class HeaderGroup {
    private List headers = new ArrayList();

    public void clear() {
        this.headers.clear();
    }

    public void addHeader(Header header) {
        this.headers.add((Object)header);
    }

    public void removeHeader(Header header) {
        this.headers.remove((Object)header);
    }

    public void setHeaders(Header[] headers) {
        this.clear();
        for (int i = 0; i < headers.length; ++i) {
            this.addHeader(headers[i]);
        }
    }

    public Header getCondensedHeader(String name) {
        Header[] headers = this.getHeaders(name);
        if (headers.length == 0) {
            return null;
        }
        if (headers.length == 1) {
            return new Header(headers[0].getName(), headers[0].getValue());
        }
        StringBuffer valueBuffer = new StringBuffer(headers[0].getValue());
        for (int i = 1; i < headers.length; ++i) {
            valueBuffer.append(", ");
            valueBuffer.append(headers[i].getValue());
        }
        return new Header(name.toLowerCase(), valueBuffer.toString());
    }

    public Header[] getHeaders(String name) {
        ArrayList headersFound = new ArrayList();
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            headersFound.add((Object)header);
        }
        return (Header[])headersFound.toArray((Object[])new Header[headersFound.size()]);
    }

    public Header getFirstHeader(String name) {
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public Header getLastHeader(String name) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            Header header = (Header)this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public Header[] getAllHeaders() {
        return (Header[])this.headers.toArray((Object[])new Header[this.headers.size()]);
    }

    public boolean containsHeader(String name) {
        Iterator headerIter = this.headers.iterator();
        while (headerIter.hasNext()) {
            Header header = (Header)headerIter.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

