/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.CorruptHeaderException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class XingVBRHeader
implements Serializable {
    private final int FLAGS_SIZE = 4;
    private final int HEAD_SIZE = 4;
    private final String HEAD_START = "Xing";
    private final double[] TIMEPERFRAME_TABLE = new double[]{-1.0, 1152.0, 1152.0, 384.0};
    private final int TOC_SIZE = 100;
    private int avgBitrate = -1;
    private boolean exists = false;
    private int length = -1;
    private int numBytes = -1;
    private int numFrames = -1;
    private int playingTime = -1;
    private byte[] toc;
    private int vbrScale = -1;

    public XingVBRHeader(RandomAccessFile raf, long offset, int layer, int mpegVersion, int sampleRate, int channelMode) throws IOException, CorruptHeaderException {
        this.exists = this.checkHeader(raf, offset, channelMode, mpegVersion);
        if (this.exists) {
            this.readHeader(raf);
            this.calcValues(layer, mpegVersion, sampleRate);
        }
    }

    private void calcValues(int layer, int mpegVersion, int sampleRate) {
        double tpf = this.TIMEPERFRAME_TABLE[layer] / (double)sampleRate;
        if (mpegVersion == 2 || mpegVersion == 0) {
            tpf /= 2.0;
        }
        this.playingTime = (int)(tpf * (double)this.numFrames);
        this.avgBitrate = (int)((double)(this.numBytes * 8) / (tpf * (double)this.numFrames * 1000.0));
    }

    private boolean checkHeader(RandomAccessFile raf, long offset, int channelMode, int mpegVersion) throws IOException {
        boolean b = false;
        byte[] head = new byte[4];
        if (mpegVersion == 3) {
            if (channelMode == 3) {
                raf.seek(offset + 21L);
            } else {
                raf.seek(offset + 36L);
            }
        } else if (channelMode == 3) {
            raf.seek(offset + 23L);
        } else {
            raf.seek(offset + 21L);
        }
        if (raf.read(head) == head.length) {
            b = "Xing".equals(new String(head));
        }
        return b;
    }

    public int getAvgBitrate() {
        return this.avgBitrate;
    }

    public int getLength() {
        return this.length;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getPlayingTime() {
        return this.playingTime;
    }

    public byte[] getTOC() {
        return this.toc;
    }

    public int getVBRScale() {
        return this.vbrScale;
    }

    public boolean headerExists() {
        return this.exists;
    }

    private void readHeader(RandomAccessFile raf) throws IOException, CorruptHeaderException {
        this.length = 4;
        byte[] flags = new byte[4];
        if (raf.read(flags) != flags.length) {
            throw new CorruptHeaderException("XingVBRHeader.readHeader: Unexpected end-of-file encountered");
        }
        this.length += flags.length;
        if (BinaryParser.bitSet(flags[3], 0)) {
            this.numFrames = raf.readInt();
            this.length += 4;
        }
        if (BinaryParser.bitSet(flags[3], 1)) {
            this.numBytes = raf.readInt();
            this.length += 4;
        }
        if (BinaryParser.bitSet(flags[3], 2)) {
            this.toc = new byte[100];
            if (raf.read(this.toc) != this.toc.length) {
                throw new CorruptHeaderException("XingVBRHeader.readHeader: Unexpected end-of-file encountered");
            }
            this.length += 100;
        }
        if (BinaryParser.bitSet(flags[3], 3)) {
            this.vbrScale = raf.readInt();
            this.length += 4;
        }
        if (this.numBytes == -1 || this.numBytes == 0) {
            this.numBytes = (int)raf.length();
        }
    }

    public String toString() {
        return "NumFrames:\t\t\t" + this.getNumFrames() + "\nNumBytes:\t\t\t" + this.getNumBytes() + " bytes\nVBRScale:\t\t\t" + this.getVBRScale() + "\nLength:\t\t\t\t" + this.getLength() + " bytes";
    }
}

