/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.ID3v2FormatException;
import helliker.id3.MP3File;
import helliker.id3.MP3FileFilter;
import helliker.id3.PlaylistException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class Playlist
extends LinkedList
implements Serializable {
    public static int MUSICMATCH_FORMAT;
    private final String PLAYLIST_EXT = ".m3u";
    public static int WINAMP_FORMAT;

    static {
        WINAMP_FORMAT = 0;
        MUSICMATCH_FORMAT = 1;
    }

    public void addDirectory(File dir, boolean recurse, boolean sort) throws IOException {
        if (dir.isDirectory()) {
            Object[] files = dir.listFiles(new MP3FileFilter(true));
            if (sort) {
                Arrays.sort(files);
            }
            MP3File mp3 = null;
            int i = 0;
            while (i < files.length) {
                if (((File)files[i]).isFile()) {
                    try {
                        mp3 = new MP3File((File)files[i]);
                        this.add(mp3);
                    }
                    catch (Exception e) {
                    }
                } else if (recurse) {
                    this.addDirectory((File)files[i], recurse, sort);
                }
                ++i;
            }
        } else {
            throw new IOException("Error loading playlist from a directory: " + dir.getAbsolutePath() + " is not a " + "directory");
        }
    }

    public void addDirectory(File dir) throws IOException {
        this.addDirectory(dir, true, true);
    }

    public void loadFromFile(File m3uFile, int format) throws PlaylistException, FileNotFoundException, IOException {
        FileReader in = new FileReader(m3uFile);
        BufferedReader reader = new BufferedReader(in);
        if (format == WINAMP_FORMAT) {
            this.loadWinampFile(reader, m3uFile);
        } else if (format == MUSICMATCH_FORMAT) {
            this.loadMusicMatchFile(reader);
        }
        reader.close();
        in.close();
    }

    /*
     * WARNING - void declaration
     */
    private void loadMusicMatchFile(BufferedReader reader) throws PlaylistException, IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            try {
                void var2_2;
                this.add(new MP3File((String)var2_2));
            }
            catch (Exception e) {
            }
        }
    }

    private void loadWinampFile(BufferedReader reader, File m3uFile) throws PlaylistException, IOException {
        String str = reader.readLine();
        MP3File mp3 = null;
        if (str.equals("#EXTM3U")) {
            while ((str = reader.readLine()) != null) {
                if (str.indexOf("EXTINF:") != -1) {
                    str = reader.readLine();
                    if (str.length() != 0 && (str.charAt(0) != '/' || str.indexOf(":") != -1)) {
                        str = m3uFile.getParent() + File.separator + str;
                    }
                    try {
                        mp3 = new MP3File(str);
                        this.add(mp3);
                    }
                    catch (Exception e) {
                    }
                    continue;
                }
                throw new PlaylistException();
            }
        } else {
            throw new PlaylistException();
        }
    }

    public void sort(Comparator cmp) {
        Collections.sort(this, cmp);
    }

    public void sort() {
        Collections.sort(this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            buf.append(it.next());
        }
        return buf.toString();
    }

    private void writeMusicMatchFile(PrintWriter printer) throws IOException {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MP3File mp3 = (MP3File)it.next();
            printer.println(mp3.getPath());
        }
    }

    public void writeToFile(File dest, int format) throws IOException {
        File m3u = dest;
        if (dest.isDirectory()) {
            m3u = new File(dest, dest.getName() + ".m3u");
        }
        FileOutputStream out = new FileOutputStream(m3u);
        PrintWriter printer = new PrintWriter(out);
        if (format == WINAMP_FORMAT) {
            this.writeWinampFile(printer);
        } else if (format == MUSICMATCH_FORMAT) {
            this.writeMusicMatchFile(printer);
        }
        printer.close();
        out.close();
    }

    private void writeWinampFile(PrintWriter printer) throws IOException {
        Iterator it = this.iterator();
        String artist = new String();
        String title = new String();
        String display = new String();
        printer.println("#EXTM3U");
        while (it.hasNext()) {
            MP3File mp3 = (MP3File)it.next();
            printer.print("#EXTINF:");
            printer.print(mp3.getPlayingTime());
            printer.print(",");
            try {
                artist = mp3.getArtist();
            }
            catch (ID3v2FormatException e) {
            }
            try {
                title = mp3.getTitle();
            }
            catch (ID3v2FormatException e) {
            }
            if (artist.length() != 0 && title.length() != 0) {
                display = artist + " - " + title;
            } else if (title.length() != 0) {
                display = title;
            } else {
                display = mp3.getFileName();
                display = display.substring(0, display.length() - 4);
            }
            printer.println(display);
            printer.println(mp3.getPath());
        }
    }
}

