/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import java.io.Serializable;

public final class BinaryParser
implements Serializable {
    private static final int NUM_BITS = 8;
    private static final int NUM_BYTES = 4;
    private static final int SYNCHSAFE_BITS = 7;

    public static boolean bitSet(byte b, int pos) {
        boolean retval = false;
        if (pos >= 0 && pos < 8) {
            retval = (b & (byte)(1 << pos)) != 0;
        }
        return retval;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static byte[] convertToBytes(int num) {
        byte[] b = new byte[4];
        int count = num;
        boolean done = false;
        int i = b.length - 1;
        while (i >= 0 && !done) {
            int j = 0;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    if (count % 2 == 1) {
                        b[i] = BinaryParser.setBit(b[i], j);
                    }
                    done = (count /= 2) == 0;
                    ++j;
                }
                if (j >= 8) break;
            } while (!done);
            --i;
        }
        return b;
    }

    public static int convertToDecimal(byte b, int start, int end) {
        byte ret = 0;
        int bCount = 0;
        int s = start;
        int e = end;
        if (start < 0 || start >= 8) {
            s = 0;
        }
        if (end < 0 || end >= 8) {
            e = 7;
        }
        if (start > end) {
            s = end;
            e = start;
        }
        int i = s;
        while (i <= e) {
            if (BinaryParser.bitSet(b, i)) {
                ret = BinaryParser.setBit(ret, bCount);
            }
            ++bCount;
            ++i;
        }
        return ret;
    }

    public static int convertToInt(byte[] b) {
        int retval = 0;
        int pos = 0;
        int start = b.length - 1;
        if (start >= 4) {
            start = 3;
        }
        int i = start;
        while (i >= 0) {
            int j = 0;
            while (j < 8) {
                if (BinaryParser.bitSet(b[i], j)) {
                    retval = (int)((double)retval + Math.pow(2.0, pos));
                }
                ++pos;
                ++j;
            }
            --i;
        }
        return retval;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static byte[] convertToSynchsafeBytes(int num) {
        byte[] b = new byte[4];
        int count = num;
        boolean done = false;
        int i = b.length - 1;
        while (i >= 0 && !done) {
            int j = 0;
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    if (count % 2 == 1) {
                        b[i] = BinaryParser.setBit(b[i], j);
                    }
                    done = (count /= 2) == 0;
                    ++j;
                }
                if (j >= 7) break;
            } while (!done);
            --i;
        }
        return b;
    }

    public static int convertToSynchsafeInt(byte[] b) {
        int retval = 0;
        int pos = 0;
        int start = b.length - 1;
        if (start >= 4) {
            start = 3;
        }
        int i = start;
        while (i >= 0) {
            int j = 0;
            while (j < 7) {
                if (BinaryParser.bitSet(b[i], j)) {
                    retval = (int)((double)retval + Math.pow(2.0, pos));
                }
                ++pos;
                ++j;
            }
            --i;
        }
        return retval;
    }

    public static boolean matchPattern(byte b, String pattern) {
        boolean retval = true;
        int i = 0;
        while (i < 8 && i < pattern.length() && retval) {
            if (pattern.charAt(i) == '1') {
                retval = retval && BinaryParser.bitSet(b, 8 - i - 1);
            } else if (pattern.charAt(i) == '0') {
                retval = retval && !BinaryParser.bitSet(b, 8 - i - 1);
            }
            ++i;
        }
        return retval;
    }

    public static byte setBit(byte b, int location) {
        byte ret = 0;
        if (location >= 0 && location < 8) {
            ret = (byte)(b | (byte)(1 << location));
        }
        return ret;
    }
}

