/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidButtonUI;
import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.SpecialUIButton;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class LiquidWindowButtonUI
extends LiquidButtonUI {
    public static final int CLOSE = 0;
    public static final int MAXIMIZE = 1;
    public static final int MINIMIZE = 2;
    public static final int RESTORE = 3;
    private static final String[] files = new String[]{"closebutton.png", "maximizebutton.png", "minimizebutton.png", "restorebutton.png"};
    private static final String[] pantherFiles = new String[]{"panther-closebutton.png", "panther-maximizebutton.png", "panther-minimizebutton.png", "panther-restorebutton.png"};
    private static SkinSimpleButtonIndexModel indexModel = new SkinSimpleButtonIndexModel(0, 1, 2, 4);
    static Skin[] skins = new Skin[4];
    boolean isRestore = true;
    int type;

    LiquidWindowButtonUI(int type) {
        this.type = type;
    }

    public static ComponentUI createUI(JComponent c) {
        throw new IllegalStateException("Must not be used this way.");
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    public void paint(Graphics g, JComponent c) {
        SpecialUIButton button = (SpecialUIButton)c;
        indexModel.setButton(button);
        int index = indexModel.getIndexForState();
        if (button.frame != null) {
            if (LiquidLookAndFeel.winDecoPanther && !button.frame.isSelected() && index == 0) {
                index = 1;
            }
            if (button.frame.isMaximum() && this.type == 1) {
                LiquidWindowButtonUI.getSkin(3).draw(g, index, button.getWidth(), button.getHeight());
            } else {
                LiquidWindowButtonUI.getSkin(this.type).draw(g, index, button.getWidth(), button.getHeight());
            }
        } else {
            if (LiquidLookAndFeel.winDecoPanther && !button.window.isActive() && index == 0) {
                index = 1;
            }
            LiquidWindowButtonUI.getSkin(this.type).draw(g, index, button.getWidth(), button.getHeight());
        }
    }

    protected static Skin getSkin(int type) {
        if (skins[type] == null) {
            LiquidWindowButtonUI.skins[type] = LiquidLookAndFeel.winDecoPanther ? new Skin(pantherFiles[type], 5, 2) : new Skin(files[type], 5, 2);
        }
        return skins[type];
    }

    public static LiquidWindowButtonUI createButtonUIForType(int type) {
        return new LiquidWindowButtonUI(type);
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(LiquidWindowButtonUI.getSkin(this.type).getHsize(), LiquidWindowButtonUI.getSkin(this.type).getVsize());
    }
}

