/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidInternalFrameBorder;
import com.birosoft.liquid.borders.LiquidFocusCellHighlightBorder;
import com.birosoft.liquid.borders.LiquidFrameBorder;
import com.birosoft.liquid.borders.LiquidListBorder;
import com.birosoft.liquid.borders.LiquidPopupMenuBorder;
import com.birosoft.liquid.borders.LiquidTextFieldBorder;
import com.birosoft.liquid.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class LiquidLookAndFeel
extends BasicLookAndFeel {
    protected static UIDefaults uiDefaults;
    protected static boolean defaultRowBackgroundMode;
    protected static boolean showTableGrids;
    protected static boolean panelTransparency;
    private static boolean bgStipples;
    protected static boolean winDecoPanther;
    protected static boolean toobarFlattedButtons;
    private static boolean isInstalled;
    protected Toolkit awtToolkit = Toolkit.getDefaultToolkit();
    private HashMap colorMap = new HashMap();
    Border focusCellHighlightBorder = new LiquidFocusCellHighlightBorder(new Color(86, 46, 0));
    Border listBorder = new LiquidListBorder();
    Border zeroEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    Object fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
    Object multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
    Object formattedInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"});
    private boolean windowslfforfilechooser = false;

    public LiquidLookAndFeel() {
        if (!isInstalled) {
            isInstalled = true;
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("LiquidLookAndFeel", "com.birosoft.liquid.LiquidLookAndFeel"));
        }
    }

    public String getID() {
        return "Liquid";
    }

    public String getName() {
        return "Liquid";
    }

    public static ColorUIResource getControl() {
        return (ColorUIResource)uiDefaults.get("control");
    }

    public String getDescription() {
        return "Mosfet's KDE 3.x Liquid look and feel for Java.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public final boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        uiDefaults = table;
        super.initClassDefaults(table);
        Properties liquidProps = new Properties();
        try {
            boolean isFlatted;
            boolean isPanther;
            FileInputStream in = new FileInputStream("liquidlnf.conf");
            liquidProps.load(in);
            in.close();
            boolean isPanelTransparent = Boolean.valueOf(liquidProps.get("panelTransparency").toString());
            LiquidLookAndFeel.setPanelTransparency(isPanelTransparent);
            boolean isGridsShowed = Boolean.valueOf(liquidProps.get("showTableGrids").toString());
            LiquidLookAndFeel.setShowTableGrids(isGridsShowed);
            boolean doStipples = Boolean.valueOf(liquidProps.get("stipples").toString());
            LiquidLookAndFeel.setStipples(doStipples);
            boolean altBackground = Boolean.valueOf(liquidProps.get("alternateBackground").toString());
            LiquidLookAndFeel.setShowTableGrids(altBackground);
            winDecoPanther = isPanther = liquidProps.get("windowDecoration").toString().equalsIgnoreCase("panther");
            toobarFlattedButtons = isFlatted = Boolean.valueOf(liquidProps.get("toolbarFlattedButtons").toString()).booleanValue();
        }
        catch (FileNotFoundException fnf) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        table.putDefaults(new Object[]{"ButtonUI", "com.birosoft.liquid.LiquidButtonUI", "CheckBoxUI", "com.birosoft.liquid.LiquidCheckBoxUI", "TextFieldUI", "com.birosoft.liquid.LiquidTextFieldUI", "FormattedTextFieldUI", "com.birosoft.liquid.LiquidTextFieldUI", "PasswordTextFieldUI", "com.birosoft.liquid.LiquidTextFieldUI", "SliderUI", "com.birosoft.liquid.LiquidSliderUI", "SpinnerUI", "com.birosoft.liquid.LiquidSpinnerUI", "ToolBarUI", "com.birosoft.liquid.LiquidToolBarUI", "MenuBarUI", "com.birosoft.liquid.LiquidMenuBarUI", "MenuUI", "com.birosoft.liquid.LiquidMenuUI", "PanelUI", "com.birosoft.liquid.LiquidPanelUI", "MenuItemUI", "com.birosoft.liquid.LiquidMenuItemUI", "CheckBoxMenuItemUI", "com.birosoft.liquid.LiquidCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.birosoft.liquid.LiquidRadioButtonMenuItemUI", "TableUI", "com.birosoft.liquid.LiquidTableUI", "TableHeaderUI", "com.birosoft.liquid.LiquidTableHeaderUI", "ScrollBarUI", "com.birosoft.liquid.LiquidScrollBarUI", "TabbedPaneUI", "com.birosoft.liquid.LiquidTabbedPaneUI", "ToggleButtonUI", "com.birosoft.liquid.LiquidToggleButtonUI", "ScrollPaneUI", "com.birosoft.liquid.LiquidScrollPaneUI", "ProgressBarUI", "com.birosoft.liquid.LiquidProgressBarUI", "InternalFrameUI", "com.birosoft.liquid.LiquidInternalFrameUI", "RadioButtonUI", "com.birosoft.liquid.LiquidRadioButtonUI", "ComboBoxUI", "com.birosoft.liquid.LiquidComboBoxUI", "ListUI", "com.birosoft.liquid.LiquidListUI", "SeparatorUI", "com.birosoft.liquid.LiquidSeparatorUI", "PopupMenuSeparatorUI", "com.birosoft.liquid.LiquidPopupMenuSeparatorUI", "SplitPaneUI", "com.birosoft.liquid.LiquidSplitPaneUI", "FileChooserUI", "com.birosoft.liquid.FileChooserBasicUI", "RootPaneUI", "com.birosoft.liquid.LiquidRootPaneUI", "OptionPaneUI", "com.birosoft.liquid.LiquidOptionPaneUI"});
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        this.colorMap.put("activeBackground", "#3E91EB");
        this.colorMap.put("activeBlend", "#3E91EB");
        this.colorMap.put("activeForeground", "#FFFFFF");
        this.colorMap.put("activeTitleBtnBg", "#AFD6FF");
        this.colorMap.put("alternateBackground", "#EEF6FF");
        this.colorMap.put("background", "#F6F5F4");
        this.colorMap.put("buttonBackground", "#D7E7F9");
        this.colorMap.put("buttonForeground", "#000000");
        this.colorMap.put("foreground", "#000000");
        this.colorMap.put("inactiveBackground", "#AFD6FF");
        this.colorMap.put("inactiveBlend", "#AFD6FF");
        this.colorMap.put("inactiveForeground", "#232323");
        this.colorMap.put("inactiveTitleBtnBg", "#DAEEFF");
        this.colorMap.put("linkColor", "#0000C0");
        this.colorMap.put("selectBackground", "#A9D1FF");
        this.colorMap.put("selectForeground", "#030303");
        this.colorMap.put("visitedLinkColor", "#800080");
        this.colorMap.put("windowBackground", "#FFFFFF");
        this.colorMap.put("windowForeground", "#000000");
        String[] defaultSystemColors = new String[]{"desktop", (String)this.colorMap.get("alternateBackground"), "activeCaption", (String)this.colorMap.get("activeBackground"), "activeCaptionText", (String)this.colorMap.get("activeForeground"), "activeCaptionBorder", (String)this.colorMap.get("activeBackground"), "inactiveCaption", (String)this.colorMap.get("inactiveBackground"), "inactiveCaptionText", (String)this.colorMap.get("inactiveForeground"), "inactiveCaptionBorder", (String)this.colorMap.get("inactiveBackground"), "window", (String)this.colorMap.get("background"), "windowBorder", (String)this.colorMap.get("windowBackground"), "windowText", (String)this.colorMap.get("windowForeground"), "menu", (String)this.colorMap.get("background"), "menuText", (String)this.colorMap.get("foreground"), "text", (String)this.colorMap.get("windowBackground"), "textText", (String)this.colorMap.get("windowForeground"), "textHighlight", (String)this.colorMap.get("selectBackground"), "textHighlightText", (String)this.colorMap.get("selectForeground"), "textInactiveText", "#A7A5A3", "control", (String)this.colorMap.get("background"), "controlText", (String)this.colorMap.get("buttonForeground"), "controlHighlight", (String)this.colorMap.get("buttonBackground"), "controlLtHighlight", (String)this.colorMap.get("selectBackground"), "controlShadow", "#BBBBBB", "controlLightShadow", "#000000", "controlDkShadow", "#000000", "scrollbar", "#000000", "info", (String)this.colorMap.get("foreground"), "infoText", (String)this.colorMap.get("foreground")};
        this.loadSystemColors(table, defaultSystemColors, false);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        AbstractBorder border = new EmptyBorder(0, 0, 0, 0);
        table.put("Button.margin", this.getButtonMargin());
        table.put("Button.border", new BasicBorders.MarginBorder());
        table.put("ToggleButton.margin", this.getButtonMargin());
        table.put("ToggleButton.border", new BasicBorders.MarginBorder());
        table.put("ToggleButton.background", table.get("window"));
        table.put("TextField.border", new LiquidTextFieldBorder());
        table.put("PasswordField.border", new LiquidTextFieldBorder());
        table.put("Spinner.border", new LiquidTextFieldBorder(new Insets(2, 2, 2, 2)));
        table.put("ToolBar.background", table.get("window"));
        table.put("MenuBar.background", table.get("window"));
        border = new EmptyBorder(2, 2, 2, 2);
        table.put("InternalFrame.border", border);
        table.put("InternalFrame.paletteBorder", border);
        table.put("InternalFrame.optionDialogBorder", new LiquidInternalFrameBorder());
        border = new EmptyBorder(3, 1, 3, 1);
        table.put("Menu.border", border);
        table.put("MenuItem.border", border);
        table.put("CheckBoxMenuItem.border", border);
        table.put("RadioButtonMenuItem.border", border);
        table.put("CheckBoxMenuItem.checkIcon", LiquidLookAndFeel.loadIcon("menucheck.png", this));
        table.put("CheckBoxMenuItem.checkedIcon", LiquidLookAndFeel.loadIcon("menuchecked.png", this));
        table.put("RadioButtonMenuItem.checkIcon", LiquidLookAndFeel.loadIcon("menuradio.png", this));
        table.put("RadioButtonMenuItem.checkedIcon", LiquidLookAndFeel.loadIcon("menuradio_down.png", this));
        table.put("MenuItem.arrowIcon", LiquidLookAndFeel.loadIcon("menuarrow.png", this));
        table.put("MenuItem.selArrowIcon", LiquidLookAndFeel.loadIcon("menuarrowsel.png", this));
        table.put("Menu.submenuPopupOffsetX", new Integer(-3));
        table.put("Menu.submenuPopupOffsetY", new Integer(4));
        border = new LiquidPopupMenuBorder();
        table.put("PopupMenu.border", border);
        table.put("SplitPane.dividerSize", new Integer(7));
        table.put("InternalFrame.paletteTitleHeight", new Integer(14));
        table.put("InternalFrame.frameTitleHeight", new Integer(24));
        table.put("InternalFrame.normalTitleFont", new Font("Helvetica", 1, 14));
        table.put("Panel.background", table.get("window"));
        table.put("TabbedPane.selectedTabPadInsets", new Insets(1, 1, 1, 1));
        table.put("TabbedPane.tabAreaInsets", new Insets(4, 2, 0, 0));
        table.put("TabbedPane.contentBorderInsets", new Insets(5, 0, 0, 0));
        table.put("TabbedPane.unselected", table.get("shadow"));
        table.put("Checkbox.select", table.get("shadow"));
        table.put("PopupMenu.background", table.get("window"));
        table.put("PopupMenu.foreground", Color.black);
        table.put("TextField.selectionForeground", table.get("textHighlightText"));
        table.put("TextField.selectionBackground", table.get("textHighlight"));
        table.put("TextField.background", table.get("text"));
        table.put("TextField.disabledBackground", table.get("window"));
        table.put("TextField.focusInputMap", this.fieldInputMap);
        table.put("PasswordField.focusInputMap", this.fieldInputMap);
        table.put("TextArea.focusInputMap", this.multilineInputMap);
        table.put("TextPane.focusInputMap", this.multilineInputMap);
        table.put("TextPane.background", table.get("text"));
        table.put("EditorPane.focusInputMap", this.multilineInputMap);
        table.put("FormattedTextField.focusInputMap", this.formattedInputMap);
        table.put("List.background", table.get("text"));
        table.put("List.border", this.zeroEmptyBorder);
        table.put("List.selectionForeground", table.get("textHighlightText"));
        table.put("List.selectionBackground", table.get("textHighlight"));
        table.put("List.focusCellHighlightBorder", this.focusCellHighlightBorder);
        table.put("ScrollPane.border", this.listBorder);
        table.put("ComboBox.border", new EmptyBorder(1, 1, 1, 1));
        table.put("ComboBox.foreground", table.get("textHighlightText"));
        table.put("ComboBox.background", table.get("text"));
        table.put("ComboBox.selectionForeground", table.get("textHighlightText"));
        table.put("ComboBox.selectionBackground", table.get("textHighlight"));
        table.put("ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "ENTER", "enterPressed"}));
        table.put("InternalFrame.paletteCloseIcon", LiquidLookAndFeel.loadIcon("closebutton.png", this));
        table.put("InternalFrame.closeIcon", LiquidLookAndFeel.loadWinButtonIcon("close.png", this));
        table.put("InternalFrame.maximizeIcon", LiquidLookAndFeel.loadWinButtonIcon("maximize.png", this));
        table.put("InternalFrame.iconifyIcon", LiquidLookAndFeel.loadWinButtonIcon("minimize.png", this));
        table.put("InternalFrame.minimizeIcon", LiquidLookAndFeel.loadWinButtonIcon("restore.png", this));
        table.put("InternalFrame.frameTitleHeight", new Integer(25));
        table.put("InternalFrame.paletteTitleHeight", new Integer(16));
        table.put("InternalFrame.icon", LiquidLookAndFeel.loadIcon("internalframeicon.png", this));
        table.put("Table.background", table.get("text"));
        table.put("Table.foreground", table.get("controlText"));
        table.put("Table.selectionBackground", table.get("textHighlight"));
        table.put("Table.selectionForeground", table.get("textHighlightText"));
        table.put("Table.focusCellBackground", table.get("textHighlight"));
        table.put("Table.focusCellForeground", table.get("textHighlightText"));
        table.put("Table.focusCellHighlightBorder", this.focusCellHighlightBorder);
        table.put("Table.scrollPaneBorder", this.listBorder);
        table.put("TableHeader.font", new Font("Helvetica", 0, 12));
        table.put("TableHeader.foreground", table.get("textText"));
        table.put("TableHeader.background", table.get("window"));
        table.put("TableHeader.cellBorder", this.zeroEmptyBorder);
        table.put("ToolTip.background", new Color(255, 255, 225));
        table.put("ToolTip.foreground", new Color(0, 0, 0));
        table.put("ToolTip.font", new Font("Helvetica", 0, 12));
        table.put("ToolTip.border", new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
        table.put("Tree.font", new Font("Helvetica", 0, 12));
        table.put("Tree.selectionForeground", table.get("textHighlightText"));
        table.put("Tree.selectionBackground", table.get("textHighlight"));
        table.put("Tree.foreground", table.get("textText"));
        table.put("Tree.background", table.get("text"));
        table.put("Tree.expandedIcon", LiquidLookAndFeel.loadIcon("treeminus.png", this));
        table.put("Tree.collapsedIcon", LiquidLookAndFeel.loadIcon("treeplus.png", this));
        table.put("Tree.openIcon", LiquidLookAndFeel.loadIcon("treefolderopened.png", this));
        table.put("Tree.closedIcon", LiquidLookAndFeel.loadIcon("treefolderclosed.png", this));
        table.put("Tree.leafIcon", LiquidLookAndFeel.loadIcon("treeleaf.png", this));
        table.put("Tree.rowHeight", new Integer(18));
        table.put("Tree.selectionBorderColor", new Color(86, 46, 0));
        table.put("SplitPane.background", table.get("text"));
        table.put("SplitPane.border", this.listBorder);
        table.put("SplitPaneDivider.border", this.zeroEmptyBorder);
        table.put("FileView.directoryIcon", LiquidLookAndFeel.loadIcon("treefolderclosed.png", this));
        table.put("FileView.computerIcon", LiquidLookAndFeel.loadIcon("computericon.png", this));
        table.put("FileView.fileIcon", LiquidLookAndFeel.loadIcon("document.png", this));
        table.put("FileView.floppyDriveIcon", LiquidLookAndFeel.loadIcon("floppy.png", this));
        table.put("FileView.hardDriveIcon", LiquidLookAndFeel.loadIcon("harddisk.png", this));
        table.put("FileChooser.detailsViewIcon", LiquidLookAndFeel.loadIcon("filedetails.png", this));
        table.put("FileChooser.homeFolderIcon", LiquidLookAndFeel.loadIcon("desktopicon.png", this));
        table.put("FileChooser.listViewIcon", LiquidLookAndFeel.loadIcon("filelist.png", this));
        table.put("FileChooser.newFolderIcon", LiquidLookAndFeel.loadIcon("newfolder.png", this));
        table.put("FileChooser.upFolderIcon", LiquidLookAndFeel.loadIcon("parentdirectory.png", this));
        table.put("FileChooser.upFolderIcon", LiquidLookAndFeel.loadIcon("parentdirectory.png", this));
        table.put("OptionPane.errorIcon", LiquidLookAndFeel.loadIcon("error.png", this));
        table.put("OptionPane.informationIcon", LiquidLookAndFeel.loadIcon("information.png", this));
        table.put("OptionPane.warningIcon", LiquidLookAndFeel.loadIcon("warning.png", this));
        table.put("OptionPane.questionIcon", LiquidLookAndFeel.loadIcon("question.png", this));
        table.put("RootPane.colorChooserDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.errorDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.fileChooserDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.frameBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.informationDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.plainDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.questionDialogBorder", LiquidFrameBorder.getInstance());
        table.put("RootPane.warningDialogBorder", LiquidFrameBorder.getInstance());
    }

    public static ImageIcon loadIcon(String file, Object invoker) {
        return LiquidLookAndFeel.loadIconImmediately(file, invoker);
    }

    public static ImageIcon loadWinButtonIcon(String file, Object invoker) {
        if (winDecoPanther) {
            file = "panther-" + file;
        }
        return LiquidLookAndFeel.loadIconImmediately(file, invoker);
    }

    public static ImageIcon loadIconImmediately(String file, Object invoker) {
        try {
            Image img = SkinImageCache.getInstance().getImage(file);
            ImageIcon icon = new ImageIcon(img);
            if (icon.getIconWidth() <= 0) {
                System.out.println("******************** File " + file + " not found. Exiting");
                System.exit(1);
            }
            return icon;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error getting resource " + file);
            return null;
        }
    }

    private InsetsUIResource getButtonMargin() {
        int screenResolution = this.awtToolkit.getScreenResolution();
        if (screenResolution < 96) {
            return new InsetsUIResource(2, 18, 2, 18);
        }
        return new InsetsUIResource(4, 18, 4, 18);
    }

    public static Color getLightControl() {
        return (Color)uiDefaults.get("control");
    }

    public static Color getDarkControl() {
        return new Color(127, 127, 127);
    }

    public static Color getBackgroundColor() {
        return (Color)uiDefaults.get("window");
    }

    public static Color getDesktopColor() {
        return (Color)uiDefaults.get("desktop");
    }

    protected static Color getWindowTitleInactiveForeground() {
        return (Color)uiDefaults.get("inactiveCaptionText");
    }

    public static Color getWindowBackground() {
        return (Color)uiDefaults.get("window");
    }

    public static Color getButtonBackground() {
        return (Color)uiDefaults.get("controlHighlight");
    }

    public static void setDefaultTableBackgroundMode(boolean b) {
        LiquidLookAndFeel.setDefaultRowBackgroundMode(b);
    }

    public static void setDefaultRowBackgroundMode(boolean b) {
        defaultRowBackgroundMode = b;
        if (!b) {
            showTableGrids = true;
        }
    }

    public static void setLiquidDecorations(boolean b) {
        JFrame.setDefaultLookAndFeelDecorated(b);
        JDialog.setDefaultLookAndFeelDecorated(b);
    }

    protected static boolean areStipplesUsed() {
        return bgStipples;
    }

    public static void setStipples(boolean b) {
        bgStipples = b;
    }

    protected static boolean isShowTableGrids() {
        return showTableGrids;
    }

    public static void setShowTableGrids(boolean showTableGrids) {
        LiquidLookAndFeel.showTableGrids = showTableGrids;
    }

    public static void setPanelTransparency(boolean autoTransparency) {
        panelTransparency = autoTransparency;
    }

    public static void setToobarFlattedButtons(boolean flatedButtons) {
        toobarFlattedButtons = flatedButtons;
    }

    static {
        defaultRowBackgroundMode = true;
        showTableGrids = false;
        panelTransparency = true;
        bgStipples = true;
        winDecoPanther = false;
        toobarFlattedButtons = true;
        isInstalled = false;
    }
}

