/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils;

import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import ants.p2p.utils.FileInfos;
import java.io.Serializable;

public class RemoteFileInfos
implements Serializable {
    String extendedInfos;
    String hash;
    long lastTimeSeen = 0L;
    private final boolean marker = false;
    String name;
    long size;

    public RemoteFileInfos(QueryFileTuple qft) {
        if (!(qft instanceof QueryRemoteFileTuple)) {
            this.lastTimeSeen = System.currentTimeMillis();
            this.extendedInfos = qft.getExtendedInfos();
        } else {
            QueryRemoteFileTuple qrft = (QueryRemoteFileTuple)qft;
            this.lastTimeSeen = qrft.getlastTimeSeen();
            this.extendedInfos = qft.getExtendedInfos();
        }
        this.hash = qft.getFileHash();
        this.name = qft.getFileName();
        this.size = qft.getSize();
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteFileInfos) {
            return ((RemoteFileInfos)o).hash.equals(this.hash);
        }
        if (o instanceof FileInfos) {
            return ((FileInfos)o).hash.equals(this.hash);
        }
        if (o instanceof String) {
            return ((String)o).equals(this.hash);
        }
        return this == o;
    }

    public String getExtendedInfos() {
        return this.extendedInfos;
    }

    public String getHash() {
        return this.hash;
    }

    public long getLastTimeSeen() {
        return this.lastTimeSeen;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }
}

