/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils;

import ants.p2p.query.FileTupleGroup;
import ants.p2p.utils.DigestManager;
import helliker.id3.MP3File;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class FileInfos
implements Serializable {
    String hash;
    long lastModified;
    MP3File mp3File = null;
    String name;
    long size;

    public FileInfos(File f) throws Exception {
        if (!f.exists()) {
            throw new IOException("File not exists.");
        }
        this.name = f.getAbsolutePath();
        DigestManager dm = new DigestManager();
        this.hash = dm.getDigest(f);
        this.lastModified = f.lastModified();
        this.size = f.length();
        try {
            this.mp3File = new MP3File(this.name);
            if (!this.mp3File.isMP3()) {
                this.mp3File = null;
            }
        }
        catch (Exception e) {
        }
    }

    public boolean equals(Object o) {
        if (o instanceof FileInfos) {
            return ((FileInfos)o).hash.equals(this.hash);
        }
        if (o instanceof String) {
            return ((String)o).equals(this.hash);
        }
        return this == o;
    }

    public String getAlbum() throws Exception {
        return this.mp3File.getAlbum();
    }

    public String getArtist() throws Exception {
        return this.mp3File.getArtist();
    }

    public int getBitrate() throws Exception {
        return this.mp3File.getBitRate();
    }

    public String getExtendedInfos() {
        try {
            return "[MP3 Bitrate: " + this.getBitrate() + " - Length: " + this.getPlayingTimeString() + " - Artist: " + this.getArtist() + " - Album: " + this.getAlbum() + " - Year: " + this.getYear() + "]";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getHash() {
        return this.hash;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getPlayingTimeString() throws Exception {
        return this.mp3File.getPlayingTimeString();
    }

    public long getSize() {
        return this.size;
    }

    public String getYear() throws Exception {
        return this.mp3File.getYear();
    }

    public boolean isMP3() {
        try {
            return this.mp3File.isMP3();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        int index;
        String result = this.getHash() + "  ";
        double dSize = this.getSize();
        int x = 0;
        while (dSize > 1.0 && x < 4) {
            dSize /= Math.pow(2.0, 20.0);
            ++x;
        }
        String suffix = " bytes";
        String size = this.getSize() + suffix;
        if (x == 2) {
            suffix = " Mb";
            size = new Double((double)this.getSize() * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gb";
            size = new Double((double)this.getSize() * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        result = result + " File Size: " + size;
        while (result.length() < 65) {
            result = result + " ";
        }
        int mark = result.length();
        if (this.getName().length() < FileTupleGroup.maxNameLengthToDisplay) {
            result = result + " " + this.getName();
            while (result.length() < mark + FileTupleGroup.maxNameLengthToDisplay) {
                result = result + " ";
            }
        } else {
            result = result + " " + this.getName().substring(0, FileTupleGroup.maxNameLengthToDisplay - 1);
        }
        result = result + " " + this.getExtendedInfos();
        return result;
    }
}

