/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.utils;

import ants.p2p.utils.Base16;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;

public class DigestManager {
    byte[] digest;
    File f;
    public static final String hashName = "MD5";
    private static final int megaByte = (int)Math.pow(2.0, 20.0);
    static ArrayList propertyChangeListeners;
    public PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    static long sizeToHash;

    static {
        sizeToHash = 5 * megaByte;
        propertyChangeListeners = new ArrayList();
    }

    public DigestManager() {
        int x = 0;
        while (x < propertyChangeListeners.size()) {
            this.propertyChangeSupport.addPropertyChangeListener((PropertyChangeListener)propertyChangeListeners.get(x));
            ++x;
        }
    }

    static void addPropertyChangeListener(PropertyChangeListener pcl) {
        propertyChangeListeners.add(pcl);
    }

    private byte[] computeDigest(File f) throws Exception {
        this.f = f;
        MessageDigest md = MessageDigest.getInstance(hashName);
        FileInputStream fis = new FileInputStream(f);
        long index = 0L;
        this.propertyChangeSupport.firePropertyChange("fileIndexingInProgress", f.getName(), new Integer(0));
        while (fis.available() > 0) {
            byte[] block = fis.available() >= 10 * megaByte ? new byte[10 * megaByte] : new byte[fis.available()];
            md.update(block);
            int progress = (int)Math.floor((double)(index += (long)fis.read(block)) * 1.0 / (double)f.length() * 100.0);
            this.propertyChangeSupport.firePropertyChange("fileIndexingInProgress", f.getName(), new Integer(progress));
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        this.digest = md.digest();
        return this.digest;
    }

    public String getDigest(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance(hashName);
        md.update(s.getBytes());
        byte[] dig = md.digest();
        return Base16.toHexString(dig);
    }

    public String getDigest(File f) throws Exception {
        if (this.digest != null && f.equals(f)) {
            return Base16.toHexString(this.digest);
        }
        this.computeDigest(f);
        return Base16.toHexString(this.digest);
    }

    static void removePropertyChangeListener(PropertyChangeListener pcl) {
        propertyChangeListeners.remove(pcl);
    }
}

