/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.Ant;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class SecureServerSocketThread {
    public static final int DHKeyExchangeBits = 512;
    static Logger _logger = Logger.getLogger((class$ants$p2p$security$sockets$SecureServerSocketThread == null ? (class$ants$p2p$security$sockets$SecureServerSocketThread = SecureServerSocketThread.class$("ants.p2p.security.sockets.SecureServerSocketThread")) : class$ants$p2p$security$sockets$SecureServerSocketThread).getName());
    byte[] aesKey;
    public static final String cipher = "AES";
    public static final int cipherKeySize = 16;
    CipherInputStream cipherSocketInputStream;
    CipherOutputStream cipherSocketOutputStream;
    static /* synthetic */ Class class$ants$p2p$security$sockets$SecureServerSocketThread;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;
    PublicKey clientPubKey;
    DHParameterSpec dhParamSpec;
    Socket localSocket;
    boolean newVersionDetected = false;
    String newerVersion = Ant.getVersion();
    int packetSize = 32768;
    int remoteServerPort;
    Cipher serverCipherDec;
    Cipher serverCipherEnc;
    KeyAgreement serverKeyAgree;
    KeyPair serverKpair;
    PublicKey serverPubKey;
    byte[] sharedSecret;
    private BigInteger skip1024Base;
    private BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    InputStream socketInputStream;
    OutputStream socketOutputStream;
    long timeElapsed;

    public SecureServerSocketThread(Socket localSocket) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.skip1024Base = BigInteger.valueOf(2L);
        this.localSocket = localSocket;
        this.localSocket.setSoTimeout(60000);
        this.run();
        if (!this.localSocket.isClosed()) {
            this.localSocket.setSoTimeout(0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void generateDHParameters() throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
        paramGen.init(512);
        AlgorithmParameters params = paramGen.generateParameters();
        this.dhParamSpec = (DHParameterSpec)params.getParameterSpec(class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = SecureServerSocketThread.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec);
        KeyPairGenerator serverKpairGen = KeyPairGenerator.getInstance("DH");
        serverKpairGen.initialize(this.dhParamSpec);
        this.serverKpair = serverKpairGen.generateKeyPair();
        this.serverKeyAgree = KeyAgreement.getInstance("DH");
        this.serverKeyAgree.init(this.serverKpair.getPrivate());
        this.serverPubKey = this.serverKpair.getPublic();
    }

    public Cipher getCipherDec() {
        return this.serverCipherDec;
    }

    public Cipher getCipherEnc() {
        return this.serverCipherEnc;
    }

    public String getNewerVersion() {
        return this.newerVersion;
    }

    public int getRemoteServerPort() {
        return this.remoteServerPort;
    }

    public Socket getSocket() {
        return this.localSocket;
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public boolean isNewVersionDetected() {
        return this.newVersionDetected;
    }

    public void run() {
        try {
            this.generateDHParameters();
            this.serverCipherEnc = Cipher.getInstance(cipher);
            this.serverCipherDec = Cipher.getInstance(cipher);
            this.socketInputStream = this.localSocket.getInputStream();
            this.socketOutputStream = this.localSocket.getOutputStream();
            ObjectOutputStream keyAgreementOutStream = new ObjectOutputStream(this.socketOutputStream);
            ObjectInputStream keyAgreementInStream = new ObjectInputStream(this.socketInputStream);
            String version = (String)keyAgreementInStream.readObject();
            if (!version.equals(Ant.getVersion())) {
                this.localSocket.close();
                if (version.compareTo(Ant.getVersion()) > 0) {
                    this.newVersionDetected = true;
                    this.newerVersion = version;
                }
                return;
            }
            this.remoteServerPort = keyAgreementInStream.readInt();
            long startProbe = System.currentTimeMillis();
            int read = 0;
            while (read < this.packetSize) {
                read += keyAgreementInStream.read(new byte[this.packetSize]);
            }
            this.timeElapsed = System.currentTimeMillis() - startProbe;
            keyAgreementOutStream.write(new byte[this.packetSize]);
            keyAgreementOutStream.writeObject(this.dhParamSpec.getG());
            keyAgreementOutStream.writeObject(this.dhParamSpec.getP());
            keyAgreementOutStream.writeObject(this.serverPubKey);
            keyAgreementOutStream.flush();
            this.clientPubKey = (PublicKey)keyAgreementInStream.readObject();
            KeyFactory serverKeyFac = KeyFactory.getInstance("DH");
            this.serverKeyAgree.doPhase(this.clientPubKey, true);
            this.sharedSecret = this.serverKeyAgree.generateSecret();
            this.aesKey = new byte[16];
            int x = 0;
            while (x < this.aesKey.length) {
                this.aesKey[x] = this.sharedSecret[x];
                ++x;
            }
            SecretKeySpec serverKeySpec = new SecretKeySpec(this.aesKey, cipher);
            this.serverCipherEnc.init(1, serverKeySpec);
            this.serverCipherDec.init(2, serverKeySpec);
        }
        catch (Exception e) {
            try {
                this.localSocket.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            _logger.info("Secure server connection failed with: " + this.localSocket.getInetAddress() + ":" + this.localSocket.getPort() + " " + e.getMessage());
            _logger.debug("Secure server connection failed", e);
        }
    }
}

