/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.Ant;
import ants.p2p.NeighbourAnt;
import ants.p2p.security.sockets.SecureServerSocketThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import org.apache.log4j.Logger;

public class SecureServerSocket
extends ServerSocket
implements Runnable {
    static Logger _logger = Logger.getLogger((class$ants$p2p$security$sockets$SecureServerSocket == null ? (class$ants$p2p$security$sockets$SecureServerSocket = SecureServerSocket.class$("ants.p2p.security.sockets.SecureServerSocket")) : class$ants$p2p$security$sockets$SecureServerSocket).getName());
    static /* synthetic */ Class class$ants$p2p$security$sockets$SecureServerSocket;
    DHParameterSpec dhParamSpec;
    Ant n;
    KeyAgreement serverKeyAgree;
    KeyPair serverKpair;
    byte[] serverPubKeyEnc;
    public Thread serverThread;
    public ArrayList threads = new ArrayList();

    public SecureServerSocket(Ant n) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        super(4000);
        this.n = n;
        this.serverThread = new Thread(this);
        this.serverThread.setPriority(1);
        this.serverThread.start();
    }

    public SecureServerSocket(Ant n, int port, int backlog) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        super(port, backlog);
        this.n = n;
        this.serverThread = new Thread(this);
        this.serverThread.setPriority(1);
        this.serverThread.start();
    }

    public SecureServerSocket(Ant n, int port) throws IOException {
        super(port);
        this.n = n;
        try {
            this.serverThread = new Thread(this);
            this.serverThread.setPriority(1);
            this.serverThread.start();
        }
        catch (Exception e) {
            _logger.error("", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void listen() {
        while (!this.n.isDisconnected() && !this.isClosed()) {
            try {
                _logger.info(this.n.getId() + " :Server Listening...");
                Socket localSocket = this.accept();
                if (localSocket == null) continue;
                if (this.n.getNeighboursNumber() < this.n.getMaxNeighbours()) {
                    localSocket.setKeepAlive(true);
                    SecureServerSocketThread serverSocketThread = new SecureServerSocketThread(localSocket);
                    if (!localSocket.isClosed()) {
                        SecureServerSocket secureServerSocket = this;
                        _logger.info(this.getInetAddress().getHostAddress() + ": Local time elapsed: " + serverSocketThread.getTimeElapsed() + "[Thresold: " + secureServerSocket.n.getRateThresold() + "]");
                        if ((double)this.n.getUnderRatedNeighbours() >= Math.floor((double)Ant.maxNeighbours * Ant.underRateConnections)) {
                            SecureServerSocket secureServerSocket2 = this;
                            if (serverSocketThread.getTimeElapsed() >= (long)secureServerSocket2.n.getRateThresold()) {
                                throw new Exception(this.getInetAddress().getHostAddress() + ": Rejected neighbour cause it doesn't satisfy bandwith request: [" + this.n.getUnderRatedNeighbours() + "/" + Math.floor((double)Ant.maxNeighbours * Ant.underRateConnections) + "]");
                            }
                        }
                        NeighbourAnt na = new NeighbourAnt(this.n, localSocket.getInetAddress() + "", localSocket.getPort(), serverSocketThread.getRemoteServerPort(), serverSocketThread.getCipherEnc(), serverSocketThread.getCipherDec(), serverSocketThread.getSocket(), false, serverSocketThread.getTimeElapsed());
                        try {
                            this.n.addNeighbour(na);
                        }
                        catch (Exception e) {
                            na.terminate();
                            throw new Exception(e);
                        }
                        _logger.info(this.n.getId() + " :Server added neighbour...");
                        continue;
                    }
                    if (serverSocketThread.isNewVersionDetected()) {
                        this.n.getPropertyChangeSupport().firePropertyChange("newANtsVersionDetected", null, serverSocketThread.getNewerVersion());
                    }
                    _logger.info(this.n.getId() + " :Rejected connection...");
                    continue;
                }
                localSocket.close();
                _logger.info(this.n.getId() + " :Rejected neighbour...");
            }
            catch (Exception e) {
                _logger.error("Secure Server Socket listen cycle: " + this.getLocalPort() + " ", e);
            }
        }
        _logger.info("Secure Server Socket closed: " + this.getLocalPort());
    }

    private void loadDHParameter() {
    }

    public void run() {
        this.listen();
    }
}

