/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.Ant;
import ants.p2p.security.sockets.SecureClientSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class SecureClientSocketThread {
    public static final int DHKeyExchangeBits = 512;
    public static final int MinDHKeyExchangeBits = 512;
    static Logger _logger = Logger.getLogger((class$ants$p2p$security$sockets$SecureClientSocketThread == null ? (class$ants$p2p$security$sockets$SecureClientSocketThread = SecureClientSocketThread.class$("ants.p2p.security.sockets.SecureClientSocketThread")) : class$ants$p2p$security$sockets$SecureClientSocketThread).getName());
    byte[] aesKey;
    public static final String cipher = "AES";
    public static final int cipherKeySize = 16;
    CipherInputStream cipherSocketInputStream;
    CipherOutputStream cipherSocketOutputStream;
    static /* synthetic */ Class class$ants$p2p$security$sockets$SecureClientSocketThread;
    Cipher clientCipherDec;
    Cipher clientCipherEnc;
    KeyAgreement clientKeyAgree;
    KeyPair clientKpair;
    PublicKey clientPubKey;
    DHParameterSpec dhParamSpec;
    SecureClientSocket localSocket;
    int packetSize = 32768;
    PublicKey serverPubKey;
    byte[] sharedSecret;
    private BigInteger skip1024Base;
    private BigInteger skip1024Modulus = new BigInteger(1, skip1024ModulusBytes);
    private static final byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    InputStream socketInputStream;
    OutputStream socketOutputStream;
    long timeElapsed;

    public SecureClientSocketThread(SecureClientSocket localSocket) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.skip1024Base = BigInteger.valueOf(2L);
        this.localSocket = localSocket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void generateDHParameters() throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        if (this.skip1024Modulus.bitLength() < 512) {
            throw new InvalidAlgorithmParameterException("Security Error: key size < 512");
        }
        this.dhParamSpec = new DHParameterSpec(this.skip1024Modulus, this.skip1024Base);
        KeyPairGenerator clientKpairGen = KeyPairGenerator.getInstance("DH");
        clientKpairGen.initialize(this.dhParamSpec);
        this.clientKpair = clientKpairGen.generateKeyPair();
        this.clientKeyAgree = KeyAgreement.getInstance("DH");
        this.clientKeyAgree.init(this.clientKpair.getPrivate());
        this.clientPubKey = this.clientKpair.getPublic();
    }

    public Cipher getCipherDec() {
        return this.clientCipherDec;
    }

    public Cipher getCipherEnc() {
        return this.clientCipherEnc;
    }

    public Socket getSocket() {
        return this.localSocket;
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    public void run() {
        try {
            _logger.info("Client is Accepting...");
            this.clientCipherEnc = Cipher.getInstance(cipher);
            this.clientCipherDec = Cipher.getInstance(cipher);
            this.socketInputStream = this.localSocket.getInputStream();
            this.socketOutputStream = this.localSocket.getOutputStream();
            ObjectOutputStream keyAgreementOutStream = new ObjectOutputStream(this.socketOutputStream);
            ObjectInputStream keyAgreementInStream = new ObjectInputStream(this.socketInputStream);
            keyAgreementOutStream.writeObject(Ant.getVersion());
            keyAgreementOutStream.writeInt(this.localSocket.getLocalServerPort());
            keyAgreementOutStream.write(new byte[this.packetSize]);
            keyAgreementOutStream.flush();
            long startProbe = System.currentTimeMillis();
            int read = 0;
            while (read < this.packetSize) {
                read += keyAgreementInStream.read(new byte[this.packetSize]);
            }
            this.timeElapsed = System.currentTimeMillis() - startProbe;
            this.skip1024Base = (BigInteger)keyAgreementInStream.readObject();
            this.skip1024Modulus = (BigInteger)keyAgreementInStream.readObject();
            this.generateDHParameters();
            this.serverPubKey = (PublicKey)keyAgreementInStream.readObject();
            keyAgreementOutStream.writeObject(this.clientPubKey);
            keyAgreementOutStream.flush();
            KeyFactory clientKeyFac = KeyFactory.getInstance("DH");
            this.clientKeyAgree.doPhase(this.serverPubKey, true);
            this.sharedSecret = this.clientKeyAgree.generateSecret();
            this.aesKey = new byte[16];
            int x = 0;
            while (x < this.aesKey.length) {
                this.aesKey[x] = this.sharedSecret[x];
                ++x;
            }
            SecretKeySpec clientKeySpec = new SecretKeySpec(this.aesKey, cipher);
            this.clientCipherEnc.init(1, clientKeySpec);
            this.clientCipherDec.init(2, clientKeySpec);
            _logger.info("Neighbourg accepted.");
        }
        catch (Exception e) {
            try {
                this.localSocket.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            _logger.info("Failed secure connection with " + this.localSocket.getInetAddress() + ":" + this.localSocket.getPort() + " :" + e.getMessage());
            _logger.debug("Failed secure connection ", e);
        }
    }
}

