/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.security.sockets;

import ants.p2p.security.sockets.SecureClientSocketThread;
import java.net.InetAddress;
import java.net.Socket;
import javax.crypto.Cipher;

public class SecureClientSocket
extends Socket {
    int localServerPort;
    SecureClientSocketThread localThread;

    public SecureClientSocket(String remoteAddress, int remotePort, int localServerPort) throws Exception {
        super(InetAddress.getByName(remoteAddress), remotePort);
        this.setKeepAlive(true);
        this.setSoTimeout(60000);
        this.localServerPort = localServerPort;
        this.localThread = new SecureClientSocketThread(this);
        this.localThread.run();
        if (!this.isClosed()) {
            this.setSoTimeout(0);
        }
    }

    public Cipher getCipherDec() {
        return this.localThread.getCipherDec();
    }

    public Cipher getCipherEnc() {
        return this.localThread.getCipherEnc();
    }

    public int getLocalServerPort() {
        return this.localServerPort;
    }

    public long getTimeElapsed() {
        return this.localThread.getTimeElapsed();
    }
}

