/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query.security;

import ants.p2p.utils.Base16;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class PublicHeader
implements Serializable {
    String E = null;
    String binaryblocks;
    String characterbinary;
    String characternumbers = new String("ASCII representation");
    String codeblocks;
    String encryptedSessionKey = null;
    String encryptedmessage;
    String encryptednumbers;
    String pq = null;
    String s8;
    String sessionKey = null;

    PublicHeader() {
        this.characterbinary = new String("binary representation");
        this.encryptednumbers = new String("encrypted numbers");
        this.encryptedmessage = new String("Ciphertext");
        this.binaryblocks = new String("binary blocks");
        this.codeblocks = new String("code blocks");
        this.s8 = new String("");
    }

    public PublicHeader(String pq, String E) {
        this.characterbinary = new String("binary representation");
        this.encryptednumbers = new String("encrypted numbers");
        this.encryptedmessage = new String("Ciphertext");
        this.binaryblocks = new String("binary blocks");
        this.codeblocks = new String("code blocks");
        this.s8 = new String("");
        this.pq = pq;
        this.E = E;
    }

    public void encryptSessionKey() {
        this.encryptedSessionKey = this.generate();
    }

    private String generate() {
        String mymessage = this.sessionKey;
        BigInteger biginteger6 = new BigInteger(this.getE());
        BigInteger biginteger8 = new BigInteger(this.getPQ());
        this.characterbinary = "";
        this.characternumbers = "";
        this.encryptednumbers = "";
        this.encryptedmessage = "";
        this.binaryblocks = "";
        this.codeblocks = "";
        int k = 0;
        int byte0 = 2;
        int i = 0;
        while (i < mymessage.length()) {
            String s7 = mymessage;
            String s6 = s7.substring(i, i + 1);
            char c = s7.charAt(i);
            String s = Integer.toBinaryString(c);
            int l = s.length();
            while (l < 8) {
                s = "0" + s;
                ++l;
            }
            String s5 = new Integer(c).toString();
            this.characternumbers = this.characternumbers + s5 + "  ";
            this.characterbinary = this.characterbinary + s + " ";
            this.s8 = this.s8 + s;
            if (++k == byte0) {
                this.binaryblocks = this.binaryblocks + this.s8 + "   ";
                BigInteger biginteger10 = new BigInteger(this.s8, 2);
                this.codeblocks = this.codeblocks + biginteger10.toString() + "  ";
                BigInteger biginteger13 = biginteger10.modPow(biginteger6, biginteger8);
                String s2 = biginteger13.toString();
                this.encryptednumbers = this.encryptednumbers + s2 + " ";
                int i1 = 0;
                while (i1 < s2.length()) {
                    int byte1 = s2.length() - i1 > 1 ? 2 : 1;
                    Integer integer = new Integer(s2.substring(i1, i1 + byte1));
                    char c1 = (char)integer.intValue();
                    this.encryptedmessage = this.encryptedmessage + c1;
                    i1 += 2;
                }
                k = 0;
                this.s8 = "";
            }
            ++i;
        }
        if (k > 0 && k < byte0) {
            int j1 = k;
            while (j1 < byte0) {
                this.s8 = "00000000" + this.s8;
                ++j1;
            }
            this.binaryblocks = this.binaryblocks + this.s8 + "   ";
            BigInteger biginteger11 = new BigInteger(this.s8, 2);
            this.codeblocks = this.codeblocks + biginteger11.toString() + "  ";
            BigInteger biginteger14 = biginteger11.modPow(biginteger6, biginteger8);
            String s3 = biginteger14.toString();
            this.encryptednumbers = this.encryptednumbers + s3 + " ";
            int k1 = 0;
            while (k1 < s3.length()) {
                int byte2 = s3.length() - k1 > 1 ? 2 : 1;
                Integer integer1 = new Integer(s3.substring(k1, k1 + byte2));
                char c2 = (char)integer1.intValue();
                this.encryptedmessage = this.encryptedmessage + c2;
                k1 += 2;
            }
        }
        return this.encryptednumbers;
    }

    public void generateSessionKey() {
        byte[] sessionBytes = new byte[16];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(sessionBytes);
        int x = 0;
        while (x < sessionBytes.length) {
            if (sessionBytes[x] < 0) {
                sessionBytes[x] = (byte)Math.abs(sessionBytes[x]);
            }
            ++x;
        }
        this.sessionKey = Base16.toHexString(sessionBytes);
        this.encryptSessionKey();
    }

    public String getBase16SessionKey() {
        return this.sessionKey;
    }

    public String getE() {
        return this.E;
    }

    public Cipher getEncCipher() throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(Base16.fromHexString(this.sessionKey), "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        return cipher;
    }

    public String getEncryptedSessionKey() {
        return this.encryptedSessionKey;
    }

    public String getPQ() {
        return this.pq;
    }

    public void invalidateSessionKey() {
        this.sessionKey = null;
    }
}

