/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.Message;
import ants.p2p.query.QueryNode;
import ants.p2p.query.security.PublicHeader;
import java.util.ArrayList;

public class QueryMessage
extends Message {
    private static long localQueryIDCounter = 0L;
    long localQueryId;
    PublicHeader ph;
    boolean processed = false;
    QueryNode query;
    ArrayList tuples;

    public QueryMessage(QueryNode query, long timeToLive, PublicHeader ph) {
        this.ttl = timeToLive;
        this.tuples = new ArrayList();
        this.ph = ph;
        this.query = query;
        this.localQueryId = QueryMessage.nextLocalQueryID();
    }

    public QueryMessage(QueryMessage qm) {
        super(qm);
        this.tuples = new ArrayList();
        this.ph = qm.ph;
        this.query = qm.query;
        this.localQueryId = qm.localQueryId;
    }

    public QueryMessage(Message m, QueryNode query, PublicHeader ph) {
        super(m);
        this.tuples = new ArrayList();
        this.ph = ph;
        this.query = query;
        this.localQueryId = QueryMessage.nextLocalQueryID();
    }

    public long getLocalQueryId() {
        return this.localQueryId;
    }

    public boolean getProcessed() {
        return this.processed;
    }

    public PublicHeader getPublicHeader() {
        return this.ph;
    }

    public QueryNode getQuery() {
        return this.query;
    }

    public ArrayList getTuples() {
        return this.tuples;
    }

    public static long nextLocalQueryID() {
        return localQueryIDCounter++;
    }

    public void resetTuples() {
        this.tuples = new ArrayList();
    }

    public void setProcessed() {
        this.processed = true;
    }
}

