/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.query.FileTupleGroup;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import java.io.Serializable;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;

public class QueryCompletedFileTuple
extends QueryFileTuple {
    Object connectionType;
    Object extendedInfos;
    Object fileHash;
    Object fileLength;
    Object fileName;
    Object freeSlots;
    Object ownerID;

    public QueryCompletedFileTuple(String sessionKey, String fileName, String fileHash, Long fileLength, String ownerID, Integer freeSlots, String connectionType, String extendedInfos) {
        super(sessionKey);
        this.fileHash = fileHash;
        this.fileName = fileName;
        this.fileLength = fileLength;
        this.ownerID = ownerID;
        this.freeSlots = freeSlots;
        this.connectionType = "Masked";
        this.extendedInfos = extendedInfos;
    }

    public void decrypt(Cipher c) throws Exception {
        this.fileName = (String)((SealedObject)this.fileName).getObject(c);
        this.fileHash = (String)((SealedObject)this.fileHash).getObject(c);
        this.fileLength = (Long)((SealedObject)this.fileLength).getObject(c);
        this.ownerID = (String)((SealedObject)this.ownerID).getObject(c);
        this.freeSlots = (Integer)((SealedObject)this.freeSlots).getObject(c);
        this.connectionType = (String)((SealedObject)this.connectionType).getObject(c);
        this.extendedInfos = (String)((SealedObject)this.extendedInfos).getObject(c);
    }

    public void encrypt(Cipher c) throws Exception {
        this.fileName = new SealedObject((Serializable)((Object)((String)this.fileName)), c);
        this.fileHash = new SealedObject((Serializable)((Object)((String)this.fileHash)), c);
        this.fileLength = new SealedObject((Long)this.fileLength, c);
        this.ownerID = new SealedObject((Serializable)((Object)((String)this.ownerID)), c);
        this.freeSlots = new SealedObject((Integer)this.freeSlots, c);
        this.connectionType = new SealedObject((Serializable)((Object)((String)this.connectionType)), c);
        this.extendedInfos = new SealedObject((Serializable)((Object)((String)this.extendedInfos)), c);
    }

    public boolean equals(Object o) {
        if (o instanceof FileTupleGroup) {
            return ((FileTupleGroup)o).getHash().equals(this.getFileHash()) && ((FileTupleGroup)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryCompletedFileTuple) {
            return ((QueryCompletedFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryCompletedFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryCompletedFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryPartialFileTuple) {
            return ((QueryPartialFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryPartialFileTuple)o).getSize().longValue() == this.getSize().longValue() && ((QueryPartialFileTuple)o).getOwnerID().equals(this.getOwnerID());
        }
        if (o instanceof QueryRemoteFileTuple) {
            return ((QueryRemoteFileTuple)o).getFileHash().equals(this.getFileHash()) && ((QueryRemoteFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        return o == this;
    }

    public String getConnectionType() {
        if (this.connectionType instanceof String) {
            return (String)this.connectionType;
        }
        return null;
    }

    public String getExtendedInfos() {
        if (this.extendedInfos instanceof String) {
            return (String)this.extendedInfos;
        }
        return null;
    }

    public String getFileHash() {
        if (this.fileHash instanceof String) {
            return (String)this.fileHash;
        }
        return null;
    }

    public String getFileName() {
        if (this.fileName instanceof String) {
            return (String)this.fileName;
        }
        return null;
    }

    public Integer getFreeSlots() {
        if (this.freeSlots instanceof Integer) {
            return (Integer)this.freeSlots;
        }
        return null;
    }

    public String getOwnerID() {
        if (this.ownerID instanceof String) {
            return (String)this.ownerID;
        }
        return null;
    }

    public Long getSize() {
        if (this.fileLength instanceof Long) {
            return (Long)this.fileLength;
        }
        return null;
    }

    public String toString() {
        String result = "Owner ID: " + this.getOwnerID() + "   Free Slots: " + this.getFreeSlots() + "                File Name:";
        int mark = result.length();
        if (this.getFileName().length() < FileTupleGroup.maxNameLengthToDisplay) {
            result = result + " " + this.getFileName();
            while (result.length() < mark + FileTupleGroup.maxNameLengthToDisplay) {
                result = result + " ";
            }
        } else {
            result = result + " " + this.getFileName().substring(0, FileTupleGroup.maxNameLengthToDisplay - 1);
        }
        result = result + " " + this.getExtendedInfos();
        return result;
    }
}

