/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.query;

import ants.p2p.query.QueryCompletedFileTuple;
import ants.p2p.query.QueryFileTuple;
import ants.p2p.query.QueryPartialFileTuple;
import ants.p2p.query.QueryRemoteFileTuple;
import java.util.ArrayList;
import java.util.Date;

public class FileTupleGroup {
    String hash;
    public static int maxNameLengthToDisplay = 50;
    Long size;
    public ArrayList tuples;

    public FileTupleGroup(String hash, Long size) {
        this.hash = hash;
        this.size = size;
        this.tuples = new ArrayList();
    }

    public boolean equals(Object o) {
        if (o instanceof FileTupleGroup) {
            return ((FileTupleGroup)o).getHash().equals(this.getHash()) && ((FileTupleGroup)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryCompletedFileTuple) {
            return ((QueryCompletedFileTuple)o).getFileHash().equals(this.getHash()) && ((QueryCompletedFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryPartialFileTuple) {
            return ((QueryPartialFileTuple)o).getFileHash().equals(this.getHash()) && ((QueryPartialFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        if (o instanceof QueryRemoteFileTuple) {
            return ((QueryRemoteFileTuple)o).getFileHash().equals(this.getHash()) && ((QueryRemoteFileTuple)o).getSize().longValue() == this.getSize().longValue();
        }
        return o == this;
    }

    public String getHash() {
        return this.hash;
    }

    public Long getSize() {
        return this.size;
    }

    public String sizeToString(double dSize) {
        int index;
        double currentSize = dSize;
        int x = 0;
        while (dSize > 1.0 && x < 4) {
            dSize /= Math.pow(2.0, 20.0);
            ++x;
        }
        String suffix = " bytes";
        String size = currentSize + suffix;
        if (x == 2) {
            suffix = " Mb";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 20.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        if (x == 3) {
            suffix = " Gb";
            size = new Double(currentSize * 1.0 / Math.pow(2.0, 30.0)).toString();
            index = size.indexOf(".");
            if (index >= 0) {
                size = size.substring(0, index + 2);
            }
            size = size + suffix;
        }
        return size;
    }

    public String toString() {
        int owners = this.tuples.size();
        if (this.tuples.size() == 1 && this.tuples.get(0) instanceof QueryRemoteFileTuple) {
            owners = 0;
        }
        String result = this.getHash() + "  Owners: " + owners;
        while (result.length() < 50) {
            result = result + " ";
        }
        result = result + "  " + this.sizeToString(this.getSize().longValue());
        result = result + " ";
        while (result.length() < 70) {
            result = result + " ";
        }
        int mark = result.length();
        if (((QueryFileTuple)this.tuples.get(0)).getFileName().length() < maxNameLengthToDisplay) {
            result = result + " " + ((QueryFileTuple)this.tuples.get(0)).getFileName();
            while (result.length() < mark + maxNameLengthToDisplay) {
                result = result + " ";
            }
        } else {
            result = result + " " + ((QueryFileTuple)this.tuples.get(0)).getFileName().substring(0, maxNameLengthToDisplay - 1);
        }
        result = this.tuples.size() == 1 && this.tuples.get(0) instanceof QueryRemoteFileTuple ? result + " [Last seen on: " + new Date(((QueryRemoteFileTuple)this.tuples.get(0)).getlastTimeSeen()) + "]    " + ((QueryFileTuple)this.tuples.get(0)).getExtendedInfos() : result + " " + ((QueryFileTuple)this.tuples.get(0)).getExtendedInfos();
        return result;
    }
}

