/*
 * Decompiled with CFR 0.152.
 */
package ants.p2p.http;

import ants.p2p.MessageWrapper;
import ants.p2p.http.HttpProxy;
import ants.p2p.http.HttpRequestMessage;
import ants.p2p.http.HttpRequestSenderWatchDog;
import ants.p2p.http.HttpResponsePartMessage;
import ants.p2p.http.HttpTransferEndControlMessage;
import ants.p2p.security.EndpointSecurityManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class HttpRequestSender
extends Thread
implements PropertyChangeListener {
    static Logger _logger = Logger.getLogger((class$ants$p2p$http$HttpRequestSender == null ? (class$ants$p2p$http$HttpRequestSender = HttpRequestSender.class$("ants.p2p.http.HttpRequestSender")) : class$ants$p2p$http$HttpRequestSender).getName());
    static /* synthetic */ Class class$ants$p2p$http$HttpRequestSender;
    int currentReceivedId = -1;
    HttpRequestMessage httpRequestMessage = null;
    InputStream is;
    OutputStream os;
    HttpProxy proxy;
    Socket s = null;
    HttpRequestSenderWatchDog watchDog;

    public HttpRequestSender(Socket s, HttpProxy proxy) {
        this.proxy = proxy;
        try {
            this.s = s;
            this.is = s.getInputStream();
            this.os = s.getOutputStream();
        }
        catch (Exception e) {
            _logger.error("Initialization error", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public HttpRequestMessage getHttpRequestMessage() {
        return this.httpRequestMessage;
    }

    public void propertyChange(PropertyChangeEvent e) {
        try {
            if (e.getPropertyName().equals("httpResponsePart")) {
                if (e.getNewValue() instanceof HttpResponsePartMessage && ((HttpResponsePartMessage)e.getNewValue()).getRequest().equals(this.getHttpRequestMessage()) && ((HttpResponsePartMessage)e.getNewValue()).getId() > this.currentReceivedId) {
                    _logger.info("Received HTTP response part: local " + this.s.getLocalPort() + " remote " + this.s.getPort());
                    this.watchDog.trigger();
                    if (!this.s.isOutputShutdown()) {
                        this.os.write(((HttpResponsePartMessage)e.getNewValue()).getBody());
                    }
                    ++this.currentReceivedId;
                }
            } else if (e.getPropertyName().equals("httpResponseEnd") && e.getNewValue() instanceof HttpTransferEndControlMessage && ((HttpTransferEndControlMessage)e.getNewValue()).getHttpRequestMessage().equals(this.getHttpRequestMessage())) {
                _logger.info("Received HTTP response end: local " + this.s.getLocalPort() + " remote " + this.s.getPort());
                this.watchDog.stop();
                this.proxy.removeHandler(this);
                this.s.shutdownOutput();
                this.s.close();
            }
        }
        catch (Exception ex) {
            _logger.error("Error in handling http response", ex);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.watchDog = new HttpRequestSenderWatchDog(this);
            _logger.debug("Getting request from browser...");
            ArrayList<byte[]> byteList = new ArrayList<byte[]>();
            int total = 0;
            do {
                byte[] bytes = new byte[1024];
                int n = this.is.read(bytes);
                total += n;
                byteList.add(bytes);
            } while (this.is.available() > 0);
            this.s.shutdownInput();
            _logger.debug("Merging request parts...");
            byte[] request = new byte[total];
            int copied = 0;
            int x = 0;
            while (x < byteList.size()) {
                byte[] currentBytesList = (byte[])byteList.get(x);
                int k = 0;
                boolean bl = true;
                do {
                    if (!bl || (bl = false) || !true) {
                        request[copied] = currentBytesList[k];
                        ++k;
                        ++copied;
                    }
                    if (k >= currentBytesList.length) break;
                } while (copied < total);
                ++x;
            }
            _logger.debug("Show Browser Request:");
            String browserRequest = "";
            int x2 = 0;
            while (x2 < request.length) {
                browserRequest = browserRequest + (char)request[x2];
                ++x2;
            }
            _logger.debug(browserRequest);
            _logger.debug("Sending request...");
            EndpointSecurityManager esm = this.proxy.getWarriorAnt().getOutputSecureConnectionManager(this.proxy.getNodeID());
            if (esm == null) {
                this.s.close();
                throw new Exception("No secure connection avaiable with endpoint " + this.proxy.getNodeID());
            }
            this.httpRequestMessage = new HttpRequestMessage(request);
            this.httpRequestMessage.encrypt(esm.getCipherEnc());
            MessageWrapper wm = this.proxy.getWarriorAnt().sendMessage(this.httpRequestMessage, this.proxy.getNodeID(), true, false);
            while (this.proxy.getWarriorAnt().myMessages.contains(wm)) {
                Thread.sleep(1000L);
            }
            if (!this.proxy.getWarriorAnt().failedMessages.contains(wm)) return;
            this.httpRequestMessage.decrypt(esm.getCipherDec());
            this.proxy.getWarriorAnt().failedMessages.remove(wm);
            _logger.debug(this.proxy.getWarriorAnt().getId() + ": Error in sending HttpRequestMessage" + " - Cannot send pull request to id " + this.httpRequestMessage.getDest());
            this.proxy.getWarriorAnt().propertyChangeSupport.firePropertyChange("httpRequestError", null, this.httpRequestMessage);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean testAddress(String address) {
        address = address.toLowerCase();
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (address.length() != 16) {
            return false;
        }
        int x = 0;
        while (x < address.length()) {
            if (Arrays.binarySearch(hexChar, address.charAt(x)) < 0) {
                return false;
            }
            ++x;
        }
        return true;
    }
}

